/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.gateway.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Configuration
public class SwaggerResourceConfig
implements SwaggerResourcesProvider {
    @Autowired
    private DiscoveryClient discoveryClient;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static final String API_URI = "/v2/api-docs";

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        List<String> routeHosts = this.discoveryClient.getServices().stream().filter(serveName -> !serveName.equals(this.applicationName)).collect(Collectors.toList());
        HashSet existsServer = new HashSet();
        routeHosts.forEach(host -> {
            String url = "/" + host + API_URI;
            if (!existsServer.contains(url)) {
                existsServer.add(url);
                SwaggerResource swaggerResource = new SwaggerResource();
                swaggerResource.setUrl(url);
                swaggerResource.setName(host);
                swaggerResource.setSwaggerVersion("2.0");
                resources.add(swaggerResource);
            }
        });
        return resources;
    }
}

