/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.gateway.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;

@Component
public class HttpBasicGatewayFilter
extends AbstractGatewayFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpBasicGatewayFilter.class);

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            if (this.hasAuth(exchange)) {
                return chain.filter(exchange);
            }
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
            response.getHeaders().add("WWW-Authenticate", "Basic Realm=\"hussar\"");
            return response.setComplete();
        };
    }

    private boolean hasAuth(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String auth = request.getHeaders().getFirst("Authorization");
        log.info("Basic\u8ba4\u8bc1\u4fe1\u606f\u4e3a\uff1a{}", (Object)auth);
        return true;
    }
}

