/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.gateway.filter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.platform.cloud.common.constant.enums.CaptchaTypeEnum;
import com.jxdinfo.hussar.platform.cloud.common.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;

@Component
public class ValidateCodeGatewayFilter
extends AbstractGatewayFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeGatewayFilter.class);
    private final ObjectMapper objectMapper;
    private final RedisTemplate redisTemplate;

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            if (!StrUtil.containsAnyIgnoreCase((CharSequence)request.getURI().getPath(), (CharSequence[])new CharSequence[]{"/oauth/token", "/mobile/token/sms"})) {
                return chain.filter(exchange);
            }
            String grantType = (String)request.getQueryParams().getFirst((Object)"grant_type");
            if (StrUtil.equals((CharSequence)"refresh_token", (CharSequence)grantType)) {
                return chain.filter(exchange);
            }
            if (!this.isCheckCaptchaClient(request)) {
                return chain.filter(exchange);
            }
            return chain.filter(exchange);
        };
    }

    private boolean isCheckCaptchaClient(ServerHttpRequest request) {
        String header = request.getHeaders().getFirst("Authorization");
        String clientId = SecurityUtils.extractClientId((String)header).orElse(null);
        String tenantId = request.getHeaders().getFirst("TENANT-ID");
        String key = String.format("%s:%s:%s", StrUtil.isBlank((CharSequence)tenantId) ? "0l" : tenantId, "client_config_flag", clientId);
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        Object val = this.redisTemplate.opsForValue().get((Object)key);
        if (val == null) {
            return true;
        }
        JSONObject information = JSONUtil.parseObj((String)val.toString());
        return !StrUtil.equals((CharSequence)CaptchaTypeEnum.OFF.getType(), (CharSequence)information.getStr((Object)"captcha_flag"));
    }

    public ValidateCodeGatewayFilter(ObjectMapper objectMapper, RedisTemplate redisTemplate) {
        this.objectMapper = objectMapper;
        this.redisTemplate = redisTemplate;
    }
}

