/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.gateway.filter;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.jxdinfo.hussar.platform.cloud.common.constant.enums.EncTypeEnum;
import com.jxdinfo.hussar.platform.cloud.common.utils.SecurityUtils;
import com.jxdinfo.hussar.platform.cloud.gateway.config.GatewayConfigProperties;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class PasswordDecoderFilter
extends AbstractGatewayFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(PasswordDecoderFilter.class);
    private final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();
    private static final String PASSWORD = "password";
    private static final String KEY_ALGORITHM = "AES";
    private final RedisTemplate redisTemplate;
    private final GatewayConfigProperties gatewayConfig;

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            if (!StrUtil.containsAnyIgnoreCase((CharSequence)request.getURI().getPath(), (CharSequence[])new CharSequence[]{"/oauth/token"})) {
                return chain.filter(exchange);
            }
            String grantType = (String)request.getQueryParams().getFirst((Object)"grant_type");
            if (StrUtil.equals((CharSequence)"refresh_token", (CharSequence)grantType)) {
                return chain.filter(exchange);
            }
            if (!this.isEncClient(request)) {
                return chain.filter(exchange);
            }
            Class<String> inClass = String.class;
            Class<String> outClass = String.class;
            ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
            Mono modifiedBody = serverRequest.bodyToMono(inClass).flatMap(this.decryptAES());
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, outClass);
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.remove((Object)"Content-Length");
            headers.set("Content-Type", "application/x-www-form-urlencoded");
            CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers);
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                ServerHttpRequestDecorator decorator = this.decorate(exchange, headers, outputMessage);
                return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
            }));
        };
    }

    private boolean isEncClient(ServerHttpRequest request) {
        String header = request.getHeaders().getFirst("Authorization");
        String clientId = SecurityUtils.extractClientId((String)header).orElse(null);
        String tenantId = request.getHeaders().getFirst("TENANT-ID");
        String key = String.format("%s:%s:%s", StrUtil.isBlank((CharSequence)tenantId) ? "0l" : tenantId, "client_config_flag", clientId);
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        Object val = this.redisTemplate.opsForValue().get((Object)key);
        if (val == null) {
            return true;
        }
        JSONObject information = JSONUtil.parseObj((String)val.toString());
        return !StrUtil.equals((CharSequence)EncTypeEnum.NO.getType(), (CharSequence)information.getStr((Object)"enc_flag"));
    }

    private Function decryptAES() {
        return s -> {
            AES aes = new AES(Mode.CBC, Padding.ZeroPadding, (SecretKey)new SecretKeySpec(this.gatewayConfig.getEncodeKey().getBytes(), KEY_ALGORITHM), new IvParameterSpec(this.gatewayConfig.getEncodeKey().getBytes()));
            Map inParamsMap = HttpUtil.decodeParamMap((String)((String)s), (Charset)CharsetUtil.CHARSET_UTF_8);
            if (inParamsMap.containsKey(PASSWORD)) {
                byte[] result = aes.decrypt(Base64.decode((byte[])((String)inParamsMap.get(PASSWORD)).getBytes(StandardCharsets.UTF_8)));
                String password = new String(result, StandardCharsets.UTF_8);
                inParamsMap.put(PASSWORD, password.trim());
            } else {
                log.error("\u975e\u6cd5\u8bf7\u6c42\u6570\u636e:{}", s);
            }
            return Mono.just((Object)HttpUtil.toParams((Map)inParamsMap));
        };
    }

    private ServerHttpRequestDecorator decorate(ServerWebExchange exchange, final HttpHeaders headers, final CachedBodyOutputMessage outputMessage) {
        return new ServerHttpRequestDecorator(exchange.getRequest()){

            public HttpHeaders getHeaders() {
                long contentLength = headers.getContentLength();
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.putAll((Map)super.getHeaders());
                if (contentLength > 0L) {
                    httpHeaders.setContentLength(contentLength);
                } else {
                    httpHeaders.set("Transfer-Encoding", "chunked");
                }
                return httpHeaders;
            }

            public Flux<DataBuffer> getBody() {
                return outputMessage.getBody();
            }
        };
    }

    public PasswordDecoderFilter(RedisTemplate redisTemplate, GatewayConfigProperties gatewayConfig) {
        this.redisTemplate = redisTemplate;
        this.gatewayConfig = gatewayConfig;
    }
}

