/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.auth.service;

import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.SysAuthClientModel;
import com.jxdinfo.hussar.platform.cloud.business.system.authentication.feign.RemoteClientDetailsService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityClientModelDetailService;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthSecurityClientModelDetailServiceImpl
implements AuthSecurityClientModelDetailService {
    @Autowired
    private RemoteClientDetailsService remoteClientDetailsService;

    public ClientModelDetails loadClientModelByClientId(String clientId, String clientPassword) {
        if (HussarUtils.isEmpty((Object)clientId)) {
            throw new SecurityOAuth2Exception("\u83b7\u53d6client\u5931\u8d25");
        }
        ClientModelDetails clientModelDetailsCache = (ClientModelDetails)HussarCacheUtil.get((String)"security_client_cache", (Object)("security_client_key:" + clientId));
        if (HussarUtils.isNotEmpty((Object)clientModelDetailsCache)) {
            return clientModelDetailsCache;
        }
        SysAuthClientModel sysAuthClientModel = new SysAuthClientModel();
        sysAuthClientModel.setClientId(clientId);
        sysAuthClientModel.setClientSecret(clientPassword);
        ApiResponse apiResponse = this.remoteClientDetailsService.getClientModelByClientId(sysAuthClientModel);
        if (HussarUtils.isEmpty((Object)apiResponse) || apiResponse.getCode() != ResultCode.SUCCESS.getCode() || HussarUtils.isEmpty((Object)apiResponse.getData())) {
            throw new SecurityOAuth2Exception(apiResponse.getMsg());
        }
        ClientModelDetails clientModelDetail = (ClientModelDetails)apiResponse.getData();
        HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:" + clientId), (Object)clientModelDetail);
        return clientModelDetail;
    }
}

