/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.boot.base.system.user.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.platform.boot.base.system.api.user.model.SysUsers;
import com.jxdinfo.hussar.platform.boot.base.system.user.dao.SysUsersMapper;
import com.jxdinfo.hussar.platform.boot.base.system.user.service.SysUserService;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.log.trace.annotation.Trace;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysUserServiceImpl
extends HussarServiceImpl<SysUsersMapper, SysUsers>
implements SysUserService {
    private static Logger logger = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    @Override
    @Trace
    public UserDetails getLoginUserDetails(LoginUser loginUser) {
        if (HussarUtils.isEmpty((Object)loginUser)) {
            throw new HussarException("\u767b\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUsers sysUsers = (SysUsers)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)loginUser.getUserName()));
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            UserDetails userDetails = new UserDetails();
            userDetails.setMaxSameCount(Integer.valueOf(3));
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            userDetails.addExtendUserMap("dsName", (Object)"slave_1");
            logger.info("\u767b\u5f55\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u6210\u529f\uff1a{}", (Object)userDetails);
            return userDetails;
        }
        return null;
    }

    @Override
    public SysUsers getSysUser() {
        return null;
    }

    @Override
    public Boolean checkUserPassword(String password) {
        if (HussarUtils.isEmpty((Object)password)) {
            throw new HussarException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u8f93\u5165\u5bc6\u7801\u4fe1\u606f\u4e3a\u7a7a");
        }
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isEmpty((Object)userDetails)) {
            throw new HussarException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String account = (String)userDetails.getExtendUserMap().get("account");
        SysUsers sysUsers = (SysUsers)super.getOne((Wrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account));
        if (HussarUtils.isEmpty((Object)sysUsers)) {
            throw new HussarException("\u8d26\u53f7\u4e3a: " + account + " \u7684\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        return encPwd.equalsIgnoreCase(sysUsers.getPassword());
    }
}

