/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.boot.base.system.dict.controller;

import com.jxdinfo.hussar.platform.boot.base.system.api.dict.dto.DictDto;
import com.jxdinfo.hussar.platform.boot.base.system.api.dict.model.Dict;
import com.jxdinfo.hussar.platform.boot.base.system.dict.service.SysDictService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import io.swagger.annotations.Api;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dict"})
@Api(value="dict", tags={"\u5b57\u5178\u7ba1\u7406"})
public class DictController {
    private static Logger LOGGER = LoggerFactory.getLogger(DictController.class);
    @Autowired
    private SysDictService dictService;

    @HussarTokenDs
    @GetMapping(value={"/getDictById/{id}"})
    public ApiResponse<Dict> getDictById(@PathVariable Integer id) {
        Dict byId = (Dict)this.dictService.getById(id);
        return ApiResponse.success((Object)byId, (String)"\u64cd\u4f5c\u6210\u529f\u8fc7");
    }

    @GetMapping(value={"/getDictList"})
    public ApiResponse<List<Dict>> getDictList() {
        List dicts = this.dictService.list();
        return ApiResponse.success((Object)dicts);
    }

    @GetMapping(value={"/getDictDetail/{id}"})
    public ApiResponse<String> getDictDetail(@PathVariable Integer id) {
        return ApiResponse.success((String)this.dictService.getDictDetail(id));
    }

    @PostMapping(value={"/updateDict"})
    public ApiResponse<Boolean> updateDict(@RequestBody DictDto dictDto) {
        return ApiResponse.success((Object)this.dictService.updateDict(dictDto));
    }
}

