/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.resolve.type;

import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaClassType;

public enum JavaPrimitiveType implements JavaActualType
{
    BYTE("byte", Byte.TYPE, Byte.class),
    BOOLEAN("boolean", Boolean.TYPE, Boolean.class),
    SHORT("short", Short.TYPE, Short.class),
    CHAR("char", Character.TYPE, Character.class),
    INT("int", Integer.TYPE, Integer.class),
    FLOAT("float", Float.TYPE, Float.class),
    LONG("long", Long.TYPE, Long.class),
    DOUBLE("double", Double.TYPE, Double.class);

    private final String name;
    private final Class<?> primitiveType;
    private final Class<?> objectType;

    private JavaPrimitiveType(String name, Class<?> primitiveType, Class<?> objectType) {
        this.name = name;
        this.primitiveType = primitiveType;
        this.objectType = objectType;
    }

    public JavaClassType toClassType() {
        return JavaClassType.of(this.objectType.getName());
    }

    @Override
    public boolean isSameType(JavaActualType other) {
        return this.equals(other);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String toString() {
        return this.getName();
    }
}

