/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.resolve.service;

import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendInvokeConvention;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendMethodParameter;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LogicBackendServiceMethod {
    private final LogicBackendInvokeConvention invokeConvention;
    private final String engineBusinessId;
    private final List<String> engineParameters;
    private final String mvcServiceClass;
    private final String mvcServiceMethod;
    private final JavaActualType mvcReturnType;
    private final List<LogicBackendMethodParameter> mvcParameters;

    private LogicBackendServiceMethod(LogicBackendInvokeConvention invokeConvention, String engineBusinessId, List<String> engineParameters, String mvcServiceClass, String mvcServiceMethod, JavaActualType mvcReturnType, List<LogicBackendMethodParameter> mvcParameters) {
        this.invokeConvention = invokeConvention;
        this.engineBusinessId = engineBusinessId;
        this.engineParameters = engineParameters;
        this.mvcServiceClass = mvcServiceClass;
        this.mvcServiceMethod = mvcServiceMethod;
        this.mvcReturnType = mvcReturnType;
        this.mvcParameters = mvcParameters;
    }

    public static LogicBackendServiceMethod engineArgsSignatureOf(String businessId, List<String> parameters) {
        if (businessId == null || parameters == null) {
            throw new NullPointerException();
        }
        if (businessId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (parameters.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("null method parameter");
        }
        return new LogicBackendServiceMethod(LogicBackendInvokeConvention.ENGINE_ARGUMENTS_AS_PARAMS, businessId, Collections.unmodifiableList(new ArrayList<String>(parameters)), null, null, null, null);
    }

    public static LogicBackendServiceMethod engineBodySignatureOf(String businessId, String body) {
        if (businessId == null || body == null) {
            throw new NullPointerException();
        }
        if (businessId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new LogicBackendServiceMethod(LogicBackendInvokeConvention.ENGINE_BODY_AS_PARAMS, businessId, Collections.singletonList(body), null, null, null, null);
    }

    public static LogicBackendServiceMethod mvcSignatureOf(String serviceClass, String serviceMethod, JavaActualType returnType, List<LogicBackendMethodParameter> parameters) {
        if (serviceClass == null || serviceMethod == null || returnType == null || parameters == null) {
            throw new NullPointerException();
        }
        if (serviceClass.isEmpty() || serviceMethod.isEmpty()) {
            throw new IllegalArgumentException("empty service class or method name");
        }
        if (parameters.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("null method parameter");
        }
        return new LogicBackendServiceMethod(LogicBackendInvokeConvention.MVC, null, null, serviceClass, serviceMethod, returnType, Collections.unmodifiableList(new ArrayList<LogicBackendMethodParameter>(parameters)));
    }

    public LogicBackendInvokeConvention getInvokeConvention() {
        return this.invokeConvention;
    }

    public String getEngineBusinessId() {
        return this.engineBusinessId;
    }

    public List<String> getEngineParameters() {
        return this.engineParameters;
    }

    public String getMvcServiceClass() {
        return this.mvcServiceClass;
    }

    public String getMvcServiceMethod() {
        return this.mvcServiceMethod;
    }

    public JavaActualType getMvcReturnType() {
        return this.mvcReturnType;
    }

    public List<LogicBackendMethodParameter> getMvcParameters() {
        return this.mvcParameters;
    }

    public String toString() {
        String invokeInfo;
        switch (this.invokeConvention) {
            case MVC: {
                invokeInfo = this.mvcReturnType + " " + this.mvcServiceClass + "." + this.mvcServiceMethod + "(" + this.mvcParameters.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
                break;
            }
            case ENGINE_ARGUMENTS_AS_PARAMS: {
                invokeInfo = "services['" + this.engineBusinessId + "']({" + String.join((CharSequence)", ", this.engineParameters) + "})";
                break;
            }
            case ENGINE_BODY_AS_PARAMS: {
                invokeInfo = "services['" + this.engineBusinessId + "']({" + this.engineParameters.stream().map(param -> "..." + param).collect(Collectors.joining(", ")) + "})";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return "ModelMethodSignature<" + (Object)((Object)this.invokeConvention) + ", " + invokeInfo + ">";
    }
}

