/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.resolve.type;

import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaClassType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaVoidType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class JavaParameterizedType
implements JavaActualType {
    private final JavaClassType rawType;
    private final List<JavaActualType> typeParameters;

    private JavaParameterizedType(JavaClassType rawType, List<JavaActualType> typeParameters) {
        if (rawType == null || typeParameters == null) {
            throw new NullPointerException();
        }
        if (typeParameters.size() == 0) {
            throw new IllegalArgumentException("empty type parameters");
        }
        if (typeParameters.stream().anyMatch(type -> type == null || type.getClass() == JavaVoidType.class)) {
            throw new IllegalArgumentException("null or void as type parameter");
        }
        this.rawType = rawType;
        this.typeParameters = Collections.unmodifiableList(typeParameters);
    }

    public static JavaParameterizedType of(String rawQualifiedClass, JavaActualType ... typeParameters) {
        return JavaParameterizedType.of(JavaClassType.of(rawQualifiedClass), typeParameters);
    }

    public static JavaParameterizedType of(JavaClassType rawType, JavaActualType ... typeParameters) {
        if (typeParameters == null) {
            throw new NullPointerException();
        }
        return new JavaParameterizedType(rawType, Arrays.asList(typeParameters));
    }

    public static JavaParameterizedType of(String rawQualifiedClass, List<JavaActualType> typeParameters) {
        return JavaParameterizedType.of(JavaClassType.of(rawQualifiedClass), typeParameters);
    }

    public static JavaParameterizedType of(JavaClassType rawType, List<JavaActualType> typeParameters) {
        return new JavaParameterizedType(rawType, new ArrayList<JavaActualType>(typeParameters));
    }

    @Override
    public String getName() {
        return this.getRawType().getName() + "<" + this.getTypeParameters().stream().map(JavaActualType::getName).collect(Collectors.joining(", ")) + ">";
    }

    @Override
    public boolean isSameType(JavaActualType other) {
        if (!(other instanceof JavaParameterizedType)) {
            return false;
        }
        if (!this.getRawType().isSameType(((JavaParameterizedType)other).getRawType())) {
            return false;
        }
        List<JavaActualType> typeParameters = this.getTypeParameters();
        List<JavaActualType> otherTypeParameters = ((JavaParameterizedType)other).getTypeParameters();
        if (typeParameters.size() != otherTypeParameters.size()) {
            return false;
        }
        for (int i = 0; i < typeParameters.size(); ++i) {
            if (typeParameters.get(i).isSameType(otherTypeParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    public JavaClassType getRawType() {
        return this.rawType;
    }

    public List<JavaActualType> getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        return this.rawType + "<" + this.typeParameters.stream().map(Object::toString).collect(Collectors.joining(", ")) + ">";
    }
}

