/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.resolve.type;

import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import java.util.Objects;
import java.util.regex.Pattern;

public final class JavaClassType
implements JavaActualType {
    private static final Pattern JAVA_QUALIFIED_CLASS = Pattern.compile("^(?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)+(?:[A-Z_][a-zA-Z0-9_]*\\$)*[A-Z_][a-zA-Z0-9_]*$");
    private final String qualifiedClass;

    private JavaClassType(String qualifiedClass) {
        if (qualifiedClass == null) {
            throw new NullPointerException();
        }
        if (!JAVA_QUALIFIED_CLASS.matcher(qualifiedClass).matches()) {
            throw new IllegalArgumentException("bad qualified class: " + qualifiedClass);
        }
        this.qualifiedClass = qualifiedClass;
    }

    public static JavaClassType of(String qualifiedClass) {
        return new JavaClassType(qualifiedClass);
    }

    @Override
    public String getName() {
        return this.getQualifiedClass();
    }

    @Override
    public boolean isSameType(JavaActualType other) {
        return other instanceof JavaClassType && Objects.equals(this.getQualifiedClass(), ((JavaClassType)other).getQualifiedClass());
    }

    public String getQualifiedClass() {
        return this.qualifiedClass;
    }

    public String toString() {
        return this.getName();
    }
}

