/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.reference.part;

import com.jxdinfo.hussar.logic.structure.reference.part.LogicReferenceComponent;
import com.jxdinfo.hussar.logic.structure.reference.part.LogicReferencePart;
import java.util.Objects;

public final class LogicIndexReferencePart
implements LogicReferenceComponent<Integer> {
    private final int index;

    public LogicIndexReferencePart(int index) {
        this.index = index;
    }

    public LogicIndexReferencePart(Integer index) {
        if (index == null) {
            throw new NullPointerException();
        }
        this.index = index;
    }

    @Override
    public LogicReferencePart<Integer> copy() {
        return new LogicIndexReferencePart(this.index);
    }

    @Override
    public String getComponentCategory() {
        return "index";
    }

    @Override
    public Class<Integer> getSymbolType() {
        return Integer.class;
    }

    @Override
    public Integer getSymbol() {
        return this.index;
    }

    @Override
    public String representAsComponent() {
        return "[" + this.index + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicIndexReferencePart that = (LogicIndexReferencePart)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return Objects.hashCode(this.index);
    }

    public String toString() {
        return "<index " + this.index + ">";
    }
}

