/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.reference;

import com.jxdinfo.hussar.logic.structure.reference.part.LogicReferenceComponent;
import com.jxdinfo.hussar.logic.structure.reference.part.LogicReferenceOrigin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LogicVariableReference {
    private final LogicReferenceOrigin<?> origin;
    private final List<LogicReferenceComponent<?>> components;

    private LogicVariableReference(LogicReferenceOrigin<?> origin, List<LogicReferenceComponent<?>> components) {
        if (origin == null) {
            throw new NullPointerException();
        }
        this.origin = origin;
        this.components = components;
    }

    public static LogicVariableReference of(String ... chain) {
        return LogicVariableReference.of(chain != null ? Arrays.asList(chain) : Collections.emptyList());
    }

    public static LogicVariableReference of(List<String> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new NullPointerException();
        }
        LogicReferenceOrigin<?> origin = LogicReferenceOrigin.of(null, chain.get(0));
        List components = chain.subList(1, chain.size()).stream().map(symbol -> LogicReferenceComponent.of(null, symbol)).collect(Collectors.toList());
        return new LogicVariableReference(origin, components.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(components));
    }

    public static LogicVariableReference of(LogicReferenceOrigin<?> origin) {
        return new LogicVariableReference(origin, null);
    }

    public static LogicVariableReference of(LogicReferenceOrigin<?> origin, LogicReferenceComponent<?> ... components) {
        return LogicVariableReference.of(origin, components != null ? Arrays.asList(components) : null);
    }

    public static LogicVariableReference of(LogicReferenceOrigin<?> origin, List<LogicReferenceComponent<?>> components) {
        if (origin == null) {
            throw new NullPointerException("origin");
        }
        if (components == null || components.isEmpty()) {
            return new LogicVariableReference(origin, Collections.emptyList());
        }
        if (components.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("components");
        }
        return new LogicVariableReference(origin, Collections.unmodifiableList(new ArrayList(components)));
    }

    public LogicVariableReference copy() {
        return new LogicVariableReference(this.origin, this.components);
    }

    public boolean isSimple() {
        return this.components == null || this.components.isEmpty();
    }

    public int getDepth() {
        return this.components != null ? this.components.size() : 0;
    }

    public LogicReferenceOrigin<?> getOrigin() {
        return this.origin;
    }

    public List<LogicReferenceComponent<?>> getComponents() {
        return this.components != null ? this.components : Collections.emptyList();
    }

    public LogicReferenceComponent<?> getComponent(int index) {
        if (index < 0 || index >= this.getDepth()) {
            return null;
        }
        return this.components.get(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicVariableReference that = (LogicVariableReference)o;
        return Objects.equals(this.origin, that.origin) && Objects.equals(this.getComponents(), that.getComponents());
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.getComponents());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.origin.representAsOrigin());
        for (LogicReferenceComponent<?> component : this.getComponents()) {
            builder.append(component.representAsComponent());
        }
        return builder.toString();
    }
}

