/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.resolve.service;

import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaVoidType;
import java.util.regex.Pattern;

public final class LogicBackendMethodParameter {
    private static final Pattern JAVA_IDENTIFIER = Pattern.compile("^[a-zA-Z_$][a-zA-Z0-9_$]*$");
    private final String name;
    private final JavaActualType type;

    private LogicBackendMethodParameter(String name, JavaActualType type) {
        if (name == null || type == null) {
            throw new NullPointerException();
        }
        if (!JAVA_IDENTIFIER.matcher(name).matches()) {
            throw new IllegalArgumentException("illegal parameter name: " + name);
        }
        if (type.getClass() == JavaVoidType.class) {
            throw new IllegalArgumentException("void parameter type");
        }
        this.name = name;
        this.type = type;
    }

    public static LogicBackendMethodParameter of(String name, JavaActualType type) {
        return new LogicBackendMethodParameter(name, type);
    }

    public String getName() {
        return this.name;
    }

    public JavaActualType getType() {
        return this.type;
    }

    public String toString() {
        return this.type + " " + this.name;
    }
}

