/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.service.impl;

import com.jxdinfo.hussar.logic.engine.api.SourceEventListener;
import com.jxdinfo.hussar.logic.engine.constants.SourceNamespace;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.service.LogicSourceEntityService;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SourceServiceImpl
implements SourceService {
    @Autowired
    LogicSourceEntityService logicSourceEntityService;
    @Autowired(required=false)
    SourceEventListener sourceEventListener;

    @HussarTransactional
    public List<LogicSourceEntity> list(SourceNamespace namespace, Collection<String> names) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        return this.list(namespace.name(), names);
    }

    protected List<LogicSourceEntity> list(String namespace, Collection<String> names) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (CollectionUtils.isEmpty(names)) {
            return Collections.emptyList();
        }
        return this.logicSourceEntityService.listByNames(namespace, new TreeSet<String>(names));
    }

    public LogicSourceEntity get(SourceNamespace namespace, String name) {
        if (namespace == null || name == null) {
            throw new NullPointerException();
        }
        return this.get(namespace.name(), name);
    }

    protected LogicSourceEntity get(String namespace, String name) {
        if (namespace == null || name == null) {
            throw new NullPointerException();
        }
        return this.logicSourceEntityService.getByName(namespace, name);
    }

    @HussarTransactional
    public boolean saveOrUpdate(SourceNamespace namespace, String name, String content) {
        if (namespace == null || name == null || content == null) {
            throw new NullPointerException();
        }
        return this.saveOrUpdate(namespace.name(), name, content);
    }

    protected boolean saveOrUpdate(String namespace, String name, String content) {
        boolean success;
        if (namespace == null || name == null || content == null) {
            throw new NullPointerException();
        }
        LogicSourceEntity entity = this.logicSourceEntityService.getByName(namespace, name);
        if (entity == null) {
            entity = new LogicSourceEntity();
            entity.setNamespace(namespace);
            entity.setSourceCode(name);
            entity.setSourceContent(content);
            success = this.logicSourceEntityService.save(entity);
            if (success) {
                this.afterSave(entity.getNamespace(), entity.getSourceCode());
            }
        } else {
            entity.setSourceContent(content);
            success = this.logicSourceEntityService.updateById(entity);
            if (success) {
                this.afterUpdate(entity.getNamespace(), entity.getSourceCode());
            }
        }
        return success;
    }

    @HussarTransactional
    public boolean delete(SourceNamespace namespace, String name) {
        if (namespace == null || name == null) {
            throw new NullPointerException();
        }
        return this.delete(namespace.name(), name);
    }

    protected boolean delete(String namespace, String name) {
        if (namespace == null || name == null) {
            throw new NullPointerException();
        }
        LogicSourceEntity entity = this.logicSourceEntityService.getByName(namespace, name);
        boolean success = false;
        if (entity != null && (success = this.logicSourceEntityService.removeById(entity))) {
            this.afterDelete(entity.getNamespace(), entity.getSourceCode());
        }
        return success;
    }

    protected void afterSave(String namespace, String name) {
        if (this.sourceEventListener != null) {
            this.sourceEventListener.onSave(namespace, Collections.singletonList(name));
        }
    }

    protected void afterUpdate(String namespace, String name) {
        if (this.sourceEventListener != null) {
            this.sourceEventListener.onUpdate(namespace, Collections.singletonList(name));
        }
    }

    protected void afterDelete(String namespace, String name) {
        if (this.sourceEventListener != null) {
            this.sourceEventListener.onDelete(namespace, Collections.singletonList(name));
        }
    }
}

