/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.service.impl;

import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.SourceEventListener;
import com.jxdinfo.hussar.logic.engine.constants.SourceNamespace;
import com.jxdinfo.hussar.logic.engine.service.LogicEngineMessageService;
import java.util.Collection;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SourceEventListenerImpl
implements SourceEventListener,
InitializingBean {
    private static final String EVENT_EVICT = "evict";
    @Autowired
    LogicRuntime logicRuntime;
    @Autowired
    LogicEngineMessageService logicEngineMessageService;

    public void afterPropertiesSet() {
        this.logicEngineMessageService.listen(EVENT_EVICT, this::handleEvictEvent);
    }

    private void broadcastEvictEvent(String name) {
        this.logicEngineMessageService.broadcast(EVENT_EVICT, name);
    }

    private void handleEvictEvent(Object name) {
        if (name instanceof String) {
            this.logicRuntime.remove((String)name);
        }
    }

    public void onSave(String namespace, Collection<String> names) {
    }

    public void onUpdate(String namespace, Collection<String> names) {
        names.forEach(name -> this.onUpdate(namespace, (String)name));
    }

    public void onDelete(String namespace, Collection<String> names) {
        names.forEach(name -> this.onDelete(namespace, (String)name));
    }

    protected void onUpdate(String namespace, String name) {
        this.onDelete(namespace, name);
    }

    protected void onDelete(String namespace, String name) {
        if (!Objects.equals(SourceNamespace.PROD.name(), namespace)) {
            return;
        }
        this.logicRuntime.remove(name);
        this.broadcastEvictEvent(name);
    }
}

