/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.logic.engine.dao.LogicSourceMapper;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.service.LogicSourceEntityService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.logic.engine.service.impl.logicSourceEntityServiceImpl")
public class LogicSourceEntityServiceImpl
extends HussarServiceImpl<LogicSourceMapper, LogicSourceEntity>
implements LogicSourceEntityService {
    private static final int PARTITION_THRESHOLD = 512;

    @Override
    public LogicSourceEntity getByName(String namespace, String name) {
        if (StringUtil.isEmpty((Object)name)) {
            return null;
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicSourceEntity.class).eq(LogicSourceEntity::getNamespace, (Object)namespace)).eq(LogicSourceEntity::getSourceCode, (Object)name);
        return (LogicSourceEntity)this.getOne((Wrapper)query);
    }

    @Override
    public List<LogicSourceEntity> listByNames(String namespace, Collection<String> names) {
        if (CollectionUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        return this.partitionedInQuery(part -> (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicSourceEntity.class).in(LogicSourceEntity::getSourceCode, part)).eq(LogicSourceEntity::getNamespace, (Object)namespace), names);
    }

    @Override
    public List<LogicSourceEntity> listMetadataByNames(String namespace, Collection<String> names) {
        if (CollectionUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        return this.partitionedInQuery(part -> (LambdaQueryWrapper)((LambdaQueryWrapper)this.createMetadataQuery().eq(LogicSourceEntity::getNamespace, (Object)namespace)).in(LogicSourceEntity::getSourceCode, part), names);
    }

    private LambdaQueryWrapper<LogicSourceEntity> createMetadataQuery() {
        return Wrappers.lambdaQuery(LogicSourceEntity.class).select(new SFunction[]{LogicSourceEntity::getSourceId, LogicSourceEntity::getSourceCode, LogicSourceEntity::getNamespace, HussarBaseEntity::getCreateTime, HussarBaseEntity::getLastTime, HussarBaseEntity::getCreator, HussarBaseEntity::getLastEditor});
    }

    private List<LogicSourceEntity> partitionedInQuery(Function<Collection<?>, LambdaQueryWrapper<LogicSourceEntity>> template, Collection<?> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        List partitions = Lists.partition(new ArrayList(collection), (int)512);
        ArrayList<LogicSourceEntity> merged = new ArrayList<LogicSourceEntity>(collection.size());
        for (List partition : partitions) {
            LambdaQueryWrapper<LogicSourceEntity> query = template.apply(partition);
            List result = this.list((Wrapper)query);
            merged.addAll(result);
        }
        return merged;
    }
}

