/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.service.impl;

import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.properties.HussarLogicEngineProperties;
import com.jxdinfo.hussar.logic.engine.service.LogicEngineThreadPoolProvider;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class LogicEngineThreadPoolProviderImpl
implements LogicEngineThreadPoolProvider,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(LogicEngineThreadPoolProviderImpl.class);
    private static final int DEFAULT_POOL_CORE_SIZE = 2;
    private static final long DEFAULT_EXPIRED_CHECK_INTERVAL = 3600L;
    private ThreadPoolTaskScheduler pool;
    @Autowired
    private HussarLogicEngineProperties properties;
    @Autowired
    private LogicRuntime logicRuntime;

    public ThreadPoolTaskScheduler getExecutor() {
        return this.pool;
    }

    public void afterPropertiesSet() {
        logger.info("Initializing LogicEngineThreadPoolProvider");
        this.pool = LogicEngineThreadPoolProviderImpl.createTaskScheduler();
        this.pool.initialize();
        this.initializeBackgroundRoutines();
    }

    private static ThreadPoolTaskScheduler createTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("logic-engine-support");
        scheduler.setPoolSize(2);
        return scheduler;
    }

    public void destroy() {
        logger.info("Destroying LogicEngineThreadPoolProvider");
        this.pool.shutdown();
    }

    public void initializeBackgroundRoutines() {
        if (this.properties.isUnloadExpired()) {
            long seconds = this.properties.getExpiredCheckInterval();
            if (seconds <= 0L) {
                seconds = 3600L;
            }
            Instant start = Instant.now().plusSeconds(seconds);
            Duration period = Duration.of(seconds, ChronoUnit.SECONDS);
            this.pool.scheduleAtFixedRate(this::unloadExpiredRoutine, start, period);
            logger.info("scheduled logic runtime class expiration check: every {} since {}", (Object)period, (Object)start);
        }
    }

    private void unloadExpiredRoutine() {
        this.logicRuntime.getEngine().unloadExpired();
    }
}

