/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.utils;

import com.jxdinfo.hussar.integration.support.common.type.TypeReferenceAdaptor;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationJsonException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationExceptionUtils;
import com.jxdinfo.hussar.logic.engine.api.EngineFactory;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.api.UnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.implementation.ecj.EcjEngineFactory;
import com.jxdinfo.hussar.logic.engine.implementation.ecj.EcjUnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.GroovyEngineFactory;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.GroovyUnloadableClassLoader;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.GroovyUnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.support.ResourceLoaderAdaptor;
import com.jxdinfo.hussar.logic.engine.loader.ResourceFileLoader;
import com.jxdinfo.hussar.logic.engine.properties.LogicEngineImplementation;
import com.jxdinfo.hussar.logic.engine.runtime.simple.SimpleLogicRuntime;
import com.jxdinfo.hussar.logic.engine.utils.ReflectUtilEx;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import groovy.lang.GroovyResourceLoader;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class LogicRuntimeUtil {
    private static LogicRuntime logicRuntime;

    public static <T> T run(String className, Object ... args) {
        LogicRuntimeUtil.assertState();
        return (T)logicRuntime.run(className, args);
    }

    public static Object[] convertArgs(String className, Object[] params) {
        LogicRuntimeUtil.assertState();
        return LogicRuntimeUtil.convertArgs(className, params, logicRuntime);
    }

    public static Object[] convertArgs(String className, Object[] params, LogicRuntime runtime) {
        try {
            Class clz = runtime.getEngine().loadClass(className);
            Method method = ReflectUtilEx.getMethod((Class)clz, (String)"invoke");
            return LogicRuntimeUtil.convertParams(method, params);
        }
        catch (ClassNotFoundException e) {
            throw HussarIntegrationExceptionUtils.sneakyThrow((Throwable)e);
        }
    }

    public static Object[] convertParams(Method method, Object[] params) {
        try {
            HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getConvertUtils();
            Parameter[] parameters = method.getParameters();
            Object[] arguments = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Type type = parameters[i].getParameterizedType();
                arguments[i] = convertUtils.convert(params[i], (TypeReference)new TypeReferenceAdaptor(type));
            }
            return arguments;
        }
        catch (HussarIntegrationJsonException ex) {
            Throwable cause = ex;
            if (ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new IllegalArgumentException("\u5165\u53c2\u683c\u5f0f\u5f02\u5e38", cause);
        }
    }

    public static LogicRuntime getInstance() {
        LogicRuntimeUtil.assertState();
        return logicRuntime;
    }

    public static void setInstance(LogicRuntime instance) {
        logicRuntime = instance;
    }

    private static void assertState() {
        if (logicRuntime != null) {
            return;
        }
        LogicRuntimeUtil.init();
    }

    private static synchronized void init() {
        if (logicRuntime != null) {
            return;
        }
        logicRuntime = LogicRuntimeUtil.getRuntime(LogicRuntimeUtil.getEngine());
    }

    private static SimpleLogicRuntime getRuntime(UnloadableScriptEngine engine) {
        SimpleLogicRuntime runtime = new SimpleLogicRuntime();
        runtime.setEngine(LogicRuntimeUtil.getEngine());
        return runtime;
    }

    public static UnloadableScriptEngine getEngine() {
        return LogicRuntimeUtil.getEngine(System.getProperties());
    }

    public static UnloadableScriptEngine getEngine(Properties properties) {
        LogicEngineImplementation impl = LogicRuntimeUtil.getImplementation(properties);
        switch (impl) {
            case GROOVY: {
                return LogicRuntimeUtil.getGroovyEngine();
            }
            case ECJ: {
                return LogicRuntimeUtil.getEcjEngine();
            }
        }
        throw new IllegalStateException();
    }

    public static EngineFactory getEngineFactory() {
        return LogicRuntimeUtil.getEngineFactory(System.getProperties());
    }

    public static EngineFactory getEngineFactory(Properties properties) {
        LogicEngineImplementation impl = LogicRuntimeUtil.getImplementation(properties);
        switch (impl) {
            case GROOVY: {
                return LogicRuntimeUtil.getGroovyEngineFactory();
            }
            case ECJ: {
                return LogicRuntimeUtil.getEcjEngineFactory();
            }
        }
        throw new IllegalStateException();
    }

    private static LogicEngineImplementation getImplementation(Properties properties) {
        return Optional.ofNullable(properties).map(props -> props.getProperty("hussar-logic.engine.implementation")).flatMap(name -> Arrays.stream(LogicEngineImplementation.values()).filter(impl -> StringUtils.equalsIgnoreCase((CharSequence)impl.name(), (CharSequence)name)).findFirst()).orElse(LogicEngineImplementation.GROOVY);
    }

    public static UnloadableScriptEngine getGroovyEngine() {
        GroovyUnloadableScriptEngine engine = new GroovyUnloadableScriptEngine();
        GroovyUnloadableClassLoader classLoader = engine.getDefaultClassLoader();
        classLoader.setResourceLoader((GroovyResourceLoader)new ResourceLoaderAdaptor((ResourceLoader)new ResourceFileLoader()));
        return engine;
    }

    public static UnloadableScriptEngine getEcjEngine() {
        EcjUnloadableScriptEngine engine = new EcjUnloadableScriptEngine();
        engine.setResourceLoader((ResourceLoader)new ResourceFileLoader());
        return engine;
    }

    public static EngineFactory getGroovyEngineFactory() {
        GroovyEngineFactory factory = new GroovyEngineFactory();
        factory.setResourceLoader((ResourceLoader)new ResourceFileLoader());
        return factory;
    }

    public static EngineFactory getEcjEngineFactory() {
        EcjEngineFactory factory = new EcjEngineFactory();
        factory.setResourceLoader((ResourceLoader)new ResourceFileLoader());
        return factory;
    }
}

