/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.simple;

import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationExceptionUtils;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.UnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.context.LogicExecutionContext;
import com.jxdinfo.hussar.logic.engine.runtime.utils.LogicRuntimeUtil;
import com.jxdinfo.hussar.logic.engine.utils.ReflectUtilEx;
import com.jxdinfo.hussar.logic.mixin.LogicExecutionContextAware;
import com.jxdinfo.hussar.logic.mixin.LogicRuntimeAware;

public class SimpleLogicRuntime
implements LogicRuntime {
    protected UnloadableScriptEngine engine;

    public SimpleLogicRuntime() {
    }

    public SimpleLogicRuntime(UnloadableScriptEngine engine) {
        this.engine = engine;
    }

    public <T> T run(String className, Object ... args) {
        return this.contextualRun(null, className, this.preprocessArgs(args));
    }

    public <T> T runWithConvert(String className, Object ... args) {
        return this.run(className, LogicRuntimeUtil.convertArgs(className, this.preprocessArgs(args), this));
    }

    public <T> T contextualRun(LogicExecutionContext ctx, String className, Object ... args) {
        Class clz = null;
        try {
            clz = this.engine.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw HussarIntegrationExceptionUtils.sneakyThrow((Throwable)e);
        }
        Object inst = ReflectUtilEx.newInstance((Class)clz);
        this.beforeInvoke(inst, ctx);
        return (T)ReflectUtilEx.invoke((Object)inst, (String)"invoke", (Object[])this.preprocessArgs(args));
    }

    public <T> T contextualRunWithConvert(LogicExecutionContext ctx, String className, Object ... args) {
        return this.contextualRun(ctx, className, LogicRuntimeUtil.convertArgs(className, this.preprocessArgs(args), this));
    }

    public void remove(String className) {
        this.engine.unloadClass(className);
    }

    public UnloadableScriptEngine getEngine() {
        return this.engine;
    }

    public boolean isDebug() {
        return false;
    }

    public void setEngine(UnloadableScriptEngine engine) {
        this.engine = engine;
    }

    protected Object[] preprocessArgs(Object[] args) {
        return args != null ? args : new Object[]{};
    }

    protected void beforeInvoke(Object inst, LogicExecutionContext ctx) {
        if (inst instanceof LogicRuntimeAware) {
            ((LogicRuntimeAware)inst).setLogicRuntime((LogicRuntime)this);
        } else {
            ReflectUtilEx.setFieldVal((Object)inst, (String)"runtime", (Object)this);
        }
        if (ctx != null && inst instanceof LogicExecutionContextAware) {
            ((LogicExecutionContextAware)inst).setExecutionContext(ctx);
        }
    }
}

