/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.sandbox;

import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.UnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.context.LogicExecutionContext;
import com.jxdinfo.hussar.logic.engine.security.PrivilegedSandbox;

public class SandboxRuntime<R extends LogicRuntime>
implements LogicRuntime {
    private PrivilegedSandbox sandbox;
    private R delegate;

    public SandboxRuntime(PrivilegedSandbox sandbox, R delegate) {
        this.sandbox = sandbox;
        this.delegate = delegate;
    }

    public <T> T run(String className, Object ... args) {
        return (T)this.sandbox.confine(() -> this.delegate.run(className, args));
    }

    public <T> T runWithConvert(String className, Object ... args) {
        return (T)this.sandbox.confine(() -> this.delegate.runWithConvert(className, args));
    }

    public <T> T contextualRun(LogicExecutionContext ctx, String className, Object ... args) {
        return (T)this.sandbox.confine(() -> this.delegate.contextualRun(ctx, className, args));
    }

    public <T> T contextualRunWithConvert(LogicExecutionContext ctx, String className, Object ... args) {
        return (T)this.sandbox.confine(() -> this.delegate.contextualRunWithConvert(ctx, className, args));
    }

    public void remove(String className) {
        this.delegate.remove(className);
    }

    public UnloadableScriptEngine getEngine() {
        return this.delegate.getEngine();
    }

    public boolean isDebug() {
        return this.delegate.isDebug();
    }

    public PrivilegedSandbox getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(PrivilegedSandbox sandbox) {
        this.sandbox = sandbox;
    }

    public R getDelegate() {
        return this.delegate;
    }

    public void setDelegate(R delegate) {
        this.delegate = delegate;
    }
}

