/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.debug.logging;

import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationExceptionUtils;
import com.jxdinfo.hussar.logic.engine.bean.DebugClassInfo;
import com.jxdinfo.hussar.logic.engine.bean.DebugError;
import com.jxdinfo.hussar.logic.engine.bean.DebugLog;
import com.jxdinfo.hussar.logic.engine.bean.DebugPosition;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugLogItem;
import com.jxdinfo.hussar.logic.mixin.LogicMetadataSupplier;
import com.jxdinfo.hussar.logic.structure.runtime.LogicRuntimeMetadata;
import com.jxdinfo.hussar.logic.structure.sourcemap.LogicSourceMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;

public final class DebugResultUtils {
    private static final String UNCAUGHT_EXCEPTION_LOG_MESSAGE_PREFIX = "\u8c03\u8bd5\u6267\u884c\u8fc7\u7a0b\u51fa\u73b0\u672a\u6355\u83b7\u7684\u7684\u5f02\u5e38: ";
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LOG_LOGIC_STACKTRACE_HEADER = "\u903b\u8f91\u7ec4\u4ef6\u5f02\u5e38\u8c03\u7528\u6808:";
    private static final int LOG_FRAGMENT_ENVIRONMENT_LIMIT = 40;
    private static final int LOG_FRAGMENT_COMPONENTS_LIMIT = 20;

    private DebugResultUtils() {
    }

    public static DebugLogItem errorLogFromUncaught(Throwable throwable, Set<String> classNames) {
        StackTraceElement[] stacktrace;
        LocalDateTime timestamp = LocalDateTime.now();
        String clazz = null;
        int line = -1;
        int column = -1;
        for (StackTraceElement element : stacktrace = Optional.ofNullable(HussarIntegrationExceptionUtils.getRootStackTrace((Throwable)throwable)).orElseGet(() -> new StackTraceElement[0])) {
            String className = DebugResultUtils.toOutermostClassName(element.getClassName());
            if (classNames == null || !classNames.contains(className)) continue;
            clazz = className;
            line = element.getLineNumber();
            break;
        }
        String message = UNCAUGHT_EXCEPTION_LOG_MESSAGE_PREFIX + HussarIntegrationExceptionUtils.toSimpleMessageWithCauses((Throwable)throwable);
        return DebugLogItem.of(timestamp, clazz, line, column, Level.ERROR, message, throwable);
    }

    public static DebugLogItem logFromSlf4jTuple(Level level, FormattingTuple tuple, String clazz) {
        LocalDateTime timestamp = LocalDateTime.now();
        int line = Optional.ofNullable(clazz).map(DebugResultUtils::traceLineOfClass).orElse(-1);
        String message = Optional.ofNullable(tuple).map(FormattingTuple::getMessage).orElse(null);
        Throwable exception = Optional.ofNullable(tuple).map(FormattingTuple::getThrowable).orElse(null);
        return DebugLogItem.of(timestamp, clazz, line, -1, level, message, exception);
    }

    private static int traceLineOfClass(String clazz) {
        StackTraceElement[] stacktrace;
        for (StackTraceElement element : stacktrace = Thread.currentThread().getStackTrace()) {
            String rawClassName = element.getClassName();
            if (!rawClassName.startsWith(clazz) || !Objects.equals(DebugResultUtils.toOutermostClassName(rawClassName), clazz)) continue;
            return element.getLineNumber();
        }
        return -1;
    }

    public static DebugError compilationError(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        DebugError error = new DebugError();
        error.setExceptionName(throwable.getClass().getSimpleName());
        error.setExceptionMessage(throwable.getMessage());
        error.setJavaStacktrace(HussarIntegrationExceptionUtils.printStackTraceToString((Throwable)throwable));
        return error;
    }

    public static DebugError convertError(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        DebugError error = new DebugError();
        error.setExceptionName(throwable.getClass().getSimpleName());
        error.setExceptionMessage(throwable.getMessage());
        error.setJavaStacktrace(HussarIntegrationExceptionUtils.printStackTraceToString((Throwable)throwable));
        return error;
    }

    public static DebugError executionError(Throwable throwable, Map<String, LogicRuntimeMetadata> metadataMap) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof ExecutionException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        DebugError error = new DebugError();
        error.setExceptionName(throwable.getClass().getSimpleName());
        error.setExceptionMessage(throwable.getMessage());
        error.setJavaStacktrace(HussarIntegrationExceptionUtils.printStackTraceToString((Throwable)throwable));
        error.setLogicStacktrace(DebugResultUtils.getLogicStacktrace(throwable, metadataMap));
        return error;
    }

    private static DebugError loggingError(Throwable throwable, Map<String, LogicRuntimeMetadata> metadataMap) {
        if (throwable == null) {
            return null;
        }
        DebugError error = new DebugError();
        error.setExceptionName(throwable.getClass().getSimpleName());
        error.setExceptionMessage(throwable.getMessage());
        error.setJavaStacktrace(HussarIntegrationExceptionUtils.printStackTraceToString((Throwable)throwable));
        error.setLogicStacktrace(DebugResultUtils.getLogicStacktrace(throwable, metadataMap));
        return error;
    }

    private static List<DebugPosition> getLogicStacktrace(Throwable throwable, Map<String, LogicRuntimeMetadata> metadataMap) {
        ArrayList<DebugPosition> positions = new ArrayList<DebugPosition>();
        List stacktraceList = HussarIntegrationExceptionUtils.getAsyncRootStackTrace((Throwable)throwable);
        Collections.reverse(stacktraceList);
        for (StackTraceElement[] stacktrace : stacktraceList) {
            if (stacktrace == null) continue;
            for (StackTraceElement element : stacktrace) {
                String clazz = DebugResultUtils.toOutermostClassName(element.getClassName());
                int line = element.getLineNumber();
                LogicSourceMap sourcemap = Optional.ofNullable(metadataMap).map(map -> (LogicRuntimeMetadata)map.get(clazz)).map(LogicRuntimeMetadata::getSourcemap).orElse(null);
                if (sourcemap == null || line < 0) continue;
                ArrayList components = new ArrayList(sourcemap.lookup(line));
                DebugPosition position = DebugPosition.of((String)clazz, (int)line, components);
                positions.add(position);
            }
        }
        return positions;
    }

    private static String toOutermostClassName(String className) {
        if (className == null) {
            return null;
        }
        int dollar = className.indexOf(36, Math.max(0, className.lastIndexOf(46)));
        return dollar >= 0 ? className.substring(0, dollar) : className;
    }

    public static Map<String, LogicRuntimeMetadata> extractClassMetadata(Set<Object> logicInstances) {
        LinkedHashMap<String, LogicRuntimeMetadata> metadataMap = new LinkedHashMap<String, LogicRuntimeMetadata>();
        for (Object instance : logicInstances) {
            LogicRuntimeMetadata metadata = null;
            if (instance instanceof LogicMetadataSupplier) {
                try {
                    metadata = ((LogicMetadataSupplier)instance).getLogicMetadata();
                }
                catch (Exception exception) {}
            } else {
                try {
                    Object value;
                    Field field = instance.getClass().getField("metadata");
                    Object object = value = Modifier.isStatic(field.getModifiers()) ? field.get(null) : field.get(instance);
                    if (value instanceof LogicRuntimeMetadata) {
                        metadata = (LogicRuntimeMetadata)value;
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (metadata == null) continue;
            metadataMap.put(instance.getClass().getName(), metadata);
        }
        return metadataMap;
    }

    public static Map<String, DebugClassInfo> processClassInfos(Map<String, LogicRuntimeMetadata> metadataMap) {
        LinkedHashMap<String, DebugClassInfo> classInfos = new LinkedHashMap<String, DebugClassInfo>();
        for (Map.Entry<String, LogicRuntimeMetadata> metadataEntry : metadataMap.entrySet()) {
            String className = metadataEntry.getKey();
            LogicRuntimeMetadata classMetadata = metadataEntry.getValue();
            if (className == null || classMetadata == null) continue;
            DebugClassInfo classInfo = new DebugClassInfo();
            classInfo.setId(classMetadata.getId());
            classInfo.setName(classMetadata.getName());
            classInfo.setTitle(classMetadata.getTitle());
            classInfo.setDescription(classMetadata.getDescription());
            classInfo.setClazz(className);
            classInfo.setAttributes(classMetadata.getAttributes());
            classInfos.put(className, classInfo);
        }
        return classInfos;
    }

    public static List<DebugLog> processDebugLogs(Collection<DebugLogItem> logs, Map<String, LogicRuntimeMetadata> metadataMap) {
        if (logs == null) {
            return Collections.emptyList();
        }
        ArrayList<DebugLog> convertedLogs = new ArrayList<DebugLog>(logs.size());
        for (DebugLogItem log : logs) {
            DebugLog convertedLog = DebugResultUtils.processDebugLog(log, metadataMap);
            if (convertedLog == null) continue;
            convertedLogs.add(convertedLog);
        }
        return convertedLogs;
    }

    private static DebugLog processDebugLog(DebugLogItem logItem, Map<String, LogicRuntimeMetadata> metadataMap) {
        if (logItem == null) {
            return null;
        }
        Level level = logItem.getLevel();
        LocalDateTime timestamp = logItem.getTimestamp();
        String message = logItem.getMessage();
        DebugError error = DebugResultUtils.loggingError(logItem.getException(), metadataMap);
        String clazz = logItem.getSourceClass();
        int line = logItem.getSourceLine();
        int column = logItem.getSourceColumn();
        LogicSourceMap sourcemap = Optional.ofNullable(metadataMap).map(map -> (LogicRuntimeMetadata)map.get(clazz)).map(LogicRuntimeMetadata::getSourcemap).orElse(null);
        List<Object> components = Collections.emptyList();
        if (sourcemap != null && line >= 0) {
            if (column >= 0) {
                String component = sourcemap.lookup(LogicSourceMap.Position.of((int)line, (int)column));
                components = Collections.singletonList(component);
            } else {
                components = new ArrayList(sourcemap.lookup(line));
            }
        }
        DebugPosition position = clazz != null ? DebugPosition.of((String)clazz, (int)line, (int)column, components) : null;
        return DebugLog.of((Level)level, (LocalDateTime)timestamp, (DebugPosition)position, (String)message, (DebugError)error);
    }

    public static String formatLogs(List<DebugLog> logs, Map<String, DebugClassInfo> classes) {
        StringBuilder builder = new StringBuilder();
        if (logs == null) {
            return "";
        }
        for (DebugLog log : logs) {
            DebugResultUtils.appendFormattedLog(builder, log, classes);
        }
        return builder.toString();
    }

    private static void appendFormattedLog(StringBuilder builder, DebugLog log, Map<String, DebugClassInfo> classes) {
        if (log == null) {
            return;
        }
        builder.append(TIMESTAMP_FORMAT.format(log.getTimestamp())).append(' ');
        builder.append(String.format("%5s", log.getLevel())).append(" --- ");
        DebugPosition position = log.getPosition();
        if (position == null || position.getClazz() == null) {
            builder.append('[').append(StringUtils.rightPad((String)"", (int)40)).append(']').append(' ');
            builder.append(StringUtils.rightPad((String)"", (int)20)).append(" : ");
        } else {
            String clazz = position.getClazz();
            String environment = DebugResultUtils.getLogPositionEnvironment(clazz, classes);
            builder.append('[').append(StringUtils.rightPad((String)environment, (int)40)).append(']').append(' ');
            String components = Optional.ofNullable(position.getComponents()).map(comps -> String.join((CharSequence)" ", comps)).map(comps -> DebugResultUtils.shortenLogFragment(comps, 20)).orElse("");
            builder.append(StringUtils.rightPad((String)components, (int)20)).append(" : ");
        }
        builder.append(StringUtils.defaultString((String)log.getMessage())).append(System.lineSeparator());
        DebugError error = log.getException();
        if (error != null) {
            String javaStacktrace;
            List logicStacktrace = error.getLogicStacktrace();
            if (CollectionUtils.isNotEmpty((Collection)logicStacktrace)) {
                builder.append(LOG_LOGIC_STACKTRACE_HEADER).append(System.lineSeparator());
                for (DebugPosition logicPosition : logicStacktrace) {
                    builder.append('\t').append(logicPosition.getClazz());
                    if (logicPosition.getLine() >= 0) {
                        builder.append(':').append(logicPosition.getLine());
                    }
                    if (logicPosition.getColumn() >= 0) {
                        builder.append(':').append(logicPosition.getColumn());
                    }
                    String positionEnvironment = DebugResultUtils.getStacktracePositionEnvironment(logicPosition.getClazz(), classes);
                    builder.append(" [").append(positionEnvironment).append(']');
                    String components = Optional.ofNullable(logicPosition.getComponents()).map(comps -> String.join((CharSequence)" ", comps)).orElse("");
                    if (StringUtils.isNotEmpty((CharSequence)components)) {
                        builder.append(' ').append(components);
                    }
                    builder.append(System.lineSeparator());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(javaStacktrace = error.getJavaStacktrace()))) {
                builder.append(StringUtils.stripEnd((String)javaStacktrace, (String)"\n\r")).append(System.lineSeparator());
            }
        }
    }

    private static String getLogPositionEnvironment(String clazz, Map<String, DebugClassInfo> classes) {
        DebugClassInfo classInfo = classes.get(clazz);
        String logic = DebugResultUtils.getLogLogicInfo(classInfo);
        String attrs = DebugResultUtils.getLogAttributeInfo(classInfo);
        String environment = StringUtils.isEmpty((CharSequence)logic) && StringUtils.isEmpty((CharSequence)attrs) ? DebugResultUtils.getAbbreviatedClassName(clazz, 3, 40) : (StringUtils.isEmpty((CharSequence)attrs) ? DebugResultUtils.shortenLogFragment(logic, 40) : (StringUtils.isEmpty((CharSequence)logic) ? DebugResultUtils.shortenLogFragment(attrs, 40) : DebugResultUtils.shortenLogFragment(logic + ' ' + attrs, 40)));
        return StringUtils.defaultString((String)environment);
    }

    private static String getStacktracePositionEnvironment(String clazz, Map<String, DebugClassInfo> classes) {
        DebugClassInfo logicClassInfo = classes.get(clazz);
        String logic = DebugResultUtils.getLogLogicInfo(logicClassInfo);
        String attrs = DebugResultUtils.getLogAttributeInfo(logicClassInfo);
        String environment = StringUtils.isEmpty((CharSequence)logic) && StringUtils.isEmpty((CharSequence)attrs) ? "" : (StringUtils.isEmpty((CharSequence)attrs) ? logic : (StringUtils.isEmpty((CharSequence)logic) ? attrs : logic + ' ' + attrs));
        return StringUtils.defaultString((String)environment);
    }

    private static String shortenLogFragment(String fragment, int limit) {
        if (fragment.length() <= limit) {
            return fragment;
        }
        return fragment.substring(0, Math.max(limit - 3, 0)) + "...";
    }

    private static String getAbbreviatedClassName(String clazz, int fullWordLimit, int lengthLimit) {
        if (StringUtils.isEmpty((CharSequence)clazz)) {
            return clazz;
        }
        Object[] words = clazz.split("\\.", -1);
        if (words.length <= 1) {
            return DebugResultUtils.shortenLogFragment(clazz, lengthLimit);
        }
        int until = words.length > fullWordLimit ? words.length - fullWordLimit : 0;
        for (int i = 0; i < until; ++i) {
            words[i] = StringUtils.substring((String)words[i], (int)0, (int)1);
        }
        while (Arrays.stream(words).mapToInt(String::length).sum() + words.length - 1 > lengthLimit && until + 1 < words.length) {
            words[until] = StringUtils.substring((String)words[until], (int)0, (int)1);
        }
        if (Arrays.stream(words).mapToInt(String::length).sum() + words.length - 1 > lengthLimit) {
            if (((String)words[words.length - 1]).length() > lengthLimit) {
                return '.' + DebugResultUtils.shortenLogFragment((String)words[words.length - 1], lengthLimit - 1);
            }
            int remain = (lengthLimit - ((String)words[words.length - 1]).length() - 1) / 2;
            CharSequence[] remainWords = (String[])ArrayUtils.subarray((Object[])words, (int)(words.length - remain - 1), (int)words.length);
            return '.' + String.join((CharSequence)".", remainWords);
        }
        return String.join((CharSequence)".", (CharSequence[])words);
    }

    private static String getLogLogicInfo(DebugClassInfo classInfo) {
        if (classInfo == null) {
            return null;
        }
        String title = Optional.of(classInfo).map(DebugClassInfo::getTitle).orElse(null);
        String name = Optional.of(classInfo).map(DebugClassInfo::getName).orElse(null);
        if (StringUtils.isEmpty((CharSequence)name) && StringUtils.isEmpty((CharSequence)title)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)title)) {
            return name;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            return title;
        }
        return title + " (" + name + ')';
    }

    private static String getLogAttributeInfo(DebugClassInfo classInfo) {
        if (classInfo == null || MapUtils.isEmpty((Map)classInfo.getAttributes())) {
            return null;
        }
        String eaiEnvCategory = DebugResultUtils.getClassInfoAttribute(classInfo, "environmentCategory", String.class);
        String eaiLogicCategory = DebugResultUtils.getClassInfoAttribute(classInfo, "logicCategory", String.class);
        String eaiAppName = DebugResultUtils.getClassInfoAttribute(classInfo, "applicationName", String.class);
        String eaiAppCode = DebugResultUtils.getClassInfoAttribute(classInfo, "applicationCode", String.class);
        String eaiAppVersion = DebugResultUtils.getClassInfoAttribute(classInfo, "applicationVersion", String.class);
        StringBuilder builder = new StringBuilder();
        DebugResultUtils.appendColonSeparated(builder, eaiEnvCategory, eaiLogicCategory, eaiAppName, eaiAppCode, eaiAppVersion);
        return (String)StringUtils.defaultIfEmpty((CharSequence)builder.toString(), null);
    }

    private static <T> T getClassInfoAttribute(DebugClassInfo classInfo, String name, Class<T> clazz) {
        return Optional.ofNullable(classInfo).map(DebugClassInfo::getAttributes).map(attrs -> attrs.get(name)).map(value -> HussarIntegrationConvertUtils.convert((Object)value, (Class)clazz)).orElse(null);
    }

    private static void appendColonSeparated(StringBuilder builder, String ... values) {
        for (String value : values) {
            DebugResultUtils.appendColonSeparated(builder, value);
        }
    }

    private static void appendColonSeparated(StringBuilder builder, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        if (builder.length() > 0) {
            builder.append(':');
        }
        builder.append(value);
    }
}

