/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.debug.logging;

import com.jxdinfo.hussar.logic.engine.api.DebugLogicRuntime;
import com.jxdinfo.hussar.logic.engine.properties.LogicEngineDebugLogStrategy;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugLogAggregator;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugLogItem;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class DebugLogger
extends MarkerIgnoringBase
implements Logger {
    private static final Logger logger = LoggerFactory.getLogger(DebugLogger.class);
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private final DebugLogAggregator aggregator;
    private final String clazz;
    private final LogicEngineDebugLogStrategy strategy;
    private final Logger targetLogger;

    public DebugLogger(DebugLogAggregator aggregator, String clazz, LogicEngineDebugLogStrategy strategy) {
        Logger targetLogger;
        this.aggregator = aggregator;
        this.clazz = clazz;
        this.strategy = strategy != null ? strategy : LogicEngineDebugLogStrategy.QUIET;
        switch (this.strategy) {
            case QUIET: {
                targetLogger = null;
                break;
            }
            case TRANSPARENT: {
                targetLogger = LoggerFactory.getLogger((String)clazz);
                break;
            }
            case REDIRECT: {
                targetLogger = LoggerFactory.getLogger(DebugLogicRuntime.class);
                break;
            }
            default: {
                logger.warn("unsupported debug log strategy: {}", (Object)strategy);
                targetLogger = null;
            }
        }
        this.targetLogger = targetLogger;
    }

    public boolean isTraceEnabled() {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            return this.targetLogger.isTraceEnabled() || this.isAggregateEnabled(Level.TRACE);
        }
        return this.isAggregateEnabled(Level.TRACE);
    }

    public void trace(String s) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.trace(s);
        }
        if (!this.isAggregateEnabled(Level.TRACE)) {
            return;
        }
        this.append(Level.TRACE, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY));
    }

    public void trace(String s, Object o) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.trace(s, o);
        }
        if (!this.isAggregateEnabled(Level.TRACE)) {
            return;
        }
        this.append(Level.TRACE, MessageFormatter.format((String)s, (Object)o));
    }

    public void trace(String s, Object o, Object o1) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.trace(s, o, o1);
        }
        if (!this.isAggregateEnabled(Level.TRACE)) {
            return;
        }
        this.append(Level.TRACE, MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void trace(String s, Object ... objects) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.trace(s, objects);
        }
        if (!this.isAggregateEnabled(Level.TRACE)) {
            return;
        }
        this.append(Level.TRACE, MessageFormatter.format((String)s, (Object)objects));
    }

    public void trace(String s, Throwable throwable) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.trace(s, throwable);
        }
        if (!this.isAggregateEnabled(Level.TRACE)) {
            return;
        }
        this.append(Level.TRACE, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isDebugEnabled() {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            return this.targetLogger.isDebugEnabled() || this.isAggregateEnabled(Level.DEBUG);
        }
        return this.isAggregateEnabled(Level.DEBUG);
    }

    public void debug(String s) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.debug(s);
        }
        if (!this.isAggregateEnabled(Level.DEBUG)) {
            return;
        }
        this.append(Level.DEBUG, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY));
    }

    public void debug(String s, Object o) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.debug(s, o);
        }
        if (!this.isAggregateEnabled(Level.DEBUG)) {
            return;
        }
        this.append(Level.DEBUG, MessageFormatter.format((String)s, (Object)o));
    }

    public void debug(String s, Object o, Object o1) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.debug(s, o, o1);
        }
        if (!this.isAggregateEnabled(Level.DEBUG)) {
            return;
        }
        this.append(Level.DEBUG, MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void debug(String s, Object ... objects) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.debug(s, objects);
        }
        if (!this.isAggregateEnabled(Level.DEBUG)) {
            return;
        }
        this.append(Level.DEBUG, MessageFormatter.format((String)s, (Object)objects));
    }

    public void debug(String s, Throwable throwable) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.debug(s, throwable);
        }
        if (!this.isAggregateEnabled(Level.DEBUG)) {
            return;
        }
        this.append(Level.DEBUG, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isInfoEnabled() {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            return this.targetLogger.isInfoEnabled() || this.isAggregateEnabled(Level.INFO);
        }
        return this.isAggregateEnabled(Level.INFO);
    }

    public void info(String s) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.info(s);
        }
        if (!this.isAggregateEnabled(Level.INFO)) {
            return;
        }
        this.append(Level.INFO, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY));
    }

    public void info(String s, Object o) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.info(s, o);
        }
        if (!this.isAggregateEnabled(Level.INFO)) {
            return;
        }
        this.append(Level.INFO, MessageFormatter.format((String)s, (Object)o));
    }

    public void info(String s, Object o, Object o1) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.info(s, o, o1);
        }
        if (!this.isAggregateEnabled(Level.INFO)) {
            return;
        }
        this.append(Level.INFO, MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void info(String s, Object ... objects) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.info(s, objects);
        }
        if (!this.isAggregateEnabled(Level.INFO)) {
            return;
        }
        this.append(Level.INFO, MessageFormatter.format((String)s, (Object)objects));
    }

    public void info(String s, Throwable throwable) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.info(s, throwable);
        }
        if (!this.isAggregateEnabled(Level.INFO)) {
            return;
        }
        this.append(Level.INFO, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isWarnEnabled() {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            return this.targetLogger.isWarnEnabled() || this.isAggregateEnabled(Level.WARN);
        }
        return this.isAggregateEnabled(Level.WARN);
    }

    public void warn(String s) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.warn(s);
        }
        if (!this.isAggregateEnabled(Level.WARN)) {
            return;
        }
        this.append(Level.WARN, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY));
    }

    public void warn(String s, Object o) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.warn(s, o);
        }
        if (!this.isAggregateEnabled(Level.WARN)) {
            return;
        }
        this.append(Level.WARN, MessageFormatter.format((String)s, (Object)o));
    }

    public void warn(String s, Object o, Object o1) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.warn(s, o, o1);
        }
        if (!this.isAggregateEnabled(Level.WARN)) {
            return;
        }
        this.append(Level.WARN, MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void warn(String s, Object ... objects) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.warn(s, objects);
        }
        if (!this.isAggregateEnabled(Level.WARN)) {
            return;
        }
        this.append(Level.WARN, MessageFormatter.format((String)s, (Object)objects));
    }

    public void warn(String s, Throwable throwable) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.warn(s, throwable);
        }
        if (!this.isAggregateEnabled(Level.WARN)) {
            return;
        }
        this.append(Level.WARN, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isErrorEnabled() {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            return this.targetLogger.isErrorEnabled() || this.isAggregateEnabled(Level.ERROR);
        }
        return this.isAggregateEnabled(Level.ERROR);
    }

    public void error(String s) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.error(s);
        }
        if (!this.isAggregateEnabled(Level.ERROR)) {
            return;
        }
        this.append(Level.ERROR, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY));
    }

    public void error(String s, Object o) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.error(s, o);
        }
        if (!this.isAggregateEnabled(Level.ERROR)) {
            return;
        }
        this.append(Level.ERROR, MessageFormatter.format((String)s, (Object)o));
    }

    public void error(String s, Object o, Object o1) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.error(s, o, o1);
        }
        if (!this.isAggregateEnabled(Level.ERROR)) {
            return;
        }
        this.append(Level.ERROR, MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void error(String s, Object ... objects) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.error(s, objects);
        }
        if (!this.isAggregateEnabled(Level.ERROR)) {
            return;
        }
        this.append(Level.ERROR, MessageFormatter.format((String)s, (Object)objects));
    }

    public void error(String s, Throwable throwable) {
        if (this.strategy == LogicEngineDebugLogStrategy.TRANSPARENT && this.targetLogger != null) {
            this.targetLogger.error(s, throwable);
        }
        if (!this.isAggregateEnabled(Level.ERROR)) {
            return;
        }
        this.append(Level.ERROR, MessageFormatter.arrayFormat((String)s, (Object[])EMPTY_ARRAY, (Throwable)throwable));
    }

    private boolean isAggregateEnabled(Level level) {
        return this.aggregator.getLevel().toInt() <= level.toInt();
    }

    private void append(Level level, FormattingTuple tuple) {
        DebugLogItem log = DebugResultUtils.logFromSlf4jTuple(level, tuple, this.clazz);
        this.aggregator.emit(log);
        if (this.strategy == LogicEngineDebugLogStrategy.REDIRECT && this.targetLogger != null) {
            if (log.getException() != null) {
                this.targetLogger.info("[{} (REDIRECT)] {} : {}", new Object[]{log.getLevel(), log.getSourceClass(), log.getMessage(), log.getException()});
            } else {
                this.targetLogger.info("[{} (REDIRECT)] {} : {}", new Object[]{log.getLevel(), log.getSourceClass(), log.getMessage()});
            }
        }
    }
}

