/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.debug.logging;

import com.jxdinfo.hussar.core.exception.HussarCoreException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationEntityUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Optional;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.unit.DataSize;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

public final class DebugErrorHandleUtils {
    private static final String FEIGN_EXCEPTION_CLASS = "feign.FeignException";
    private static final String HUSSAR_FEIGN_EXCEPTION_CLASS = "com.jxdinfo.hussar.platform.cloud.support.feign.exception.HussarFeignException";

    private DebugErrorHandleUtils() {
    }

    public static ApiResponse<?> mockExceptionHandler(Throwable exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof HussarException) {
            return ApiResponse.fail((int)((HussarException)exception).getExceptionCode(), (String)exception.getMessage());
        }
        if (exception instanceof HussarCoreException) {
            return ApiResponse.fail((int)400, (String)exception.getLocalizedMessage());
        }
        if (exception instanceof MyBatisSystemException) {
            return ApiResponse.fail((String)exception.getMessage());
        }
        if (DebugErrorHandleUtils.isInstanceOf(exception, HUSSAR_FEIGN_EXCEPTION_CLASS)) {
            return DebugErrorHandleUtils.handleHussarFeignException(exception);
        }
        if (DebugErrorHandleUtils.isInstanceOf(exception, FEIGN_EXCEPTION_CLASS)) {
            return DebugErrorHandleUtils.handleFeignException(exception);
        }
        if (exception instanceof BadSqlGrammarException) {
            return ApiResponse.fail((String)"\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38....");
        }
        if (exception instanceof HttpMessageConversionException) {
            return ApiResponse.fail((String)"\u53d1\u751fhttp\u6570\u636e\u5e8f\u5217\u5316\u5f02\u5e38....");
        }
        if (exception instanceof HttpRequestMethodNotSupportedException) {
            return ApiResponse.fail((int)405, (String)exception.getMessage());
        }
        if (exception instanceof MaxUploadSizeExceededException) {
            return ApiResponse.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u670d\u52a1\u5668\u5141\u8bb8\u6587\u4ef6\u5927\u5c0f\u9650\u5236\uff0c\u6700\u5927\u5141\u8bb8\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + DebugErrorHandleUtils.getMaxFileSize() + "bytes\u3002"));
        }
        if (exception instanceof RuntimeException) {
            return ApiResponse.fail((String)"\u53d1\u751fRuntimeException\u5f02\u5e38....");
        }
        if (exception instanceof Exception) {
            return ApiResponse.fail((String)"\u53d1\u751f\u672a\u77e5\u5f02\u5e38....");
        }
        return null;
    }

    private static ApiResponse<?> handleHussarFeignException(Throwable exception) {
        int exceptionCode;
        try {
            exceptionCode = (Integer)HussarIntegrationEntityUtils.getProperty((Object)exception, (String)"exceptionCode", (boolean)false);
        }
        catch (Exception ignore) {
            exceptionCode = 10001;
        }
        return ApiResponse.fail((int)exceptionCode, (String)exception.getMessage());
    }

    private static ApiResponse<?> handleFeignException(Throwable exception) {
        return ApiResponse.fail((int)ResultCode.FEIGN_FAILURE.getCode(), (String)"\u53d1\u751f\u8fdc\u7a0b\u8c03\u7528feign\u5f02\u5e38....");
    }

    private static boolean isInstanceOf(Object value, String clazz) {
        Class<?> cls;
        if (value == null) {
            return false;
        }
        try {
            cls = Class.forName(clazz);
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
        return cls.isAssignableFrom(value.getClass());
    }

    private static long getMaxFileSize() {
        MultipartProperties multipartProperties;
        try {
            multipartProperties = (MultipartProperties)SpringContextHolder.getBean(MultipartProperties.class);
        }
        catch (BeansException ex) {
            multipartProperties = null;
        }
        DataSize maxFileSize = Optional.ofNullable(multipartProperties).map(MultipartProperties::getMaxFileSize).orElseGet(() -> DataSize.ofMegabytes((long)1L));
        return maxFileSize.toBytes();
    }
}

