/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.debug;

import com.jxdinfo.hussar.logic.engine.api.DebugLogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.DebugRuntimePool;
import com.jxdinfo.hussar.logic.engine.api.PoolDebugLogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.bean.DebugResult;
import com.jxdinfo.hussar.logic.engine.context.LogicExecutionContext;
import com.jxdinfo.hussar.logic.engine.runtime.RuntimeFactory;
import com.jxdinfo.hussar.logic.engine.runtime.debug.PoolDebugLogicRuntimeImpl;
import com.jxdinfo.hussar.platform.core.utils.core.Assert;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.event.Level;

public class DebugRuntimePoolImpl
implements DebugRuntimePool {
    private int size = 10;
    private final AtomicInteger activeCount = new AtomicInteger(0);
    private BlockingQueue<PoolDebugLogicRuntimeImpl> runtimes;
    private RuntimeFactory<DebugLogicRuntime> runtimeFactory;
    private static final long MAX_WAIT = 5000L;

    public DebugRuntimePoolImpl(RuntimeFactory runtimeFactory) {
        this(10, runtimeFactory);
    }

    public DebugRuntimePoolImpl(int size, RuntimeFactory runtimeFactory) {
        this.size = size;
        this.runtimeFactory = runtimeFactory;
        this.init();
    }

    public DebugResult compileAndDebug(String script, String className, Level lvl, ResourceLoader resourceLoader, Object ... args) {
        return this.contextualCompileAndDebug(null, script, className, lvl, resourceLoader, args);
    }

    public DebugResult compileAndDebugWithConvert(String script, String className, Level lvl, ResourceLoader resourceLoader, Object ... args) {
        return this.contextualCompileAndDebugWithConvert(null, script, className, lvl, resourceLoader, args);
    }

    public DebugResult contextualCompileAndDebug(LogicExecutionContext ctx, String script, String className, Level lvl, ResourceLoader resourceLoader, Object ... args) {
        DebugResult rlt;
        Assert.notNull((Object)resourceLoader);
        runtime.getEngine().setResourceLoader(resourceLoader);
        try (PoolDebugLogicRuntimeImpl runtime = this.getInternal(5000L);){
            rlt = runtime.contextualCompileAndDebug(ctx, script, className, lvl, args);
        }
        return rlt;
    }

    public DebugResult contextualCompileAndDebugWithConvert(LogicExecutionContext ctx, String script, String className, Level lvl, ResourceLoader resourceLoader, Object ... args) {
        DebugResult rlt;
        Assert.notNull((Object)resourceLoader);
        runtime.getEngine().setResourceLoader(resourceLoader);
        try (PoolDebugLogicRuntimeImpl runtime = this.getInternal(5000L);){
            rlt = runtime.contextualCompileAndDebugWithConvert(ctx, script, className, lvl, args);
        }
        return rlt;
    }

    public PoolDebugLogicRuntime getRuntime() {
        return this.getInternal(5000L);
    }

    public RuntimeFactory getRuntimeFactory() {
        return this.runtimeFactory;
    }

    public void setRuntimeFactory(RuntimeFactory runtimeFactory) {
        this.runtimeFactory = runtimeFactory;
    }

    protected void recycle(PoolDebugLogicRuntimeImpl runtime) {
        try {
            this.runtimes.put(runtime);
            this.activeCount.decrementAndGet();
        }
        catch (InterruptedException e) {
            this.runtimes.offer(this.newRuntime());
            this.activeCount.decrementAndGet();
        }
    }

    protected int getActiveCount() {
        return this.activeCount.get();
    }

    private PoolDebugLogicRuntimeImpl getInternal(long maxWait) {
        PoolDebugLogicRuntimeImpl runtime = null;
        try {
            runtime = this.runtimes.poll(maxWait, TimeUnit.MICROSECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("open debug runtime error", e);
        }
        if (runtime == null) {
            throw new RuntimeException(String.format("not have debug runtime until wait %s", maxWait));
        }
        this.activeCount.incrementAndGet();
        return runtime;
    }

    private void init() {
        this.runtimes = new LinkedBlockingQueue<PoolDebugLogicRuntimeImpl>(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.runtimes.offer(this.newRuntime());
        }
    }

    private PoolDebugLogicRuntimeImpl newRuntime() {
        DebugLogicRuntime logicRuntime = this.runtimeFactory.create();
        PoolDebugLogicRuntimeImpl runtime = new PoolDebugLogicRuntimeImpl();
        runtime.setDelegate(logicRuntime);
        runtime.setPool(this);
        return runtime;
    }
}

