/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.loader;

import com.jxdinfo.hussar.logic.engine.api.Resource;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.loader.SourceEntityResource;
import com.jxdinfo.hussar.logic.engine.service.LogicSourceEntityService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class SourceResourceLoader
implements ResourceLoader {
    private final String namespace;
    private volatile boolean initialized = false;
    private volatile LogicSourceEntityService logicSourceEntityService;

    public SourceResourceLoader(String namespace) {
        this.namespace = namespace;
    }

    public Resource get(String name) {
        LogicSourceEntity entity = this.getLogicSourceEntityService().getByName(this.namespace, name);
        if (entity == null) {
            return null;
        }
        return new SourceEntityResource(entity);
    }

    public long[] getTimestamps(String ... names) {
        TreeMap<String, LogicSourceEntity> entityMap = new TreeMap<String, LogicSourceEntity>();
        for (String name : names) {
            entityMap.put(name, null);
        }
        List<LogicSourceEntity> entities = this.getLogicSourceEntityService().listMetadataByNames(this.namespace, entityMap.keySet());
        for (LogicSourceEntity entity : entities) {
            if (entity == null || !entityMap.containsKey(entity.getSourceCode())) continue;
            entityMap.put(entity.getSourceCode(), entity);
        }
        long[] timestamps = new long[names.length];
        for (int i = 0; i < names.length; ++i) {
            long timestamp;
            timestamps[i] = timestamp = Optional.ofNullable(entityMap.get(names[i])).map(HussarBaseEntity::getLastTime).map(date -> date.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()).orElse(0L).longValue();
        }
        return timestamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogicSourceEntityService getLogicSourceEntityService() {
        if (!this.initialized) {
            SourceResourceLoader sourceResourceLoader = this;
            synchronized (sourceResourceLoader) {
                if (!this.initialized) {
                    this.logicSourceEntityService = (LogicSourceEntityService)SpringContextUtil.getBean(LogicSourceEntityService.class);
                    this.initialized = true;
                }
            }
        }
        return this.logicSourceEntityService;
    }
}

