/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.loader;

import com.jxdinfo.hussar.logic.engine.api.Resource;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;

class SourceEntityResource
implements Resource {
    private final LogicSourceEntity entity;

    public SourceEntityResource(LogicSourceEntity entity) {
        if (entity == null || entity.getSourceCode() == null || entity.getSourceContent() == null) {
            throw new NullPointerException();
        }
        this.entity = entity;
    }

    public InputStream open() throws IOException {
        return new ByteArrayInputStream(this.entity.getSourceContent().getBytes(StandardCharsets.UTF_8));
    }

    public String getName() {
        return this.entity.getSourceCode();
    }

    public long lastModified() {
        LocalDateTime mtime = this.entity.getLastTime();
        if (mtime == null) {
            return 0L;
        }
        return mtime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

