/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.config;

import java.util.Optional;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class RedisCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String cacheType = this.getCacheType(context);
        return "redis".equals(cacheType);
    }

    private String getCacheType(ConditionContext context) {
        return Optional.ofNullable(context.getEnvironment().getProperty("hussar.cache.cache-type")).orElse("ehcache");
    }

    public static class NotEnabled
    extends RedisCondition {
        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !super.matches(context, metadata);
        }
    }
}

