/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.config;

import com.jxdinfo.hussar.logic.engine.config.RedisCondition;
import com.jxdinfo.hussar.logic.engine.service.LogicEngineMessageService;
import com.jxdinfo.hussar.logic.engine.service.LogicEngineThreadPoolProvider;
import com.jxdinfo.hussar.logic.engine.service.impl.LogicEngineMessageServiceDefaultImpl;
import com.jxdinfo.hussar.logic.engine.service.impl.LogicEngineMessageServiceRedisImpl;
import com.jxdinfo.hussar.logic.engine.service.impl.LogicEngineThreadPoolProviderImpl;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializer;

public class HussarLogicEngineInfrastructureConfiguration {
    @Bean
    public LogicEngineThreadPoolProvider logicEngineThreadPoolProvider() {
        return new LogicEngineThreadPoolProviderImpl();
    }

    @Bean
    @Conditional(value={RedisCondition.NotEnabled.class})
    public LogicEngineMessageService logicEngineBroadcastService() {
        return new LogicEngineMessageServiceDefaultImpl();
    }

    @Bean
    @Conditional(value={RedisCondition.class})
    public LogicEngineMessageService.RedisExt logicEngineBroadcastServiceRedisExt() {
        return new LogicEngineMessageServiceRedisImpl();
    }

    @Bean
    @Conditional(value={RedisCondition.class})
    public RedisMessageListenerContainer logicEngineBroadcastServiceRedisListener(LogicEngineMessageService.RedisExt logicEngineMessageService, LogicEngineThreadPoolProvider logicEngineThreadPoolProvider, RedisConnectionFactory redisConnectionFactory) {
        TaskExecutor executor = logicEngineThreadPoolProvider.getExecutor();
        RedisMessageListenerContainer container = this.createRedisListener(redisConnectionFactory, (Executor)executor);
        Pair<Topic, MessageListener> definition = logicEngineMessageService.getRedisListenerDefinition();
        container.addMessageListener((MessageListener)definition.getValue(), (Topic)definition.getKey());
        return container;
    }

    private RedisMessageListenerContainer createRedisListener(RedisConnectionFactory connectionFactory, Executor executor) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setTopicSerializer(RedisSerializer.string());
        container.setTaskExecutor(executor);
        return container;
    }
}

