/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.service.impl;

import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.SourceEventListener;
import com.jxdinfo.hussar.logic.engine.constants.SourceNamespace;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.service.LogicSourceEntityService;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.core.Assert;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class SourceServiceImpl
implements SourceService {
    public static final Charset DEFAULT_SRC_ENCODING = StandardCharsets.UTF_8;
    @Autowired
    LogicSourceEntityService logicSourceEntityService;
    @Autowired
    LogicRuntime logicRuntime;
    @Autowired(required=false)
    SourceEventListener sourceEventListener;

    public boolean saveDev(String code, String src) {
        LogicSourceEntity entity = this.newDevEntity(null, code, src);
        this.beforeSaveCheck(entity);
        boolean rlt = this.logicSourceEntityService.save(entity);
        if (!rlt) {
            return rlt;
        }
        this.afterSave(entity);
        return rlt;
    }

    public boolean saveProd(String code, String src) {
        LogicSourceEntity entity = this.newProdEntity(null, code, src);
        this.beforeSaveCheck(entity);
        boolean rlt = this.logicSourceEntityService.save(entity);
        if (!rlt) {
            return rlt;
        }
        this.afterSave(entity);
        return rlt;
    }

    public boolean saveBatch(Collection<LogicSourceEntity> entities) {
        this.beforeSaveCheck(entities);
        boolean rlt = this.logicSourceEntityService.saveBatch(entities);
        if (!rlt) {
            return rlt;
        }
        this.afterSave(entities);
        return rlt;
    }

    public boolean deleteById(Long id) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfoByIds(Arrays.asList(id)));
        if (e == null) {
            return true;
        }
        this.logicSourceEntityService.removeById(id);
        this.afterDelete(e);
        return true;
    }

    public boolean deleteByIds(Collection<Long> ids) {
        List<LogicSourceEntity> es = this.logicSourceEntityService.listInfoByIds(ids);
        this.logicSourceEntityService.removeByIds(ids);
        this.afterDelete(es);
        return true;
    }

    public boolean deleteDevByCode(String code) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfosByCodesAndNamespace(Arrays.asList(code), SourceNamespace.DEV.name()));
        if (e == null) {
            return true;
        }
        this.logicSourceEntityService.removeById(e.getSourceId());
        this.afterDelete(e);
        return true;
    }

    public boolean deleteProdByCode(String code) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfosByCodesAndNamespace(Arrays.asList(code), SourceNamespace.PROD.name()));
        if (e == null) {
            return true;
        }
        this.logicSourceEntityService.removeById(e.getSourceId());
        this.afterDelete(e);
        return true;
    }

    public boolean deleteByCode(String code) {
        List<LogicSourceEntity> es = this.logicSourceEntityService.listInfoByCodes(Arrays.asList(code));
        this.logicSourceEntityService.removeByIds(es.stream().map(LogicSourceEntity::getSourceId).collect(Collectors.toList()));
        this.afterDelete(es);
        return true;
    }

    public boolean deleteDevByCodes(Collection<String> codes) {
        List<LogicSourceEntity> es = this.logicSourceEntityService.listInfosByCodesAndNamespace(codes, SourceNamespace.DEV.name());
        this.logicSourceEntityService.removeByIds(es.stream().map(LogicSourceEntity::getSourceId).collect(Collectors.toList()));
        this.afterDelete(es);
        return true;
    }

    public boolean deleteProdByCodes(Collection<String> codes) {
        List<LogicSourceEntity> es = this.logicSourceEntityService.listInfosByCodesAndNamespace(codes, SourceNamespace.PROD.name());
        this.logicSourceEntityService.removeByIds(es.stream().map(LogicSourceEntity::getSourceId).collect(Collectors.toList()));
        this.afterDelete(es);
        return true;
    }

    public boolean deleteByCodes(Collection<String> codes) {
        List<LogicSourceEntity> es = this.logicSourceEntityService.listInfoByCodes(codes);
        this.logicSourceEntityService.removeByIds(es.stream().map(LogicSourceEntity::getSourceId).collect(Collectors.toList()));
        this.afterDelete(es);
        return true;
    }

    public boolean updateDevByCode(String code, String src) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfosByCodesAndNamespace(Arrays.asList(code), SourceNamespace.DEV.name()));
        if (e == null) {
            return true;
        }
        e.setSourceContent(this.getBytes(src));
        this.beforeUpdateCheck(e);
        this.logicSourceEntityService.updateById(e);
        this.afterUpdate(e);
        return true;
    }

    public boolean updateProdByCode(String code, String src) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfosByCodesAndNamespace(Arrays.asList(code), SourceNamespace.PROD.name()));
        if (e == null) {
            return true;
        }
        e.setSourceContent(this.getBytes(src));
        this.beforeUpdateCheck(e);
        this.logicSourceEntityService.updateById(e);
        this.afterUpdate(e);
        return true;
    }

    public boolean updateById(Long id, String src) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfoByIds(Arrays.asList(id)));
        if (e == null) {
            return true;
        }
        e.setSourceContent(this.getBytes(src));
        this.beforeUpdateCheck(e);
        this.logicSourceEntityService.updateById(e);
        this.afterUpdate(e);
        return true;
    }

    public boolean update(LogicSourceEntity entity) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfoByIds(Arrays.asList(entity.getSourceId())));
        if (e == null) {
            return true;
        }
        e.setSourceContent(entity.getSourceContent());
        this.updateInternal(e);
        return true;
    }

    protected boolean updateInternal(LogicSourceEntity entity) {
        this.beforeUpdateCheck(entity);
        this.logicSourceEntityService.updateById(entity);
        this.afterUpdate(entity);
        return true;
    }

    public boolean updateBatch(Collection<LogicSourceEntity> entities) {
        HashMap map = entities.stream().collect(HashMap::new, (m, e) -> m.put(e.getSourceId(), e), HashMap::putAll);
        List<LogicSourceEntity> es = this.logicSourceEntityService.listInfoByIds(map.keySet());
        es.forEach(e -> e.setSourceContent(((LogicSourceEntity)map.get(e.getSourceId())).getSourceContent()));
        this.updateBatchInternal(es);
        return true;
    }

    protected boolean updateBatchInternal(Collection<LogicSourceEntity> entities) {
        this.beforeUpdateCheck(entities);
        this.logicSourceEntityService.updateBatchById(entities);
        this.afterUpdate(entities);
        return true;
    }

    public boolean saveOrUpdateDev(String code, String src) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfosByCodesAndNamespace(Arrays.asList(code), SourceNamespace.DEV.name()));
        if (e == null) {
            return this.saveDev(code, src);
        }
        e.setSourceContent(this.getBytes(src));
        return this.updateInternal(e);
    }

    public boolean saveOrUpdateProd(String code, String src) {
        LogicSourceEntity e = (LogicSourceEntity)CollectionUtil.getFirst(this.logicSourceEntityService.listInfosByCodesAndNamespace(Arrays.asList(code), SourceNamespace.PROD.name()));
        if (e == null) {
            return this.saveProd(code, src);
        }
        e.setSourceContent(this.getBytes(src));
        return this.updateInternal(e);
    }

    public Optional<LogicSourceEntity> getById(Long id) {
        return Optional.ofNullable(this.logicSourceEntityService.getById(id));
    }

    public Optional<LogicSourceEntity> getDevByCode(String code) {
        return this.logicSourceEntityService.getByCodeAndNamespace(code, SourceNamespace.DEV.name());
    }

    public Optional<LogicSourceEntity> getProdByCode(String code) {
        return this.logicSourceEntityService.getByCodeAndNamespace(code, SourceNamespace.PROD.name());
    }

    public List<LogicSourceEntity> listByIds(Collection<Long> ids) {
        return this.logicSourceEntityService.listByIds(ids);
    }

    public List<LogicSourceEntity> listDevByCodes(Collection<String> codes) {
        return this.logicSourceEntityService.listByCodesAndNamespace(codes, SourceNamespace.DEV.name());
    }

    public List<LogicSourceEntity> listProdByCodes(Collection<String> codes) {
        return this.logicSourceEntityService.listByCodesAndNamespace(codes, SourceNamespace.PROD.name());
    }

    protected void beforeSaveCheck(LogicSourceEntity entity) {
        Assert.notEmpty((CharSequence)entity.getSourceCode());
        Assert.notEmpty((CharSequence)entity.getNamespace());
    }

    protected void beforeSaveCheck(Collection<LogicSourceEntity> entity) {
        entity.forEach(e -> this.beforeSaveCheck((LogicSourceEntity)e));
    }

    protected void beforeUpdateCheck(LogicSourceEntity entity) {
        Assert.notNull((Object)entity.getSourceId());
        Assert.notNull((Object)entity.getSourceContent());
    }

    protected void beforeUpdateCheck(Collection<LogicSourceEntity> entity) {
        entity.forEach(e -> this.beforeUpdateCheck((LogicSourceEntity)e));
    }

    protected void afterSave(LogicSourceEntity entity) {
        this.afterSave(Arrays.asList(entity.getSourceCode()), entity.getNamespace());
    }

    protected void afterSave(Collection<LogicSourceEntity> entities) {
        Map<String, Set<String>> groups = this.groupByNamespace(entities);
        groups.forEach((k, v) -> this.afterSave((Collection<String>)v, (String)k));
    }

    protected void afterSave(Collection<String> codes, String namespace) {
        if (this.sourceEventListener != null) {
            this.sourceEventListener.afterSave(codes, namespace);
        }
    }

    protected void afterUpdate(LogicSourceEntity entity) {
        this.afterUpdate(Arrays.asList(entity.getSourceCode()), entity.getNamespace());
    }

    protected void afterUpdate(Collection<LogicSourceEntity> entities) {
        Map<String, Set<String>> groups = this.groupByNamespace(entities);
        groups.forEach((k, v) -> this.afterUpdate((Collection<String>)v, (String)k));
    }

    protected void afterUpdate(Collection<String> codes, String namespace) {
        if (this.sourceEventListener != null) {
            this.sourceEventListener.afterUpdate(codes, namespace);
        }
    }

    protected void afterDelete(LogicSourceEntity entity) {
        this.afterDelete(Arrays.asList(entity.getSourceCode()), entity.getNamespace());
    }

    protected void afterDelete(Collection<LogicSourceEntity> entities) {
        Map<String, Set<String>> groups = this.groupByNamespace(entities);
        groups.forEach((k, v) -> this.afterDelete((Collection<String>)v, (String)k));
    }

    protected void afterDelete(Collection<String> codes, String namespace) {
        if (this.sourceEventListener != null) {
            this.sourceEventListener.afterDelete(codes, namespace);
        }
    }

    protected LogicSourceEntity newDevEntity(Long id, String code, String src) {
        return this.newEntity(id, code, src, SourceNamespace.DEV.name());
    }

    protected LogicSourceEntity newProdEntity(Long id, String code, String src) {
        return this.newEntity(id, code, src, SourceNamespace.PROD.name());
    }

    protected LogicSourceEntity newEntity(Long id, String code, String src, String ns) {
        LogicSourceEntity entity = new LogicSourceEntity();
        entity.setSourceId(id);
        entity.setSourceCode(code);
        entity.setNamespace(ns);
        entity.setSourceContent(this.getBytes(src));
        return entity;
    }

    protected byte[] getBytes(String src) {
        return src.getBytes(DEFAULT_SRC_ENCODING);
    }

    protected String getSrc(byte[] bytes) {
        return StringUtil.str((byte[])bytes, (Charset)DEFAULT_SRC_ENCODING);
    }

    protected Map<String, Set<String>> groupByNamespace(Collection<LogicSourceEntity> entities) {
        HashMap<String, Set<String>> rlt = new HashMap<String, Set<String>>();
        for (LogicSourceEntity e : entities) {
            Set<String> codes = rlt.containsKey(e.getNamespace()) ? (Set)rlt.get(e.getNamespace()) : new HashSet<String>();
            codes.add(e.getSourceCode());
        }
        return rlt;
    }
}

