/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.logic.engine.dao.LogicSourceMapper;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.service.LogicSourceEntityService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.logic.engine.service.impl.logicSourceEntityServiceImpl")
public class LogicSourceEntityServiceImpl
extends HussarServiceImpl<LogicSourceMapper, LogicSourceEntity>
implements LogicSourceEntityService {
    @Override
    public List<LogicSourceEntity> listInfoByIds(Collection<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)Wrappers.lambdaQuery(LogicSourceEntity.class).select(new SFunction[]{LogicSourceEntity::getSourceId, LogicSourceEntity::getSourceCode, LogicSourceEntity::getNamespace}).in(LogicSourceEntity::getSourceId, ids);
        return this.list((Wrapper)query);
    }

    @Override
    public List<LogicSourceEntity> listInfoByCodes(Collection<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)Wrappers.lambdaQuery(LogicSourceEntity.class).select(new SFunction[]{LogicSourceEntity::getSourceId, LogicSourceEntity::getSourceCode, LogicSourceEntity::getNamespace}).in(LogicSourceEntity::getSourceCode, codes);
        return this.list((Wrapper)query);
    }

    @Override
    public List<LogicSourceEntity> listInfosByCodesAndNamespace(Collection<String> codes, String namespace) {
        if (CollectionUtil.isEmpty(codes)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicSourceEntity.class).select(new SFunction[]{LogicSourceEntity::getSourceId, LogicSourceEntity::getSourceCode, LogicSourceEntity::getNamespace}).in(LogicSourceEntity::getSourceCode, codes)).eq(LogicSourceEntity::getNamespace, (Object)namespace);
        return this.list((Wrapper)query);
    }

    @Override
    public List<LogicSourceEntity> listByCodesAndNamespace(Collection<String> codes, String namespace) {
        if (CollectionUtil.isEmpty(codes)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicSourceEntity.class).in(LogicSourceEntity::getSourceCode, codes)).eq(LogicSourceEntity::getNamespace, (Object)namespace);
        return this.list((Wrapper)query);
    }

    @Override
    public Optional<LogicSourceEntity> getByCodeAndNamespace(String code, String namespace) {
        if (StringUtil.isEmpty((Object)code)) {
            return Optional.empty();
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicSourceEntity.class).eq(LogicSourceEntity::getSourceCode, (Object)code)).eq(LogicSourceEntity::getNamespace, (Object)namespace);
        return Optional.ofNullable(CollectionUtil.getFirst((Collection)this.list((Wrapper)query)));
    }
}

