/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationJsonException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.api.UnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.GroovyUnloadableClassLoader;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.GroovyUnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.support.ResourceLoaderAdaptor;
import com.jxdinfo.hussar.logic.engine.implementation.janino.JaninoUnloadableClassLoader;
import com.jxdinfo.hussar.logic.engine.implementation.janino.JaninoUnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.implementation.janino.internal.ResourceFinderAdaptor;
import com.jxdinfo.hussar.logic.engine.loader.ResourceFileLoader;
import com.jxdinfo.hussar.logic.engine.runtime.simple.SimpleLogicRuntime;
import com.jxdinfo.hussar.logic.engine.runtime.utils.ExceptionUtil;
import com.jxdinfo.hussar.logic.engine.utils.ReflectUtilEx;
import groovy.lang.GroovyResourceLoader;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;

public class LogicRuntimeUtil {
    private static LogicRuntime logicRuntime;

    public static <T> T run(String className, Object ... args) {
        LogicRuntimeUtil.assertState();
        return (T)logicRuntime.run(className, args);
    }

    public static Object[] convertArgs(String className, Object[] params) {
        LogicRuntimeUtil.assertState();
        return LogicRuntimeUtil.convertArgs(className, params, logicRuntime);
    }

    public static Object[] convertArgs(String className, Object[] params, LogicRuntime runtime) {
        try {
            Class clz = runtime.getEngine().loadClass(className);
            Method method = ReflectUtilEx.getMethod((Class)clz, (String)"invoke");
            return LogicRuntimeUtil.convertParams(method, params);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static Object[] convertParams(Method method, Object[] params) {
        try {
            HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = HussarIntegrationJsonUtils.createUtilsBean();
            Parameter[] parameters = method.getParameters();
            Object[] arguments = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                JavaType type = jsonUtils.getTypeFactory().constructType(parameters[i].getParameterizedType());
                arguments[i] = jsonUtils.convert(params[i], type);
            }
            return arguments;
        }
        catch (HussarIntegrationJsonException ex) {
            Throwable cause = ex;
            if (ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new IllegalArgumentException("\u5165\u53c2\u683c\u5f0f\u5f02\u5e38", cause);
        }
    }

    public static LogicRuntime getInstance() {
        LogicRuntimeUtil.assertState();
        return logicRuntime;
    }

    public static void setInstance(LogicRuntime instance) {
        logicRuntime = instance;
    }

    private static void assertState() {
        if (logicRuntime != null) {
            return;
        }
        LogicRuntimeUtil.init();
    }

    private static synchronized void init() {
        if (logicRuntime != null) {
            return;
        }
        logicRuntime = LogicRuntimeUtil.getRuntime(LogicRuntimeUtil.getJaninoEngine());
    }

    private static SimpleLogicRuntime getRuntime(UnloadableScriptEngine engine) {
        SimpleLogicRuntime runtime = new SimpleLogicRuntime();
        runtime.setEngine(LogicRuntimeUtil.getJaninoEngine());
        return runtime;
    }

    private static UnloadableScriptEngine getGroovyEngine() {
        GroovyUnloadableScriptEngine engine = new GroovyUnloadableScriptEngine();
        GroovyUnloadableClassLoader classLoader = engine.getDefaultClassLoader();
        classLoader.setResourceLoader((GroovyResourceLoader)new ResourceLoaderAdaptor((ResourceLoader)new ResourceFileLoader()));
        return engine;
    }

    private static UnloadableScriptEngine getJaninoEngine() {
        JaninoUnloadableScriptEngine engine = new JaninoUnloadableScriptEngine();
        JaninoUnloadableClassLoader loader = engine.getDefaultClassLoader();
        loader.setSourceFinder((ResourceFinder)new ResourceFinderAdaptor((ResourceLoader)new ResourceFileLoader()));
        loader.setSourceCharset(StandardCharsets.UTF_8);
        return engine;
    }
}

