/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.sandbox;

import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.UnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.security.PrivilegedSandbox;

public class SandboxRuntime<T extends LogicRuntime>
implements LogicRuntime {
    private PrivilegedSandbox sandbox;
    private T delegate;

    public SandboxRuntime(PrivilegedSandbox sandbox, T delegate) {
        this.sandbox = sandbox;
        this.delegate = delegate;
    }

    public <T> T run(String className, Object ... args) {
        return (T)this.sandbox.confine(() -> this.delegate.run(className, args));
    }

    public <T> T runWithConvert(String className, Object ... args) {
        return (T)this.sandbox.confine(() -> this.delegate.runWithConvert(className, args));
    }

    public void remove(String className) {
        this.delegate.remove(className);
    }

    public UnloadableScriptEngine getEngine() {
        return this.delegate.getEngine();
    }

    public boolean isDebug() {
        return this.delegate.isDebug();
    }

    public PrivilegedSandbox getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(PrivilegedSandbox sandbox) {
        this.sandbox = sandbox;
    }

    public T getDelegate() {
        return this.delegate;
    }

    public void setDelegate(T delegate) {
        this.delegate = delegate;
    }
}

