/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.runtime.debug;

import com.jxdinfo.hussar.logic.engine.api.DebugLogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.bean.DebugResult;
import com.jxdinfo.hussar.logic.engine.properties.HussarLogicEngineProperties;
import com.jxdinfo.hussar.logic.engine.properties.LogicEngineDebugLogStrategy;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugErrorHandleUtils;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugLogAggregator;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugLogItem;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugLogger;
import com.jxdinfo.hussar.logic.engine.runtime.debug.logging.DebugResultUtils;
import com.jxdinfo.hussar.logic.engine.runtime.simple.SimpleLogicRuntime;
import com.jxdinfo.hussar.logic.engine.runtime.utils.LogicRuntimeUtil;
import com.jxdinfo.hussar.logic.engine.utils.ReflectUtilEx;
import com.jxdinfo.hussar.logic.mixin.LogicRuntimeAware;
import com.jxdinfo.hussar.logic.structure.runtime.LogicRuntimeMetadata;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DebugLogicRuntimeImpl
extends SimpleLogicRuntime
implements DebugLogicRuntime {
    protected DebugLogAggregator logAggregator = new DebugLogAggregator();
    protected Set<Object> logicAggregator = ConcurrentHashMap.newKeySet();
    protected ExecutorService executor = Executors.newSingleThreadExecutor();
    private int maxDebugTime = 60;
    private HussarLogicEngineProperties engineProperties;

    @Override
    public boolean isDebug() {
        return true;
    }

    public DebugResult compileAndDebug(String script, String className, Level lvl, Object ... args) {
        Class clz;
        DebugResult result = new DebugResult();
        try {
            clz = this.engine.compile(script, className, true);
        }
        catch (Exception ex) {
            result.setError(DebugResultUtils.compilationError(ex));
            return result;
        }
        return this.debug(clz, lvl, args);
    }

    public DebugResult compileAndDebugWithConvert(String script, String className, Level lvl, Object ... args) {
        Object[] convertedArgs;
        Class clz;
        DebugResult rlt = new DebugResult();
        try {
            clz = this.engine.compile(script, className, true);
        }
        catch (Exception ex) {
            rlt.setSuccess(false);
            rlt.setError(DebugResultUtils.compilationError(ex));
            return rlt;
        }
        try {
            Method invokeMethod = ReflectUtilEx.getMethod((Class)clz, (String)"invoke");
            convertedArgs = LogicRuntimeUtil.convertParams(invokeMethod, args);
        }
        catch (Exception ex) {
            rlt.setSuccess(false);
            rlt.setError(DebugResultUtils.convertError(ex));
            return rlt;
        }
        return this.debug(clz, lvl, convertedArgs);
    }

    public void reset() {
        this.logAggregator.clear();
        this.logicAggregator.clear();
        this.getEngine().unloadAll();
    }

    @Override
    protected void beforeInvoke(Object inst) {
        if (inst instanceof LogicRuntimeAware) {
            ((LogicRuntimeAware)inst).setLogicRuntime((LogicRuntime)this);
        } else {
            ReflectUtilEx.setFieldVal((Object)inst, (String)"runtime", (Object)this);
        }
        DebugLogger logger = new DebugLogger(this.logAggregator, inst.getClass().getName(), this.getDebugLogStrategy());
        ReflectUtilEx.setFieldVal((Object)inst, (String)"logger", (Object)((Object)logger));
        this.logicAggregator.add(inst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DebugResult debug(Class<?> clz, Level lvl, Object ... args) {
        this.logAggregator.setLevel(lvl);
        DebugResult result = new DebugResult();
        ApiResponse<?> retVal = null;
        Exception errVal = null;
        Future<Object> future = this.executor.submit(() -> {
            result.setStart(LocalDateTime.now());
            Object inst = ReflectUtilEx.newInstance((Class)clz);
            this.beforeInvoke(inst);
            return ReflectUtilEx.invoke((Object)inst, (String)"invoke", (Object[])args);
        });
        try {
            retVal = future.get(this.maxDebugTime, TimeUnit.SECONDS);
            result.setStop(LocalDateTime.now());
            result.setSuccess(true);
        }
        catch (InterruptedException | TimeoutException ex) {
            errVal = ex;
        }
        catch (ExecutionException ex) {
            result.setStop(LocalDateTime.now());
            errVal = ex.getCause() != null ? ex.getCause() : ex;
            retVal = DebugErrorHandleUtils.mockExceptionHandler(errVal);
        }
        finally {
            future.cancel(true);
            if (result.getStop() == null) {
                result.setStop(LocalDateTime.now());
            }
        }
        result.setClazz(clz.getName());
        result.setResult(retVal);
        Map<String, LogicRuntimeMetadata> classes = DebugResultUtils.extractClassMetadata(this.logicAggregator);
        if (errVal != null) {
            Set<String> logicClassNames = this.logicAggregator.stream().map(instance -> instance.getClass().getName()).collect(Collectors.toSet());
            DebugLogItem errLog = DebugResultUtils.errorLogFromUncaught(errVal, logicClassNames);
            this.logAggregator.emit(errLog);
            LogicEngineDebugLogStrategy debugLogStrategy = this.getDebugLogStrategy();
            switch (debugLogStrategy) {
                case QUIET: {
                    break;
                }
                case TRANSPARENT: 
                case REDIRECT: {
                    LoggerFactory.getLogger(DebugLogicRuntime.class).error("\u903b\u8f91\u8c03\u8bd5\u8fd0\u884c\u62a5\u9519 (STRATEGY={})", (Object)debugLogStrategy, (Object)errVal);
                }
            }
        }
        result.setError(DebugResultUtils.executionError(errVal, classes));
        result.setLogs(DebugResultUtils.processDebugLogs(this.logAggregator.getLogs(), classes));
        result.setClasses(DebugResultUtils.processClassInfos(classes));
        result.setOut(DebugResultUtils.formatLogs(result.getLogs(), result.getClasses()));
        return result;
    }

    public int getMaxDebugTime() {
        return this.maxDebugTime;
    }

    public void setMaxDebugTime(int maxDebugTime) {
        this.maxDebugTime = maxDebugTime;
    }

    public HussarLogicEngineProperties getEngineProperties() {
        return this.engineProperties;
    }

    public void setEngineProperties(HussarLogicEngineProperties engineProperties) {
        this.engineProperties = engineProperties;
    }

    protected LogicEngineDebugLogStrategy getDebugLogStrategy() {
        return Optional.ofNullable(this.getEngineProperties()).map(HussarLogicEngineProperties::getDebugLogStrategy).orElse(LogicEngineDebugLogStrategy.QUIET);
    }
}

