/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.loader;

import com.jxdinfo.hussar.logic.engine.api.Resource;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.resource.MemoryResource;
import com.jxdinfo.hussar.logic.engine.service.LogicSourceEntityService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;

public class SourceResourceLoader
implements ResourceLoader {
    private String namespace;
    private LogicSourceEntityService logicSourceEntityService;

    public SourceResourceLoader(String namespace) {
        this.namespace = namespace;
    }

    public Resource get(String resourceName) {
        this.assertState();
        LogicSourceEntity entity = this.logicSourceEntityService.getByCodeAndNamespace(resourceName, this.namespace).orElse(null);
        if (entity == null) {
            return null;
        }
        return new MemoryResource(resourceName, entity.getSourceContent());
    }

    private void assertState() {
        if (this.logicSourceEntityService != null) {
            return;
        }
        this.initState();
    }

    private synchronized void initState() {
        this.logicSourceEntityService = (LogicSourceEntityService)SpringContextUtil.getBean(LogicSourceEntityService.class);
    }
}

