/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.config;

import com.jxdinfo.hussar.logic.engine.api.DebugLogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.DebugRuntimePool;
import com.jxdinfo.hussar.logic.engine.api.EngineFactory;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.api.SourceEventListener;
import com.jxdinfo.hussar.logic.engine.constants.SourceNamespace;
import com.jxdinfo.hussar.logic.engine.implementation.ecj.EcjEngineFactory;
import com.jxdinfo.hussar.logic.engine.implementation.ecj.config.EcjCompilationConfig;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.GroovyEngineFactory;
import com.jxdinfo.hussar.logic.engine.implementation.groovy.security.ClassAllowableCompilationCustomizer;
import com.jxdinfo.hussar.logic.engine.implementation.janino.JaninoEngineFactory;
import com.jxdinfo.hussar.logic.engine.implementation.janino.config.CompilerConfig;
import com.jxdinfo.hussar.logic.engine.implementation.janino.security.ClassAllowableCheckerCustomizer;
import com.jxdinfo.hussar.logic.engine.loader.SourceResourceLoader;
import com.jxdinfo.hussar.logic.engine.properties.HussarLogicEngineProperties;
import com.jxdinfo.hussar.logic.engine.runtime.RuntimeFactory;
import com.jxdinfo.hussar.logic.engine.runtime.debug.DebugRuntimePoolImpl;
import com.jxdinfo.hussar.logic.engine.runtime.debug.DebugSimpleRuntimeFactory;
import com.jxdinfo.hussar.logic.engine.runtime.sandbox.SandboxDebugRuntimeFactory;
import com.jxdinfo.hussar.logic.engine.runtime.sandbox.SandboxRuntime;
import com.jxdinfo.hussar.logic.engine.runtime.simple.SimpleLogicRuntime;
import com.jxdinfo.hussar.logic.engine.runtime.utils.LogicRuntimeUtil;
import com.jxdinfo.hussar.logic.engine.security.ClassAllowableChecker;
import com.jxdinfo.hussar.logic.engine.security.MethodAllowableChecker;
import com.jxdinfo.hussar.logic.engine.security.ObjectMethodChecker;
import com.jxdinfo.hussar.logic.engine.security.PrivilegedSandbox;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.logic.engine.service.impl.DefaultSourceEventListener;
import com.jxdinfo.hussar.logic.engine.service.impl.SourceServiceImpl;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HussarLogicEngineProperties.class})
public class HussarLogicEngineSpecializedConfiguration {
    @Autowired
    private HussarLogicEngineProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={SourceService.class})
    public SourceService sourceService() {
        return new SourceServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={SourceEventListener.class})
    public DefaultSourceEventListener defaultSourceEventListener() {
        return new DefaultSourceEventListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={LogicRuntime.class})
    public LogicRuntime logicRuntime(ObjectProvider<ClassAllowableChecker> classChecker, ObjectProvider<MethodAllowableChecker> methodChecker, ObjectProvider<PrivilegedSandbox> sandbox) {
        EngineFactory engineFactory;
        switch (this.properties.getImplementation()) {
            case GROOVY: {
                engineFactory = this.createGroovyEngineFactory(false, classChecker, methodChecker);
                break;
            }
            case JANINO: {
                engineFactory = this.createJaninoEngineFactory(false, classChecker, methodChecker);
                break;
            }
            case ECJ: {
                engineFactory = this.createEcjEngineFactory(false, classChecker, methodChecker);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported logic engine implementation: " + (Object)((Object)this.properties.getImplementation()));
            }
        }
        SimpleLogicRuntime simpleLogicRuntime = new SimpleLogicRuntime();
        simpleLogicRuntime.setEngine(engineFactory.create());
        Object runtime = simpleLogicRuntime;
        PrivilegedSandbox sandboxIfAvailable = (PrivilegedSandbox)sandbox.getIfAvailable();
        if (sandboxIfAvailable != null) {
            runtime = new SandboxRuntime<SimpleLogicRuntime>(sandboxIfAvailable, (SimpleLogicRuntime)runtime);
        }
        LogicRuntimeUtil.setInstance(runtime);
        return runtime;
    }

    @Bean
    @ConditionalOnMissingBean(value={DebugRuntimePool.class})
    public DebugRuntimePool debugRuntimePool(HussarLogicEngineProperties engineProperties, ObjectProvider<ClassAllowableChecker> classChecker, ObjectProvider<MethodAllowableChecker> methodChecker, ObjectProvider<PrivilegedSandbox> sandbox) {
        EngineFactory engineFactory;
        switch (this.properties.getImplementation()) {
            case GROOVY: {
                engineFactory = this.createGroovyEngineFactory(true, classChecker, methodChecker);
                break;
            }
            case JANINO: {
                engineFactory = this.createJaninoEngineFactory(true, classChecker, methodChecker);
                break;
            }
            case ECJ: {
                engineFactory = this.createEcjEngineFactory(true, classChecker, methodChecker);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported logic debug engine implementation: " + (Object)((Object)this.properties.getImplementation()));
            }
        }
        DebugSimpleRuntimeFactory debugRuntimeFactory = new DebugSimpleRuntimeFactory(engineFactory);
        debugRuntimeFactory.setEngineProperties(engineProperties);
        RuntimeFactory<DebugLogicRuntime> runtimeFactory = debugRuntimeFactory;
        PrivilegedSandbox sandboxIfAvailable = (PrivilegedSandbox)sandbox.getIfAvailable();
        if (sandboxIfAvailable != null) {
            runtimeFactory = new SandboxDebugRuntimeFactory(runtimeFactory, sandboxIfAvailable);
        }
        return new DebugRuntimePoolImpl(runtimeFactory);
    }

    private EngineFactory createGroovyEngineFactory(boolean debugMode, ObjectProvider<ClassAllowableChecker> classChecker, ObjectProvider<MethodAllowableChecker> methodChecker) {
        GroovyEngineFactory factory = new GroovyEngineFactory();
        CompilerConfiguration config = new CompilerConfiguration();
        factory.setConfiguration(config);
        factory.setResourceLoader((ResourceLoader)this.createSourceResourceLoader(debugMode));
        if (classChecker != null && classChecker.getIfAvailable() != null) {
            ClassAllowableCompilationCustomizer customizer = new ClassAllowableCompilationCustomizer();
            customizer.setClassChecker((ClassAllowableChecker)classChecker.getObject());
            if (methodChecker != null && methodChecker.getIfAvailable() != null) {
                customizer.setMethodChecker((MethodAllowableChecker)methodChecker.getObject());
            }
            config.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        }
        return factory;
    }

    private EngineFactory createJaninoEngineFactory(boolean debugMode, ObjectProvider<ClassAllowableChecker> classChecker, ObjectProvider<MethodAllowableChecker> methodChecker) {
        JaninoEngineFactory factory = new JaninoEngineFactory();
        factory.setResourceLoader((ResourceLoader)this.createSourceResourceLoader(debugMode));
        CompilerConfig config = new CompilerConfig();
        config.setDebugSource(true);
        config.setDebugLines(true);
        config.setDebugVars(true);
        if (classChecker != null && classChecker.getIfAvailable() != null) {
            ClassAllowableCheckerCustomizer customizer = new ClassAllowableCheckerCustomizer();
            customizer.setClassChecker((ClassAllowableChecker)classChecker.getObject());
            if (methodChecker != null && methodChecker.getIfAvailable() != null) {
                customizer.setMethodChecker((MethodAllowableChecker)new ObjectMethodChecker());
            }
            config.addCompilationCustomizer((com.jxdinfo.hussar.logic.engine.implementation.janino.internal.CompilationCustomizer)customizer);
        }
        factory.setConfig(config);
        return factory;
    }

    private EngineFactory createEcjEngineFactory(boolean debugMode, ObjectProvider<ClassAllowableChecker> classChecker, ObjectProvider<MethodAllowableChecker> methodChecker) {
        EcjEngineFactory factory = new EcjEngineFactory();
        factory.setResourceLoader((ResourceLoader)this.createSourceResourceLoader(debugMode));
        EcjCompilationConfig config = new EcjCompilationConfig();
        config.setProduceDebugInfo(true);
        ClassAllowableChecker checkerIfAvailable = (ClassAllowableChecker)classChecker.getIfAvailable();
        if (checkerIfAvailable != null) {
            config.setClassFilter(checkerIfAvailable);
        }
        factory.setCompilationConfig(config);
        return factory;
    }

    private SourceResourceLoader createSourceResourceLoader(boolean debugMode) {
        return new SourceResourceLoader(debugMode ? SourceNamespace.DEV.name() : SourceNamespace.PROD.name());
    }
}

