package ${packageName};

<#list imports as import>
import ${import.canonicalClassName};
</#list>

<#if _metadata.title?has_content && _metadata.description?has_content>
/**
 * ${_metadata.title}
 *
 * ${_metadata.description}
 */
<#elseif _metadata.title?has_content>
/**
 * ${_metadata.title}
 */
<#elseif _metadata.description?has_content>
/**
 * ${_metadata.description}
 */
</#if>
public class ${className} <#if baseClass??>extends ${baseClass}</#if> <#if logicJsEntity??>implements ${logicJsEntity}</#if> {
    <#-- 字段定义 -->
    <#list fields as field>
    <#if field.definition.title?has_content && field.definition.description?has_content>
    /**
     * ${field.definition.title}
     *
     * ${field.definition.description}
     */
    <#elseif field.definition.title?has_content>
    /**
     * ${field.definition.title}
     */
    <#elseif field.definition.description?has_content>
    /**
     * ${field.definition.description}
     */
    </#if>
    <#if field.renamed && !field.inconsistent>
    @${entityProperty}("${field.actualName?j_string}")
    <#if fastJsonField??>@${fastJsonField}(name = "${field.actualName?j_string}")</#if>
    <#if jacksonJsonProperty??>@${jacksonJsonProperty}("${field.actualName?j_string}")</#if>
    <#if gsonSerializedName??>@${gsonSerializedName}("${field.actualName?j_string}")</#if>
    </#if>
    private ${field.definition.type.code} ${field.definition.name}<#if field.definition.hasDefault> = ${field.definition.defaultLiteral}</#if>;
    </#list>

    <#-- getter/setter 定义 -->
    <#list fields as field>
    <#if field.inconsistent>
    @${entityProperty}("${field.actualName?j_string}")
    <#if fastJsonField??>@${fastJsonField}(name = "${field.actualName?j_string}")</#if>
    <#if jacksonJsonProperty??>@${jacksonJsonProperty}("${field.actualName?j_string}")</#if>
    <#if gsonSerializedName??>@${gsonSerializedName}("${field.actualName?j_string}")</#if>
    </#if>
    public ${field.definition.type.code} get${field.accessorName}() {
        return ${field.definition.name};
    }

    <#if field.inconsistent>
    @${entityProperty}("${field.actualName?j_string}")
    <#if fastJsonField??>@${fastJsonField}(name = "${field.actualName?j_string}")</#if>
    <#if jacksonJsonProperty??>@${jacksonJsonProperty}("${field.actualName?j_string}")</#if>
    <#if gsonSerializedName??>@${gsonSerializedName}("${field.actualName?j_string}")</#if>
    </#if>
    public void set${field.accessorName}(${field.definition.type.code} ${field.definition.name}) {
        this.${field.definition.name} = ${field.definition.name};
    }
    </#list>

    <#-- equals() 和 hashCode() -->
    <#if enableEqualsAndHashCode>
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        <#if fields?has_content>
        if (other == null || getClass() != other.getClass()) return false;
        ${className} that = (${className}) other;
        return <#list fields as field>${objectsClass}.equals(${field.definition.name}, that.${field.definition.name})<#sep> && </#sep></#list>;
        <#else>
        return other != null && getClass() == other.getClass();
        </#if>
    }

    @Override
    public int hashCode() {
        return Objects.hash(<#list fields as field>${field.definition.name}<#sep>, </#sep></#list>);
    }
    </#if>

    <#-- toString() -->
    <#if enableToString>
    @Override
    public String toString() {
        return "${className?j_string}{" +
            <#list fields as field>
            <#if field.definition.type.qualifiedClass == "java.lang.String">
            "${field.actualName?j_string}='" + ${field.definition.name} + '\'' +
            <#else>
            "${field.actualName?j_string}=" + ${field.definition.name} +
            </#if>
            <#sep> ", " +</#sep>
            </#list>
            '}';
    }
    </#if>
}
