/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.integration.eai.utils;

import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.vo.PageVo;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateException;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.utils.LogicSymbolUtils;
import com.jxdinfo.hussar.logic.integration.eai.context.EaiStructureGenerateContext;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateConfigure;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateSource;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureClassNameResolver;
import com.jxdinfo.hussar.logic.integration.eai.structure.EaiComputedField;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationLanguage;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationPlatform;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationRuntime;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.structure.type.LogicBuiltinType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class EaiStructureGenerateUtils {
    private static final String CUSTOM_PREFIX_CLASS = "class:";
    private static final String CUSTOM_PREFIX_STRUCTURE = "structure:";
    private static final Map<Integer, LogicType> SIMPLE_TYPE_MAPPING;
    private static final String PAGE_TYPE_NAME;
    private static final String PAGE_RECORDS_FIELD_NAME = "records";
    private static final String API_RESPONSE_TYPE_NAME;
    private static final String API_RESPONSE_DATA_FIELD_NAME = "data";
    private static final Set<String> JAVA_RESERVED;

    private EaiStructureGenerateUtils() {
    }

    public static EaiStructureGenerateContext createGenerateContext(String className, EaiStructureGenerateSource source, EaiStructureGenerateConfigure configure) {
        if (source == null || configure == null) {
            throw new NullPointerException();
        }
        LogicMetadata metadata = new LogicMetadata();
        metadata.setName(source.getName());
        metadata.setTitle(source.getTitle());
        metadata.setDescription(source.getDescription());
        metadata.setModules(source.getModules());
        LogicGenerateConfigure config = new LogicGenerateConfigure();
        config.setBackendExternalResolver((LogicBackendExternalResolver)new ResolverAdaptor(configure.getStructureResolver(), configure));
        config.setLanguage(LogicGenerationLanguage.JAVA);
        config.setRuntime(LogicGenerationRuntime.ENGINE);
        config.setPlatform(LogicGenerationPlatform.EAI_PLATFORM);
        config.setDebug(configure.getDebug());
        config.setBackendPrefixPackage(configure.getPrefixPackage());
        config.setEaiInfo(configure.getEaiInfo());
        config.setAllowCodeFormat(Boolean.valueOf(true));
        config.setAllowSourceMap(Boolean.valueOf(false));
        LogicCanvasComponent root = new LogicCanvasComponent();
        root.setName("com.jxdinfo.logic.FakeRoot");
        root.setInstanceKey(source.getName());
        return new EaiStructureGenerateContext(metadata, config, root, className);
    }

    public static List<EaiComputedField> convertStructureFieldList(BackendLogicGenerateContext context, EaiStructureGenerateConfigure configure, List<EaiParamsItems> fields) {
        LinkedHashSet<String> actualNames = new LinkedHashSet<String>();
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        LinkedHashSet<String> accessorNames = new LinkedHashSet<String>();
        ArrayList<EaiComputedField> computedFields = new ArrayList<EaiComputedField>();
        for (EaiParamsItems field : fields) {
            if (field == null) continue;
            LogicVariableDefinition logicDefinition = EaiStructureGenerateUtils.convertStructureField(field);
            String actualName = logicDefinition.getName();
            if (actualNames.contains(actualName)) {
                throw new HussarLogicGenerateException("duplicated field name");
            }
            actualNames.add(actualName);
            String fieldName = EaiStructureGenerateUtils.allocateFieldName(actualName, fieldNames, configure.getMaxSymbolAllocationRetry());
            logicDefinition.setName(fieldName);
            LogicBackendVariableDefinition backendDefinition = context.addVariable(logicDefinition);
            String accessorName = EaiStructureGenerateUtils.allocateAccessorName(actualName, accessorNames, configure.getMaxSymbolAllocationRetry());
            EaiComputedField computedField = new EaiComputedField();
            computedField.setActualName(actualName);
            computedField.setAccessorName(accessorName);
            computedField.setDefinition(backendDefinition);
            computedField.setRenamed(!StringUtils.equals((CharSequence)actualName, (CharSequence)fieldName));
            computedField.setInconsistent(!StringUtils.equals((CharSequence)Introspector.decapitalize(accessorName), (CharSequence)fieldName));
            computedFields.add(computedField);
        }
        return computedFields;
    }

    private static LogicVariableDefinition convertStructureField(EaiParamsItems field) {
        if (field == null) {
            throw new NullPointerException();
        }
        String name = StringUtils.defaultString((String)field.getMappingName(), (String)"");
        String title = StringUtils.defaultString((String)field.getMark(), null);
        LogicType type = EaiStructureGenerateUtils.convertFieldType(field);
        LogicVariableDefinition logicDefinition = new LogicVariableDefinition();
        logicDefinition.setName(name);
        logicDefinition.setTitle(title);
        logicDefinition.setType(type);
        return logicDefinition;
    }

    private static LogicType convertFieldType(EaiParamsItems field) {
        if (field == null) {
            throw new NullPointerException();
        }
        Integer typeKind = field.getType();
        String structureId = field.getQuoteStructureId();
        Integer listItemKind = field.getItemType();
        List typeItems = field.getItems();
        if (typeKind == null) {
            throw new HussarLogicGenerateException("field missing type");
        }
        if (SIMPLE_TYPE_MAPPING.containsKey(typeKind)) {
            return SIMPLE_TYPE_MAPPING.get(typeKind);
        }
        if (typeKind.intValue() == EaiDataType.DATA_TYPE_LIST.getType()) {
            if (SIMPLE_TYPE_MAPPING.containsKey(listItemKind)) {
                return LogicType.of((LogicBuiltinType)LogicBuiltinType.LIST, (LogicType[])new LogicType[]{SIMPLE_TYPE_MAPPING.get(listItemKind)});
            }
            if (CollectionUtils.isEmpty((Collection)typeItems)) {
                throw new HussarLogicGenerateException("list missing item type");
            }
            LogicType listItem = EaiStructureGenerateUtils.convertFieldType((EaiParamsItems)typeItems.get(0));
            return LogicType.of((LogicBuiltinType)LogicBuiltinType.LIST, (LogicType[])new LogicType[]{listItem});
        }
        if (typeKind.intValue() == EaiDataType.DATA_TYPE_STRUCTURE.getType()) {
            return LogicType.of((String)(CUSTOM_PREFIX_STRUCTURE + StringUtils.defaultString((String)structureId)), (LogicType[])new LogicType[0]);
        }
        if (typeKind.intValue() == EaiDataType.DATA_TYPE_PAGE.getType()) {
            if (SIMPLE_TYPE_MAPPING.containsKey(listItemKind)) {
                return LogicType.of((String)PAGE_TYPE_NAME, (LogicType[])new LogicType[]{SIMPLE_TYPE_MAPPING.get(listItemKind)});
            }
            EaiParamsItems recordsItem = Optional.ofNullable(typeItems).flatMap(items -> items.stream().filter(item -> Optional.ofNullable(item).map(EaiParamsItems::getMappingName).filter(PAGE_RECORDS_FIELD_NAME::equals).isPresent()).findFirst()).orElse(null);
            if (recordsItem != null) {
                if (SIMPLE_TYPE_MAPPING.containsKey(recordsItem.getItemType())) {
                    return LogicType.of((String)PAGE_TYPE_NAME, (LogicType[])new LogicType[]{SIMPLE_TYPE_MAPPING.get(recordsItem.getItemType())});
                }
                if (CollectionUtils.isNotEmpty((Collection)recordsItem.getItems())) {
                    LogicType listItem = EaiStructureGenerateUtils.convertFieldType((EaiParamsItems)recordsItem.getItems().get(0));
                    return LogicType.of((String)PAGE_TYPE_NAME, (LogicType[])new LogicType[]{listItem});
                }
            }
            throw new HussarLogicGenerateException("page missing record item type");
        }
        if (typeKind.intValue() == EaiDataType.DATA_TYPE_APIRESPONSE.getType()) {
            if (SIMPLE_TYPE_MAPPING.containsKey(listItemKind)) {
                return LogicType.of((String)API_RESPONSE_TYPE_NAME, (LogicType[])new LogicType[]{SIMPLE_TYPE_MAPPING.get(listItemKind)});
            }
            EaiParamsItems dataItem = Optional.ofNullable(typeItems).flatMap(items -> items.stream().filter(item -> Optional.ofNullable(item).map(EaiParamsItems::getMappingName).filter(API_RESPONSE_DATA_FIELD_NAME::equals).isPresent()).findFirst()).orElse(null);
            if (dataItem == null) {
                throw new HussarLogicGenerateException("api response missing data type");
            }
            LogicType itemType = EaiStructureGenerateUtils.convertFieldType(dataItem);
            return LogicType.of((String)API_RESPONSE_TYPE_NAME, (LogicType[])new LogicType[]{itemType});
        }
        throw new HussarLogicGenerateException("unsupported field type: " + typeKind);
    }

    private static String allocateFieldName(String actualName, Set<String> fieldNames, int maxRetry) {
        String fieldPrefix = LogicSymbolUtils.createSymbol((LogicSymbolUtils.NamingConvention)LogicSymbolUtils.NamingConvention.CAMEL_CASE, (String[])new String[]{actualName});
        if (JAVA_RESERVED.contains(fieldPrefix)) {
            fieldPrefix = "_" + fieldPrefix;
        }
        String fieldName = LogicSymbolUtils.allocateSymbol((String)fieldPrefix, fieldNames::contains, (int)maxRetry);
        fieldNames.add(fieldName);
        return fieldName;
    }

    private static String allocateAccessorName(String actualName, Set<String> accessorNames, int maxRetry) {
        String accessorPrefix = LogicSymbolUtils.createSymbol((LogicSymbolUtils.NamingConvention)LogicSymbolUtils.NamingConvention.PASCAL_CASE, (String[])new String[]{actualName});
        String accessorName = LogicSymbolUtils.allocateSymbol((String)accessorPrefix, accessorNames::contains, (int)maxRetry);
        accessorNames.add(accessorName);
        return accessorName;
    }

    static {
        LinkedHashMap<Integer, LogicType> mapping = new LinkedHashMap<Integer, LogicType>();
        mapping.put(EaiDataType.DATA_TYPE_BOOLEAN.getType(), LogicType.BOOLEAN);
        mapping.put(EaiDataType.DATA_TYPE_INTEGER.getType(), LogicType.INTEGER);
        mapping.put(EaiDataType.DATA_TYPE_LONG.getType(), LogicType.LONG);
        mapping.put(EaiDataType.DATA_TYPE_DOUBLE.getType(), LogicType.DOUBLE);
        mapping.put(EaiDataType.DATA_TYPE_STRING.getType(), LogicType.STRING);
        mapping.put(EaiDataType.DATA_TYPE_DATE.getType(), LogicType.DATE);
        SIMPLE_TYPE_MAPPING = Collections.unmodifiableMap(mapping);
        PAGE_TYPE_NAME = CUSTOM_PREFIX_CLASS + PageVo.class.getName();
        API_RESPONSE_TYPE_NAME = CUSTOM_PREFIX_CLASS + ApiResponse.class.getName();
        String[] keywords = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "true", "false"};
        JAVA_RESERVED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(keywords)));
    }

    private static final class ResolverAdaptor
    implements LogicBackendExternalResolver {
        private final EaiStructureClassNameResolver resolver;
        private final EaiStructureGenerateConfigure configure;

        public ResolverAdaptor(EaiStructureClassNameResolver resolver, EaiStructureGenerateConfigure configure) {
            this.resolver = resolver;
            this.configure = configure;
        }

        public String resolveCustomType(String customTypeName, LogicGenerateConfigure config) {
            if (StringUtils.startsWith((CharSequence)customTypeName, (CharSequence)EaiStructureGenerateUtils.CUSTOM_PREFIX_CLASS)) {
                return StringUtils.removeStart((String)customTypeName, (String)EaiStructureGenerateUtils.CUSTOM_PREFIX_CLASS);
            }
            if (StringUtils.startsWith((CharSequence)customTypeName, (CharSequence)EaiStructureGenerateUtils.CUSTOM_PREFIX_STRUCTURE)) {
                String structureId = StringUtils.removeStart((String)customTypeName, (String)EaiStructureGenerateUtils.CUSTOM_PREFIX_STRUCTURE);
                return this.resolver.resolveStructureClassName(structureId, this.configure);
            }
            throw new UnsupportedOperationException("not supported custom type name: '" + customTypeName + "'");
        }
    }
}

