/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.integration.eai.service.impl;

import com.jxdinfo.hussar.integration.support.annotation.EntityProperty;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateConfigureException;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.context.LogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.render.LogicRenderTemplate;
import com.jxdinfo.hussar.logic.generator.utils.BackendClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendCodeFormatUtils;
import com.jxdinfo.hussar.logic.integration.eai.context.EaiStructureGenerateContext;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateConfigure;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateResult;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateSource;
import com.jxdinfo.hussar.logic.integration.eai.resolver.DefaultStructureClassNameResolverImpl;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureClassNameResolver;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureGenerateService;
import com.jxdinfo.hussar.logic.integration.eai.structure.EaiComputedField;
import com.jxdinfo.hussar.logic.integration.eai.utils.EaiStructureClassNameUtils;
import com.jxdinfo.hussar.logic.integration.eai.utils.EaiStructureGenerateUtils;
import com.jxdinfo.hussar.logic.mixin.LogicJsEntity;
import com.jxdinfo.hussar.logic.properties.HussarLogicProperties;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.eai.LogicEaiContextInfo;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.logic.integration.eai.service.impl.eaiStructureGenerateServiceImpl")
public class EaiStructureGenerateServiceImpl
implements EaiStructureGenerateService {
    private static final String TEMPLATE_PATH = "/template/logic/integration/eai/structure.ftl";
    private static final String FASTJSON_ANNOTATION = "com.alibaba.fastjson.annotation.JSONField";
    private static final String JACKSON_ANNOTATION = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final String GSON_ANNOTATION = "com.google.gson.annotations.SerializedName";
    private final HussarLogicProperties properties;

    @Autowired
    public EaiStructureGenerateServiceImpl(HussarLogicProperties properties) {
        this.properties = properties;
    }

    public String getStructureClassName(String name, List<String> modules, String prefixPackage) {
        return EaiStructureClassNameUtils.structureQualifiedClassOf(name, modules, prefixPackage);
    }

    public EaiStructureGenerateResult generateStructureCode(EaiStructureGenerateSource source, EaiStructureGenerateConfigure configure) {
        if (source == null || configure == null) {
            throw new NullPointerException();
        }
        configure = this.normalizeConfigure(configure);
        String qualifiedName = EaiStructureClassNameUtils.structureQualifiedClassOf(source.getName(), source.getModules(), configure.getPrefixPackage());
        String className = EaiStructureClassNameUtils.structureClassNameOf(source.getName());
        String packageName = BackendClassNameUtils.parseQualifiedClass((String)qualifiedName).getPackageName();
        EaiStructureGenerateContext context = EaiStructureGenerateUtils.createGenerateContext(qualifiedName, source, configure);
        LogicGeneratedCode raw = this.renderStructure(context, source, configure, className, packageName);
        LogicGeneratedCode code = BackendCodeFormatUtils.format((LogicGeneratedCode)raw, (boolean)false);
        EaiStructureGenerateResult result = new EaiStructureGenerateResult();
        result.setName(qualifiedName);
        result.setShortName(className);
        result.setContent(code.getCode());
        return result;
    }

    private EaiStructureGenerateConfigure normalizeConfigure(EaiStructureGenerateConfigure configure) {
        EaiStructureGenerateConfigure cfg;
        try {
            cfg = new EaiStructureGenerateConfigure();
            BeanUtils.copyProperties((Object)cfg, (Object)configure);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new HussarLogicGenerateConfigureException("failed to duplicate configuration", (Throwable)ex);
        }
        if (cfg.getDebug() == null) {
            cfg.setDebug(Boolean.valueOf(false));
        }
        if (cfg.getStructureResolver() == null) {
            cfg.setStructureResolver((EaiStructureClassNameResolver)new DefaultStructureClassNameResolverImpl());
        }
        if (cfg.getMaxSymbolAllocationRetry() == null) {
            cfg.setMaxSymbolAllocationRetry(this.properties.getMaxSymbolAllocationRetry());
        }
        if (cfg.getEaiInfo() == null) {
            cfg.setEaiInfo(new LogicEaiContextInfo());
        }
        return cfg;
    }

    private LogicGeneratedCode renderStructure(EaiStructureGenerateContext context, EaiStructureGenerateSource source, EaiStructureGenerateConfigure configure, String className, String packageName) {
        List<EaiComputedField> fields = EaiStructureGenerateUtils.convertStructureFieldList((BackendLogicGenerateContext)context, configure, source.getFields());
        String baseClass = null;
        String entityBaseClass = configure.getEntityBaseClass();
        if (StringUtils.isNotEmpty((CharSequence)entityBaseClass) && !Objects.equals(entityBaseClass, Object.class.getName())) {
            baseClass = context.addImport(configure.getEntityBaseClass());
        }
        boolean enableToString = Optional.ofNullable(configure.getEnableToString()).orElse(true);
        boolean enableEqualsAndHashCode = Optional.ofNullable(configure.getEnableEqualsAndHashCode()).orElse(false);
        boolean enableFastJson = Optional.ofNullable(configure.getEnableFastJson()).orElse(true);
        boolean enableJackson = Optional.ofNullable(configure.getEnableJackson()).orElse(true);
        boolean enableGson = Optional.ofNullable(configure.getEnableGson()).orElse(false);
        boolean enableNashornJs = Optional.ofNullable(configure.getEnableNashornJs()).orElse(true);
        String entityProperty = null;
        String fastJsonField = null;
        String jacksonJsonProperty = null;
        String gsonSerializedName = null;
        for (EaiComputedField field : fields) {
            if (field == null || !field.isRenamed() && !field.isInconsistent()) continue;
            entityProperty = context.addImport(EntityProperty.class.getName());
            fastJsonField = enableFastJson ? this.registerClassImportIfFound((BackendLogicGenerateContext)context, FASTJSON_ANNOTATION) : null;
            jacksonJsonProperty = enableJackson ? this.registerClassImportIfFound((BackendLogicGenerateContext)context, JACKSON_ANNOTATION) : null;
            gsonSerializedName = enableGson ? this.registerClassImportIfFound((BackendLogicGenerateContext)context, GSON_ANNOTATION) : null;
            break;
        }
        String objectsClassName = null;
        if (enableEqualsAndHashCode) {
            objectsClassName = context.addImport(Objects.class.getName());
        }
        String logicJsEntityClassName = null;
        if (enableNashornJs) {
            logicJsEntityClassName = context.addImport(LogicJsEntity.class.getName());
        }
        return LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)context.getRootComponent(), (String)TEMPLATE_PATH).parameter("packageName", (Object)packageName).parameter("imports", (Object)context.getImports()).parameter("className", (Object)className).parameter("baseClass", (Object)baseClass).parameter("logicJsEntity", (Object)logicJsEntityClassName).parameter("fields", fields).parameter("enableToString", (Object)enableToString).parameter("enableEqualsAndHashCode", (Object)enableEqualsAndHashCode).parameter("objectsClass", (Object)objectsClassName).parameter("entityProperty", (Object)entityProperty).parameter("fastJsonField", (Object)fastJsonField).parameter("jacksonJsonProperty", (Object)jacksonJsonProperty).parameter("gsonSerializedName", (Object)gsonSerializedName).render();
    }

    private String registerClassImportIfFound(BackendLogicGenerateContext context, String className) {
        if (this.getClass().getClassLoader().getResource(className.replace('.', '/') + ".class") == null) {
            return null;
        }
        return context.addImport(className);
    }
}

