/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationEntityException;
import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionEvaluator;
import com.jxdinfo.hussar.integration.support.expression.engine.HussarExpressionEngine;
import com.jxdinfo.hussar.integration.support.expression.engine.HussarExpressionEngineFactory;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationEntityUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.logic.exception.HussarLogicSupportException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogicSupportUtils {
    private static final Logger logger = LoggerFactory.getLogger(LogicSupportUtils.class);
    private static final ThreadLocal<WeakThreadLocalBeansCache> BEANS_CACHE = ThreadLocal.withInitial(() -> new WeakThreadLocalBeansCache());
    private static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};

    private LogicSupportUtils() {
    }

    public static LocalDateTime date(String literal) {
        if (literal == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)(literal = Arrays.stream(StringUtils.split((String)literal)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" "))))) {
            return null;
        }
        return (LocalDateTime)LogicSupportUtils.getConvertUtils().convert((Object)literal, LocalDateTime.class);
    }

    public static LocalTime time(String literal) {
        if (literal == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)(literal = Arrays.stream(StringUtils.split((String)literal)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" "))))) {
            return null;
        }
        return (LocalTime)LogicSupportUtils.getConvertUtils().convert((Object)literal, LocalTime.class);
    }

    public static <T> T create(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (clazz.isPrimitive() || clazz.isArray() || clazz.isEnum() || clazz.isAnnotation() || Number.class.isAssignableFrom(clazz) || clazz == Boolean.class || clazz == Character.class) {
            throw new HussarLogicSupportException("cannot create type: " + clazz);
        }
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            if (clazz == List.class) {
                return (T)new ArrayList();
            }
            if (clazz == Map.class) {
                return (T)new LinkedHashMap();
            }
            if (clazz == Set.class) {
                return (T)new LinkedHashSet();
            }
            if (clazz == Deque.class) {
                return (T)new ArrayDeque();
            }
            throw new HussarLogicSupportException("cannot create container: " + clazz);
        }
        if (clazz == Object.class) {
            return (T)new LinkedHashMap();
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            throw new HussarLogicSupportException("cannot create type: " + clazz);
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new HussarLogicSupportException("failed to create bean: " + clazz, ex);
        }
    }

    public static <T> T create(TypeReference<T> typeReference) {
        Class clazz;
        if (typeReference == null) {
            throw new NullPointerException();
        }
        Type type = typeReference.getType();
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new HussarLogicSupportException("cannot to create bean of type: " + type);
        }
        return LogicSupportUtils.create(clazz);
    }

    public static <T> T convert(Object value, Class<T> clazz) {
        HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getConvertUtils();
        return (T)convertUtils.convert(value, clazz);
    }

    public static <T> T convert(Object value, TypeReference<T> typeReference) {
        HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getConvertUtils();
        return (T)convertUtils.convert(value, typeReference);
    }

    public static <T> Stream<T> stream(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return Stream.empty();
        }
        return collection.stream();
    }

    public static String toJsonString(Object value) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return jsonUtils.toString(value);
    }

    public static <T> T parseJson(String text, Class<T> clazz) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.parse(text, clazz);
    }

    public static <T> T parseJson(String text, TypeReference<T> typeReference) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.parse(text, typeReference);
    }

    public static <T> T jsonConvert(Object value, Class<T> clazz) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.convert(value, clazz);
    }

    public static <T> T jsonConvert(Object value, TypeReference<T> typeReference) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.convert(value, typeReference);
    }

    public static Object getProperty(Object subject, String ... properties) {
        HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = LogicSupportUtils.getEntityUtils();
        Object current = subject;
        for (String property : properties) {
            if (current == null) {
                throw new NullPointerException("cannot get property '" + property + "' of null");
            }
            if (current instanceof Map) {
                current = ((Map)current).get(property);
                continue;
            }
            try {
                current = entityUtils.getProperty(current, property, false);
            }
            catch (HussarIntegrationEntityException ex) {
                throw new HussarLogicSupportException(ex);
            }
        }
        return current;
    }

    public static <T> T getProperty(Class<T> clazz, Object subject, String ... properties) {
        Object property = LogicSupportUtils.getProperty(subject, properties);
        HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getAggressivelyReuseConvertUtils();
        return (T)convertUtils.convert(property, clazz);
    }

    public static <T> T getProperty(TypeReference<T> typeReference, Object subject, String ... properties) {
        Object property = LogicSupportUtils.getProperty(subject, properties);
        HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getAggressivelyReuseConvertUtils();
        return (T)convertUtils.convert(property, typeReference);
    }

    public static void setProperty(Object subject, String property, Object value) {
        HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = LogicSupportUtils.getEntityUtils();
        if (subject == null) {
            throw new NullPointerException();
        }
        if (subject instanceof Map) {
            ((Map)subject).put(property, value);
        } else {
            try {
                entityUtils.setProperty(subject, property, value, false);
            }
            catch (HussarIntegrationEntityException ex) {
                throw new HussarLogicSupportException(ex);
            }
        }
    }

    public static ChainAccessor access(Object subject) {
        return ChainAccessor.of(subject);
    }

    public static <T> T trace(Logger logger, String explanation, T value) {
        if (logger == null || explanation == null) {
            return value;
        }
        logger.trace("{}\u7ed3\u679c = {}", (Object)explanation, value);
        return value;
    }

    public static <T> T unwrapApiResponse(ApiResponse<T> response) {
        if (response == null) {
            return null;
        }
        if (response.isSuccess()) {
            return (T)response.getData();
        }
        logger.error("failed to unwrap ApiResponse<T>: code={}, message={}, data={}", new Object[]{response.getCode(), response.getMsg(), response.getData()});
        throw new HussarException(Integer.valueOf(response.getCode()), response.getMsg());
    }

    public static ChoreoRunner choreoInvocation(String businessId) {
        return ChoreoRunner.begin(businessId);
    }

    public static ExpressionRunner expressionEngine() {
        return BaseExpressionRunner.of();
    }

    public static TypeReference<Map<String, Object>> getMapType() {
        return MAP_TYPE;
    }

    public static void checkpoint() {
        if (Thread.currentThread().isInterrupted()) {
            throw new HussarLogicSupportException("thread interrupted", new InterruptedException());
        }
    }

    public static HussarIntegrationJsonUtils.JsonUtilsBean getJsonUtils() {
        return BEANS_CACHE.get().getJsonUtils();
    }

    public static HussarIntegrationConvertUtils.ConvertUtilsBean getConvertUtils() {
        return BEANS_CACHE.get().getConvertUtils();
    }

    public static HussarIntegrationConvertUtils.ConvertUtilsBean getAggressivelyReuseConvertUtils() {
        return BEANS_CACHE.get().getAggressivelyReuseConvertUtils();
    }

    public static HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtils() {
        return BEANS_CACHE.get().getEntityUtils();
    }

    private static final class WeakThreadLocalBeansCache {
        private WeakReference<HussarIntegrationJsonUtils.JsonUtilsBean> jsonUtils;
        private WeakReference<HussarIntegrationConvertUtils.ConvertUtilsBean> convertUtils;
        private WeakReference<HussarIntegrationConvertUtils.ConvertUtilsBean> aggressivelyReuseConvertUtils;
        private WeakReference<HussarIntegrationEntityUtils.EntityUtilsBean> entityUtils;

        private WeakThreadLocalBeansCache() {
        }

        public HussarIntegrationJsonUtils.JsonUtilsBean getJsonUtils() {
            if (this.jsonUtils == null || this.jsonUtils.get() == null) {
                this.jsonUtils = new WeakReference<HussarIntegrationJsonUtils.JsonUtilsBean>(HussarIntegrationJsonUtils.Contextual.createUtilsBean());
            }
            return (HussarIntegrationJsonUtils.JsonUtilsBean)this.jsonUtils.get();
        }

        public HussarIntegrationConvertUtils.ConvertUtilsBean getConvertUtils() {
            if (this.convertUtils == null || this.convertUtils.get() == null) {
                this.convertUtils = new WeakReference<HussarIntegrationConvertUtils.ConvertUtilsBean>(HussarIntegrationConvertUtils.createUtilsBean((boolean)true, (String[])new String[0]));
            }
            return (HussarIntegrationConvertUtils.ConvertUtilsBean)this.convertUtils.get();
        }

        public HussarIntegrationConvertUtils.ConvertUtilsBean getAggressivelyReuseConvertUtils() {
            if (this.aggressivelyReuseConvertUtils == null || this.aggressivelyReuseConvertUtils.get() == null) {
                this.aggressivelyReuseConvertUtils = new WeakReference<HussarIntegrationConvertUtils.ConvertUtilsBean>(HussarIntegrationConvertUtils.createUtilsBean((boolean)true, (String[])new String[]{"reuse.aggressive"}));
            }
            return (HussarIntegrationConvertUtils.ConvertUtilsBean)this.aggressivelyReuseConvertUtils.get();
        }

        public HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtils() {
            if (this.entityUtils == null || this.entityUtils.get() == null) {
                this.entityUtils = new WeakReference<HussarIntegrationEntityUtils.EntityUtilsBean>(HussarIntegrationEntityUtils.createUtilsBean((boolean)true));
            }
            return (HussarIntegrationEntityUtils.EntityUtilsBean)this.entityUtils.get();
        }
    }

    public static final class ChoreoRunner {
        private static final String TRACE_LOG_MODEL_INVOKE = "{} \u6210\u529f, \u8fd4\u56de = {}";
        private static final String DEFAULT_TRACE_MESSAGE = "\u8c03\u7528\u89e3\u6790\u5f15\u64ce\u65b9\u6cd5 %s";
        private final String businessId;
        private final Map<String, Object> params = new LinkedHashMap<String, Object>();
        private final EngineBussnessdataInvokeService invokeService;
        private final HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils;
        private boolean unwrapApiResponse = true;
        private Logger traceLogger;
        private String traceMessage;

        private ChoreoRunner(String businessId, EngineBussnessdataInvokeService invokeService, HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils) {
            this.businessId = businessId;
            this.invokeService = invokeService;
            this.jsonUtils = jsonUtils;
        }

        public static ChoreoRunner begin(String businessId) {
            if (businessId == null) {
                throw new NullPointerException();
            }
            EngineBussnessdataInvokeService invokeService = (EngineBussnessdataInvokeService)SpringContextHolder.getBean(EngineBussnessdataInvokeService.class);
            HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
            return new ChoreoRunner(businessId, invokeService, jsonUtils);
        }

        public ChoreoRunner param(String name, Object value) {
            this.params.put(name, value);
            return this;
        }

        public ChoreoRunner params(Object params) {
            Map normalized = params != null ? (Map)this.jsonUtils.parse(this.jsonUtils.toString(params), (TypeReference)new TypeReference<Map<String, Object>>(){}) : new LinkedHashMap();
            this.params.putAll(normalized);
            return this;
        }

        public ChoreoRunner clearParams() {
            this.params.clear();
            return this;
        }

        public ChoreoRunner unwrapApiResponse(boolean unwrapApiResponse) {
            this.unwrapApiResponse = unwrapApiResponse;
            return this;
        }

        public ChoreoRunner trace(Logger logger) {
            this.traceLogger = logger;
            return this;
        }

        public ChoreoRunner trace(Logger logger, String message) {
            this.traceLogger = logger;
            this.traceMessage = message;
            return this;
        }

        public Object invoke() {
            Object result = this.doInvoke();
            this.doTrace(result);
            return result;
        }

        public <T> T invoke(Class<T> clazz) {
            Object result = this.jsonUtils.convert(this.doInvoke(), clazz);
            this.doTrace(result);
            return (T)result;
        }

        public <T> T invoke(TypeReference<T> typeReference) {
            Object result = this.jsonUtils.convert(this.doInvoke(), typeReference);
            this.doTrace(result);
            return (T)result;
        }

        private Object doInvoke() {
            ApiResponse result = this.invokeService.invoke(this.businessId, this.params);
            if (!this.unwrapApiResponse) {
                return result;
            }
            return LogicSupportUtils.unwrapApiResponse(result);
        }

        private void doTrace(Object result) {
            if (this.traceLogger == null) {
                return;
            }
            String message = this.traceMessage;
            if (StringUtils.isEmpty((CharSequence)message)) {
                message = String.format(DEFAULT_TRACE_MESSAGE, this.businessId);
            }
            this.traceLogger.trace(TRACE_LOG_MODEL_INVOKE, (Object)message, result);
        }
    }

    public static class BaseExpressionRunner
    implements ExpressionRunner {
        protected final HussarExpressionEngine expressionEngine = expressionEngineFactory.configuring("ES5").create();
        protected final HussarExpressionEvaluator expressionEvaluator = this.expressionEngine.preparing();
        private static final HussarExpressionEngineFactory expressionEngineFactory = (HussarExpressionEngineFactory)SpringContextHolder.getBean(HussarExpressionEngineFactory.class);

        protected BaseExpressionRunner() {
        }

        public static BaseExpressionRunner of() {
            return new BaseExpressionRunner();
        }

        @Override
        public BaseExpressionRunner bind(String name, Object value) {
            this.expressionEvaluator.variable(name, value);
            return this;
        }

        @Override
        public BaseExpressionRunner bind(Map<String, Object> scope) {
            this.expressionEvaluator.variables(scope);
            return this;
        }

        @Override
        public Object eval(String script) {
            return this.expressionEvaluator.evaluate(script);
        }

        @Override
        public <T> T eval(String script, Class<T> clazz) {
            return LogicSupportUtils.convert(this.eval(script), clazz);
        }

        @Override
        public <T> T eval(String script, TypeReference<T> type) {
            return LogicSupportUtils.convert(this.eval(script), type);
        }
    }

    public static interface ExpressionRunner {
        public ExpressionRunner bind(String var1, Object var2);

        public ExpressionRunner bind(Map<String, Object> var1);

        public Object eval(String var1);

        public <T> T eval(String var1, Class<T> var2);

        public <T> T eval(String var1, TypeReference<T> var2);
    }

    public static final class ChainAccessor {
        private Object subject;
        private final HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = LogicSupportUtils.getEntityUtils();

        private ChainAccessor(Object subject) {
            this.subject = subject;
        }

        public static ChainAccessor of(Object subject) {
            return new ChainAccessor(subject);
        }

        public ChainAccessor into(String field) {
            if (this.subject == null) {
                throw new NullPointerException("cannot get property '" + field + "' of null");
            }
            if (this.subject instanceof Map) {
                this.subject = ((Map)this.subject).get(field);
            } else {
                try {
                    this.subject = this.entityUtils.getProperty(this.subject, field, false);
                }
                catch (HussarIntegrationEntityException ex) {
                    throw new HussarLogicSupportException(ex);
                }
            }
            return this;
        }

        public ChainAccessor into(int index) {
            List list;
            if (this.subject == null) {
                throw new NullPointerException("cannot get index " + index + " of null");
            }
            if (this.subject instanceof List) {
                list = (List)this.subject;
                if (index < 0 || index >= list.size()) {
                    throw new ArrayIndexOutOfBoundsException("cannot get index " + index + " of a list sized " + list.size());
                }
            } else {
                throw new IllegalStateException("cannot get index " + index + " of a non-list object of type " + this.subject.getClass().getName());
            }
            this.subject = list.get(index);
            return this;
        }

        public Object read() {
            return this.subject;
        }

        public <T> T read(Class<T> clazz) {
            HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getAggressivelyReuseConvertUtils();
            return (T)convertUtils.convert(this.read(), clazz);
        }

        public <T> T read(TypeReference<T> typeReference) {
            HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getAggressivelyReuseConvertUtils();
            return (T)convertUtils.convert(this.read(), typeReference);
        }

        public void write(String field, Object value) {
            if (this.subject == null) {
                throw new NullPointerException("cannot set property '" + field + "' of null");
            }
            if (this.subject instanceof Map) {
                ((Map)this.subject).put(field, value);
            } else {
                try {
                    this.entityUtils.setProperty(this.subject, field, value, false);
                }
                catch (HussarIntegrationEntityException ex) {
                    throw new HussarLogicSupportException(ex);
                }
            }
        }

        public void write(int index, Object value) {
            List list;
            if (this.subject == null) {
                throw new NullPointerException("cannot set index " + index + " of null");
            }
            if (this.subject instanceof List) {
                list = (List)this.subject;
                if (index < 0 || index >= list.size()) {
                    throw new ArrayIndexOutOfBoundsException("cannot set index " + index + " of a list sized " + list.size());
                }
            } else {
                throw new IllegalStateException("cannot set index " + index + " of a non-list object of type " + this.subject.getClass().getName());
            }
            list.set(index, value);
        }
    }

    public static final class EntityBuilder<T> {
        private final HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = LogicSupportUtils.getEntityUtils();
        private final T entity;

        public EntityBuilder(Class<T> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            try {
                this.entity = this.entityUtils.createEntity(clazz);
            }
            catch (Exception ex) {
                throw new HussarLogicSupportException("failed to initiate " + clazz.getName(), ex);
            }
        }

        public EntityBuilder(TypeReference<T> typeReference) {
            Class clazz;
            if (typeReference == null) {
                throw new NullPointerException();
            }
            Type type = typeReference.getType();
            if (type instanceof Class) {
                clazz = (Class)type;
            } else if (type instanceof ParameterizedType) {
                clazz = (Class)((ParameterizedType)type).getRawType();
            } else {
                throw new HussarLogicSupportException("cannot initiate " + type);
            }
            try {
                this.entity = this.entityUtils.createEntity(clazz);
            }
            catch (Exception ex) {
                throw new HussarLogicSupportException("failed to initiate " + clazz.getName(), ex);
            }
        }

        public EntityBuilder(T entity) {
            if (entity == null) {
                throw new NullPointerException();
            }
            this.entity = entity;
        }

        public <U> EntityBuilder<T> set(BiConsumer<T, U> setter, U value) {
            setter.accept(this.entity, value);
            return this;
        }

        public EntityBuilder<T> set(String property, Object value) {
            try {
                this.entityUtils.setProperty(this.entity, property, value, true);
                return this;
            }
            catch (Exception ex) {
                throw new HussarLogicSupportException("failed to set property '" + property + "' for " + this.entity.getClass().getName(), ex);
            }
        }

        public EntityBuilder<T> set(T other) {
            if (other != null) {
                try {
                    this.entityUtils.copyProperties(this.entity, other);
                }
                catch (Exception ex) {
                    throw new HussarLogicSupportException("failed to copy properties from " + other.getClass().getName() + "' to " + this.entity.getClass().getName(), ex);
                }
            }
            return this;
        }

        public T build() {
            return this.entity;
        }
    }

    public static final class MapBuilder<K, V> {
        private final Map<K, V> map;

        public MapBuilder() {
            this.map = new LinkedHashMap();
        }

        public MapBuilder(int capacity) {
            this.map = new LinkedHashMap(capacity);
        }

        public MapBuilder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public MapBuilder<K, V> put(Map<? extends K, ? extends V> other) {
            if (other != null) {
                this.map.putAll(other);
            }
            return this;
        }

        public Map<K, V> build() {
            return this.map;
        }
    }

    public static final class ListBuilder<T> {
        private final List<T> list = new ArrayList<T>();

        public ListBuilder() {
        }

        public ListBuilder(int capacity) {
        }

        public ListBuilder<T> add(T item) {
            this.list.add(item);
            return this;
        }

        public ListBuilder<T> add(Collection<? extends T> other) {
            if (other != null) {
                this.list.addAll(other);
            }
            return this;
        }

        public List<T> build() {
            return this.list;
        }
    }
}

