/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.utils;

import com.jxdinfo.hussar.logic.annotation.LogicFunctionExport;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class LogicFunctionUtils {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private LogicFunctionUtils() {
    }

    @LogicFunctionExport(title="\u5bf9\u8c61\u5224\u7a7a", description="\u5224\u65ad\u5bf9\u8c61\u662f\u5426\u4e3a null", params={@LogicFunctionExport.Param(value="object", title="\u8f93\u5165\u5bf9\u8c61")}, returns="\u5bf9\u8c61\u662f\u5426\u4e3a\u7a7a")
    public static <T> boolean isNull(T object) {
        return Objects.isNull(object);
    }

    @LogicFunctionExport(title="\u5bf9\u8c61\u975e\u7a7a\u5224\u65ad", description="\u5224\u65ad\u5bf9\u8c61\u662f\u5426\u4e0d\u662f null", params={@LogicFunctionExport.Param(value="object", title="\u8f93\u5165\u5bf9\u8c61")}, returns="\u5bf9\u8c61\u662f\u5426\u4e0d\u662f\u7a7a")
    public static <T> boolean isNotNull(T object) {
        return !LogicFunctionUtils.isNull(object);
    }

    @LogicFunctionExport(title="\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u5224\u7a7a", description="\u5224\u65ad\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u662f\u5426\u4e3a\u7a7a", params={@LogicFunctionExport.Param(value="object", title="\u8f93\u5165\u5bb9\u5668\u6216\u5b57\u7b26\u4e32")}, returns="\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u662f\u5426\u4e3a\u7a7a")
    public static <T> boolean isEmpty(T object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return StringUtils.isEmpty((CharSequence)((String)object));
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() == 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() == 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return false;
    }

    @LogicFunctionExport(title="\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u975e\u7a7a\u5224\u65ad", description="\u5224\u65ad\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u662f\u5426\u975e\u7a7a", params={@LogicFunctionExport.Param(value="object", title="\u8f93\u5165\u5bb9\u5668\u6216\u5b57\u7b26\u4e32")}, returns="\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u662f\u5426\u975e\u7a7a")
    public static <T> boolean isNotEmpty(T object) {
        return !LogicFunctionUtils.isEmpty(object);
    }

    @LogicFunctionExport(title="\u5bf9\u8c61\u9ed8\u8ba4\u503c", description="\u5bf9\u8c61\u4e3a\u7a7a\u65f6\u53d6\u9ed8\u8ba4\u503c", params={@LogicFunctionExport.Param(value="object", title="\u8f93\u5165\u5bf9\u8c61"), @LogicFunctionExport.Param(value="defaultValue", title="\u9ed8\u8ba4\u503c")}, returns="\u6700\u7ec8\u5bf9\u8c61\u503c")
    public static <T> T defaultIfNull(T object, T defaultValue) {
        return Objects.isNull(object) ? defaultValue : object;
    }

    @LogicFunctionExport(title="\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u9ed8\u8ba4\u503c", description="\u5bb9\u5668\u6216\u5b57\u7b26\u4e32\u4e3a\u7a7a\u65f6\u53d6\u9ed8\u8ba4\u503c", params={@LogicFunctionExport.Param(value="object", title="\u8f93\u5165\u5bb9\u5668\u6216\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="defaultValue", title="\u9ed8\u8ba4\u503c")}, returns="\u6700\u7ec8\u5bb9\u5668\u6216\u5b57\u7b26\u4e32")
    public static <T> T defaultIfEmpty(T object, T defaultValue) {
        return LogicFunctionUtils.isEmpty(object) ? defaultValue : object;
    }

    @LogicFunctionExport(title="\u5bf9\u8c61\u5927\u5c0f\u6bd4\u8f83", description="\u5224\u65ad\u8f93\u5165\u5bf9\u8c61\u5927\u5c0f\uff0c\u76f8\u7b49\u8fd4\u56de\u96f6\uff0c\u5c0f\u4e8e\u8fd4\u56de\u8d1f\u6570\uff0c\u5927\u4e8e\u8fd4\u56de\u6b63\u6570", params={@LogicFunctionExport.Param(value="object", title="\u7b2c\u4e00\u4e2a\u5bf9\u8c61"), @LogicFunctionExport.Param(value="other", title="\u7b2c\u4e8c\u4e2a\u5bf9\u8c61")}, returns="\u6bd4\u8f83\u7ed3\u679c")
    public static <T extends Comparable<T>> int compare(T object, T other) {
        if (object == null && other == null) {
            return 0;
        }
        if (object != null && other != null) {
            return object.compareTo(other);
        }
        if (object != null) {
            return 1;
        }
        return -1;
    }

    @LogicFunctionExport(title="\u6570\u5b57\u53d6\u7edd\u5bf9\u503c", description="\u8ba1\u7b97\u6307\u5b9a\u6570\u5b57\u7684\u7edd\u5bf9\u503c", params={@LogicFunctionExport.Param(value="value", title="\u6570\u5b57")}, returns="\u7edd\u5bf9\u503c")
    public static <T extends Number> T numberAbs(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (T)Integer.valueOf(Math.abs(value.intValue()));
        }
        if (value instanceof Long) {
            return (T)Long.valueOf(Math.abs(value.longValue()));
        }
        if (value instanceof Double) {
            return (T)Double.valueOf(Math.abs(value.doubleValue()));
        }
        if (value instanceof BigInteger) {
            return (T)((BigInteger)value).abs();
        }
        if (value instanceof BigDecimal) {
            return (T)((BigDecimal)value).abs();
        }
        throw new UnsupportedOperationException("abs() do not support input number type: " + value.getClass());
    }

    @LogicFunctionExport(title="\u6570\u5b57\u53d6\u7b26\u53f7\u503c", description="\u8ba1\u7b97\u6307\u5b9a\u6570\u5b57\u7684\u7b26\u53f7\u503c\uff0c\u6b63\u6570\u8fd4\u56de 1\uff0c\u8d1f\u6570\u8fd4\u56de -1\uff0c\u96f6\u8fd4\u56de 0, \u975e\u6570\u5b57\u6d6e\u70b9\u503c\u8fd4\u56de NaN", params={@LogicFunctionExport.Param(value="value", title="\u6570\u5b57")}, returns="\u7b26\u53f7\u503c")
    public static <T extends Number> T numberSign(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (T)Integer.valueOf(Integer.signum(value.intValue()));
        }
        if (value instanceof Long) {
            return (T)Long.valueOf(Long.signum(value.longValue()));
        }
        if (value instanceof Double) {
            return (T)Double.valueOf(Math.signum(value.doubleValue()));
        }
        if (value instanceof BigInteger) {
            return (T)BigInteger.valueOf(((BigInteger)value).signum());
        }
        if (value instanceof BigDecimal) {
            return (T)BigDecimal.valueOf(((BigDecimal)value).signum());
        }
        throw new UnsupportedOperationException("sign() do not support input number type: " + value.getClass());
    }

    @LogicFunctionExport(title="\u6570\u5b57\u5411\u4e0b\u53d6\u6574", description="\u8ba1\u7b97\u6307\u5b9a\u6570\u5b57\u5411\u4e0b\u53d6\u6574\u7ed3\u679c", params={@LogicFunctionExport.Param(value="value", title="\u6570\u5b57")}, returns="\u53d6\u6574\u7ed3\u679c")
    public static <T extends Number> T numberFloor(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            return (T)Double.valueOf(Math.floor(value.doubleValue()));
        }
        if (value instanceof BigInteger) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return (T)((BigDecimal)value).setScale(0, RoundingMode.FLOOR);
        }
        throw new UnsupportedOperationException("floor() do not support input number type: " + value.getClass());
    }

    @LogicFunctionExport(title="\u6570\u5b57\u5411\u4e0a\u53d6\u6574", description="\u8ba1\u7b97\u6307\u5b9a\u6570\u5b57\u5411\u4e0a\u53d6\u6574\u7ed3\u679c", params={@LogicFunctionExport.Param(value="value", title="\u6570\u5b57")}, returns="\u53d6\u6574\u7ed3\u679c")
    public static <T extends Number> T numberCeil(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            return (T)Double.valueOf(Math.ceil(value.doubleValue()));
        }
        if (value instanceof BigInteger) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return (T)((BigDecimal)value).setScale(0, RoundingMode.CEILING);
        }
        throw new UnsupportedOperationException("ceil() do not support input number type: " + value.getClass());
    }

    @LogicFunctionExport(title="\u6570\u5b57\u56db\u820d\u4e94\u5165", description="\u8ba1\u7b97\u6307\u5b9a\u6570\u5b57\u56db\u820d\u4e94\u5165\u53d6\u6574\u7ed3\u679c", params={@LogicFunctionExport.Param(value="value", title="\u6570\u5b57")}, returns="\u53d6\u6574\u7ed3\u679c")
    public static <T extends Number> T numberRound(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            double origin = value.doubleValue();
            if (!Double.isFinite(origin)) {
                return value;
            }
            double rounded = BigDecimal.valueOf(origin).setScale(0, RoundingMode.HALF_UP).doubleValue();
            return (T)Double.valueOf(rounded);
        }
        if (value instanceof BigInteger) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return (T)((BigDecimal)value).setScale(0, RoundingMode.HALF_UP);
        }
        throw new UnsupportedOperationException("round() do not support input number type: " + value.getClass());
    }

    @LogicFunctionExport(title="\u6570\u5b57\u53d6\u968f\u673a\u6570", description="\u83b7\u53d6\u6307\u5b9a\u8303\u56f4\u5185\u7684\u968f\u673a\u6570", params={@LogicFunctionExport.Param(value="from", title="\u4e0b\u754c"), @LogicFunctionExport.Param(value="to", title="\u4e0a\u754c")}, returns="\u968f\u673a\u6570\u5b57")
    public static <T extends Number> T numberRandom(T from, T to) {
        if (from == null && to == null) {
            return null;
        }
        if (from == null) {
            if (to instanceof Integer) {
                return (T)Integer.valueOf(ThreadLocalRandom.current().nextInt(Integer.MIN_VALUE, to.intValue()));
            }
            if (to instanceof Long) {
                return (T)Long.valueOf(ThreadLocalRandom.current().nextLong(Long.MIN_VALUE, to.longValue()));
            }
            if (to instanceof Double) {
                double originTo = to.doubleValue();
                if (originTo == Double.POSITIVE_INFINITY) {
                    return (T)Double.valueOf(ThreadLocalRandom.current().nextDouble(Double.MIN_VALUE, Double.MAX_VALUE));
                }
                if (!Double.isFinite(originTo)) {
                    return (T)Double.valueOf(Double.NaN);
                }
                return (T)Double.valueOf(ThreadLocalRandom.current().nextDouble(Double.MIN_VALUE, originTo));
            }
            if (to instanceof BigInteger) {
                throw new UnsupportedOperationException("random() do not support upper bound number type: " + to.getClass());
            }
            throw new UnsupportedOperationException("random() do not support bound number type: " + to.getClass());
        }
        if (to == null) {
            if (from instanceof Integer) {
                return (T)Integer.valueOf(ThreadLocalRandom.current().nextInt(from.intValue(), Integer.MAX_VALUE));
            }
            if (from instanceof Long) {
                return (T)Long.valueOf(ThreadLocalRandom.current().nextLong(from.longValue(), Long.MAX_VALUE));
            }
            if (from instanceof Double) {
                double originFrom = from.doubleValue();
                if (originFrom == Double.NEGATIVE_INFINITY) {
                    return (T)Double.valueOf(ThreadLocalRandom.current().nextDouble(Double.MIN_VALUE, Double.MAX_VALUE));
                }
                if (!Double.isFinite(originFrom)) {
                    return (T)Double.valueOf(Double.NaN);
                }
                return (T)Double.valueOf(ThreadLocalRandom.current().nextDouble(originFrom, Double.MAX_VALUE));
            }
            if (from instanceof BigInteger) {
                throw new UnsupportedOperationException("random() do not support lower bound number type: " + from.getClass());
            }
            throw new UnsupportedOperationException("random() do not support bound number type: " + from.getClass());
        }
        if (from instanceof Integer) {
            int upper;
            int lower = from.intValue();
            if (lower >= (upper = to.intValue())) {
                return from;
            }
            return (T)Integer.valueOf(ThreadLocalRandom.current().nextInt(lower, upper));
        }
        if (from instanceof Long) {
            long upper;
            long lower = from.longValue();
            if (lower >= (upper = to.longValue())) {
                return from;
            }
            return (T)Long.valueOf(ThreadLocalRandom.current().nextLong(lower, upper));
        }
        if (from instanceof Double) {
            double upper;
            double lower = from.doubleValue();
            if (!(lower < (upper = to.doubleValue()))) {
                return from;
            }
            if (lower == Double.NEGATIVE_INFINITY) {
                lower = Double.MIN_VALUE;
            }
            if (upper == Double.POSITIVE_INFINITY) {
                upper = Double.MAX_VALUE;
            }
            if (!Double.isFinite(lower) || !Double.isFinite(upper)) {
                return (T)Double.valueOf(Double.NaN);
            }
            return (T)Double.valueOf(ThreadLocalRandom.current().nextDouble(lower, upper));
        }
        if (from instanceof BigInteger && to instanceof BigInteger) {
            BigInteger random;
            BigInteger lower = (BigInteger)from;
            BigInteger upper = (BigInteger)to;
            if (lower.compareTo(upper) >= 0) {
                return from;
            }
            BigInteger delta = upper.subtract(lower);
            while ((random = new BigInteger(delta.bitLength(), ThreadLocalRandom.current())).compareTo(delta) >= 0) {
            }
            return (T)random.add(lower);
        }
        throw new UnsupportedOperationException("random() do not support bound number type: " + from.getClass() + ", " + to.getClass());
    }

    @LogicFunctionExport(title="\u6570\u5b57\u6307\u6570\u8fd0\u7b97", description="\u8ba1\u7b97\u6307\u5b9a\u6570\u5b57\u7684\u6307\u6570\u503c", params={@LogicFunctionExport.Param(value="base", title="\u5e95\u6570"), @LogicFunctionExport.Param(value="exp", title="\u6307\u6570")}, returns="\u6307\u6570\u503c")
    public static <T extends Number> T numberPow(T base, T exp) {
        if (base == null || exp == null) {
            return null;
        }
        if (base instanceof Integer && exp instanceof Integer) {
            int a = base.intValue();
            int b = exp.intValue();
            return (T)Integer.valueOf((int)Math.pow(a, b));
        }
        if (base instanceof Long && exp instanceof Long) {
            long a = base.longValue();
            long b = exp.longValue();
            return (T)Long.valueOf((long)Math.pow(a, b));
        }
        if (base instanceof Double && exp instanceof Double) {
            double a = base.doubleValue();
            double b = exp.doubleValue();
            return (T)Double.valueOf(Math.pow(a, b));
        }
        if (base instanceof BigInteger && exp instanceof BigInteger) {
            BigInteger a = (BigInteger)base;
            BigInteger b = (BigInteger)exp;
            if (!b.equals(BigInteger.valueOf(b.intValue()))) {
                throw new IllegalArgumentException("pow() exponent too large");
            }
            return (T)a.pow(b.intValue());
        }
        if (base instanceof BigDecimal && exp instanceof BigDecimal) {
            BigDecimal a = (BigDecimal)base;
            BigDecimal b = (BigDecimal)exp;
            if (!b.equals(BigDecimal.valueOf(b.intValue()))) {
                throw new IllegalArgumentException("pow() exponent not integral or too large");
            }
            return (T)a.pow(b.intValue());
        }
        throw new UnsupportedOperationException("pow() do not support input number type: " + base.getClass() + ", " + exp.getClass());
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u83b7\u53d6\u957f\u5ea6", description="\u83b7\u53d6\u5b57\u7b26\u4e32\u4e2d UTF-16 \u5b57\u7b26\u6570\u91cf", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32")}, returns="\u5b57\u7b26\u4e32\u957f\u5ea6")
    public static Integer stringLength(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u62fc\u63a5", description="\u6839\u636e\u7ed9\u5b9a\u7684\u5206\u9694\u7b26\u62fc\u63a5\u5b57\u7b26\u4e32\u5217\u8868", params={@LogicFunctionExport.Param(value="strings", title="\u5b57\u7b26\u4e32\u5217\u8868"), @LogicFunctionExport.Param(value="separator", title="\u5206\u9694\u7b26")}, returns="\u62fc\u63a5\u7ed3\u679c")
    public static String stringJoin(List<String> strings, String separator) {
        if (strings == null) {
            return "";
        }
        separator = StringUtils.defaultString((String)separator, (String)"");
        return String.join((CharSequence)separator, strings);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u5207\u5206", description="\u6839\u636e\u7ed9\u5b9a\u7684\u5206\u9694\u7b26\u5207\u5206\u51fa\u5b57\u7b26\u4e32\u5217\u8868", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="separator", title="\u5206\u9694\u7b26")}, returns="\u5207\u5206\u7ed3\u679c")
    public static List<String> stringSplit(String string, String separator) {
        int start;
        if (string == null) {
            return new ArrayList<String>();
        }
        if (string.isEmpty()) {
            return new ArrayList<String>(Collections.singletonList(""));
        }
        if (separator == null) {
            return new ArrayList<String>(Arrays.asList(string.trim().split("\\s+")));
        }
        if (separator.isEmpty()) {
            return string.codePoints().mapToObj(cp -> new String(Character.toChars(cp))).collect(Collectors.toList());
        }
        ArrayList<String> segments = new ArrayList<String>();
        int end = 0;
        while ((start = string.indexOf(separator, end)) >= 0) {
            segments.add(string.substring(end, start));
            end = start + separator.length();
        }
        segments.add(string.substring(end));
        return segments;
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u5305\u542b", description="\u67e5\u627e\u5b57\u7b26\u4e32\u4e2d\u662f\u5426\u5305\u542b\u5b50\u5b57\u7b26\u4e32\u5185\u5bb9", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="search", title="\u5b50\u5b57\u7b26\u4e32")}, returns="\u662f\u5426\u5305\u542b")
    public static boolean stringContains(String string, String search) {
        return StringUtils.contains((CharSequence)string, (CharSequence)search);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u524d\u7f00\u5224\u65ad", description="\u5224\u65ad\u5b57\u7b26\u4e32\u662f\u5426\u4ee5\u5b50\u5b57\u7b26\u4e32\u5185\u5bb9\u4e3a\u8d77\u59cb", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="prefix", title="\u524d\u7f00")}, returns="\u662f\u5426\u5339\u914d\u524d\u7f00")
    public static boolean stringStartsWith(String string, String prefix) {
        return StringUtils.startsWith((CharSequence)string, (CharSequence)prefix);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u540e\u7f00\u5224\u65ad", description="\u5224\u65ad\u5b57\u7b26\u4e32\u662f\u5426\u4ee5\u5b50\u5b57\u7b26\u4e32\u5185\u5bb9\u4e3a\u7ed3\u675f", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="suffix", title="\u540e\u7f00")}, returns="\u662f\u5426\u5339\u914d\u540e\u7f00")
    public static boolean stringEndsWith(String string, String suffix) {
        return StringUtils.endsWith((CharSequence)string, (CharSequence)suffix);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u5339\u914d", description="\u5224\u65ad\u5b57\u7b26\u4e32\u662f\u5426\u5339\u914d\u6307\u5b9a\u7684\u6b63\u5219\u8868\u8fbe\u5f0f", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="pattern", title="\u6b63\u5219\u8868\u8fbe\u5f0f")}, returns="\u662f\u5426\u5339\u914d\u6b63\u5219")
    public static boolean stringMatches(String string, String pattern) {
        if (string == null || pattern == null) {
            return false;
        }
        return Pattern.compile(pattern).matcher(string).matches();
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u5ffd\u7565\u5927\u5c0f\u5199\u5224\u65ad", description="\u5224\u65ad\u4e24\u4e2a\u5b57\u7b26\u4e32\u5ffd\u7565\u5927\u5c0f\u5199\u540e\u662f\u5426\u76f8\u7b49", params={@LogicFunctionExport.Param(value="string", title="\u7b2c\u4e00\u4e2a\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="other", title="\u7b2c\u4e8c\u4e2a\u5b57\u7b26\u4e32")}, returns="\u662f\u5426\u7b49\u4ef7")
    public static boolean stringEqualsIgnoreCase(String string, String other) {
        return StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)other);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u622a\u53d6", description="\u6839\u636e\u4e0b\u6807\u4f4d\u7f6e\u622a\u53d6\u5b57\u7b26\u4e32", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="start", title="\u8d77\u59cb"), @LogicFunctionExport.Param(value="end", title="\u7ed3\u675f")}, returns="\u5b50\u5b57\u7b26\u4e32")
    public static String stringSubstring(String string, int start, int end) {
        return StringUtils.substring((String)string, (int)start, (int)end);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u66ff\u6362", description="\u5168\u6587\u66ff\u6362\u5b57\u7b26\u4e32\u5185\u5bb9", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="search", title="\u641c\u7d22"), @LogicFunctionExport.Param(value="replacement", title="\u66ff\u6362")}, returns="\u66ff\u6362\u7ed3\u679c")
    public static String stringReplace(String string, String search, String replacement) {
        return StringUtils.replace((String)string, (String)search, (String)replacement);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u91cd\u590d", description="\u5c06\u8f93\u5165\u5b57\u7b26\u4e32\u5185\u5bb9\u91cd\u590d\u6307\u5b9a\u6b21\u6570", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="count", title="\u6b21\u6570")}, returns="\u91cd\u590d\u540e\u7684\u5b57\u7b26\u4e32")
    public static String stringRepeat(String string, int count) {
        return StringUtils.repeat((String)string, (int)count);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u5934\u5c3e\u53bb\u7a7a\u767d", description="\u5c06\u8f93\u5165\u5b57\u7b26\u4e32\u5934\u5c3e\u7684\u7a7a\u767d\u5b57\u7b26\u53bb\u9664", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32")}, returns="\u5934\u5c3e\u7a7a\u767d\u53bb\u9664\u7ed3\u679c")
    public static String stringStrip(String string) {
        return StringUtils.trim((String)string);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u5f00\u5934\u53bb\u7a7a\u767d", description="\u5c06\u8f93\u5165\u5b57\u7b26\u4e32\u5f00\u5934\u7684\u7a7a\u767d\u5b57\u7b26\u53bb\u9664", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32")}, returns="\u5f00\u5934\u7a7a\u767d\u53bb\u9664\u7ed3\u679c")
    public static String stringStripStart(String string) {
        return StringUtils.stripStart((String)string, null);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u7ed3\u5c3e\u53bb\u7a7a\u767d", description="\u5c06\u8f93\u5165\u5b57\u7b26\u4e32\u7ed3\u5c3e\u7684\u7a7a\u767d\u5b57\u7b26\u53bb\u9664", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32")}, returns="\u7ed3\u5c3e\u7a7a\u767d\u53bb\u9664\u7ed3\u679c")
    public static String stringStripEnd(String string) {
        return StringUtils.stripEnd((String)string, null);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u8f6c\u5c0f\u5199", description="\u5c06\u8f93\u5165\u5b57\u7b26\u4e32\u8f6c\u4e3a\u5c0f\u5199", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32")}, returns="\u8f6c\u5c0f\u5199\u7ed3\u679c")
    public static String stringToLower(String string) {
        return StringUtils.lowerCase((String)string);
    }

    @LogicFunctionExport(title="\u5b57\u7b26\u4e32\u8f6c\u5927\u5199", description="\u5c06\u8f93\u5165\u5b57\u7b26\u4e32\u8f6c\u4e3a\u5927\u5199", params={@LogicFunctionExport.Param(value="string", title="\u5b57\u7b26\u4e32")}, returns="\u8f6c\u5927\u5199\u7ed3\u679c")
    public static String stringToUpper(String string) {
        return StringUtils.upperCase((String)string);
    }

    @LogicFunctionExport(title="\u5217\u8868\u83b7\u53d6\u957f\u5ea6", description="\u83b7\u53d6\u5217\u8868\u5bb9\u5668\u7684\u957f\u5ea6\uff0c\u4e3a null \u65f6\u8fd4\u56de\u96f6", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868")}, returns="\u957f\u5ea6")
    public static <T> int listSize(List<T> list) {
        return list != null ? list.size() : 0;
    }

    @LogicFunctionExport(title="\u5217\u8868\u83b7\u53d6\u5143\u7d20", description="\u83b7\u53d6\u5217\u8868\u5bb9\u5668\u6307\u5b9a\u4e0b\u6807\u7684\u5143\u7d20\uff0c\u8d8a\u754c\u65f6\u62a5\u9519", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868"), @LogicFunctionExport.Param(value="index", title="\u4e0b\u6807")}, returns="\u5217\u8868\u5143\u7d20")
    public static <T> T listGet(List<T> list, int index) {
        int size = LogicFunctionUtils.listSize(list);
        if (index < 0 || index >= size) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " out of range [0, " + list.size() + ")");
        }
        return list.get(index);
    }

    @LogicFunctionExport(title="\u5217\u8868\u8bbe\u7f6e\u5143\u7d20", description="\u8bbe\u7f6e\u5217\u8868\u5bb9\u5668\u6307\u5b9a\u4e0b\u6807\u7684\u5143\u7d20\u7684\u503c\uff0c\u8d8a\u754c\u65f6\u62a5\u9519", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868"), @LogicFunctionExport.Param(value="index", title="\u4e0b\u6807"), @LogicFunctionExport.Param(value="value", title="\u5143\u7d20")}, returns="\u4fee\u6539\u540e\u7684\u5217\u8868")
    public static <T> List<T> listSet(List<T> list, int index, T value) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index >= list.size()) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " out of range [0, " + list.size() + ")");
        }
        list.set(index, value);
        return list;
    }

    @LogicFunctionExport(title="\u5217\u8868\u8ffd\u52a0\u5143\u7d20", description="\u5411\u5217\u8868\u7ed3\u5c3e\u4f4d\u7f6e\u65b0\u589e\u5143\u7d20", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868"), @LogicFunctionExport.Param(value="item", title="\u5143\u7d20")}, returns="\u4fee\u6539\u540e\u7684\u5217\u8868")
    public static <T> List<T> listAppend(List<T> list, T item) {
        if (list == null) {
            throw new NullPointerException();
        }
        list.add(item);
        return list;
    }

    @LogicFunctionExport(title="\u5217\u8868\u63d2\u5165\u5143\u7d20", description="\u5411\u5217\u8868\u6307\u5b9a\u4f4d\u7f6e\u63d2\u5165\u5143\u7d20\uff0c\u8d8a\u754c\u65f6\u62a5\u9519", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868"), @LogicFunctionExport.Param(value="index", title="\u4e0b\u6807"), @LogicFunctionExport.Param(value="item", title="\u5143\u7d20")}, returns="\u4fee\u6539\u540e\u7684\u5217\u8868")
    public static <T> List<T> listInsert(List<T> list, int index, T item) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index > list.size()) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " out of range [0, " + list.size() + "]");
        }
        list.add(index, item);
        return list;
    }

    @LogicFunctionExport(title="\u5217\u8868\u5220\u9664\u5143\u7d20", description="\u4ece\u5217\u8868\u6307\u5b9a\u4f4d\u7f6e\u5220\u9664\u5143\u7d20\uff0c\u8d8a\u754c\u65f6\u62a5\u9519", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868"), @LogicFunctionExport.Param(value="index", title="\u4e0b\u6807")}, returns="\u5220\u9664\u7684\u5143\u7d20")
    public static <T> T listRemove(List<T> list, int index) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index >= list.size()) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " out of range [0, " + list.size() + ")");
        }
        return list.remove(index);
    }

    @LogicFunctionExport(title="\u5217\u8868\u62fc\u63a5", description="\u5c06\u4e24\u4e2a\u5217\u8868\u62fc\u63a5\u4e3a\u4e00\u4e2a\u65b0\u7684\u5217\u8868", params={@LogicFunctionExport.Param(value="head", title="\u7b2c\u4e00\u4e2a\u5217\u8868"), @LogicFunctionExport.Param(value="tail", title="\u7b2c\u4e8c\u4e2a\u5217\u8868")}, returns="\u62fc\u63a5\u51fa\u7684\u65b0\u5217\u8868")
    public static <T> List<T> listConcat(List<T> head, List<T> tail) {
        ArrayList<T> concat = new ArrayList<T>(LogicFunctionUtils.listSize(head) + LogicFunctionUtils.listSize(tail));
        if (head != null) {
            concat.addAll(head);
        }
        if (tail != null) {
            concat.addAll(tail);
        }
        return concat;
    }

    @LogicFunctionExport(title="\u5217\u8868\u6392\u5e8f", description="\u5c06\u5217\u8868\u4e2d\u7684\u5143\u7d20\u6309\u7167\u4ece\u5c0f\u5230\u5927\u7684\u987a\u5e8f\u91cd\u65b0\u6392\u5e8f", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868")}, returns="\u4fee\u6539\u540e\u7684\u5217\u8868")
    public static <T extends Comparable<T>> List<T> listSort(List<T> list) {
        list = list != null ? list : new ArrayList();
        list.sort(Comparator.nullsFirst(Comparator.naturalOrder()));
        return list;
    }

    @LogicFunctionExport(title="\u5217\u8868\u53cd\u8f6c", description="\u5c06\u5217\u8868\u4e2d\u7684\u5143\u7d20\u987a\u5e8f\u53cd\u8f6c", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868")}, returns="\u4fee\u6539\u540e\u7684\u5217\u8868")
    public static <T> List<T> listReverse(List<T> list) {
        list = list != null ? list : new ArrayList();
        Collections.reverse(list);
        return list;
    }

    @LogicFunctionExport(title="\u5217\u8868\u53bb\u91cd", description="\u5c06\u5217\u8868\u4e2d\u7684\u91cd\u590d\u5143\u7d20\u53bb\u9664", params={@LogicFunctionExport.Param(value="list", title="\u5217\u8868")}, returns="\u4fee\u6539\u540e\u7684\u5217\u8868")
    public static <T> List<T> listDistinct(List<T> list) {
        if (list == null) {
            return null;
        }
        List distinct = list.stream().distinct().collect(Collectors.toList());
        list.clear();
        list.addAll(distinct);
        return list;
    }

    @LogicFunctionExport(title="\u6620\u5c04\u83b7\u53d6\u957f\u5ea6", description="\u83b7\u53d6 Map \u5bb9\u5668\u7684\u5927\u5c0f", params={@LogicFunctionExport.Param(value="map", title="\u6620\u5c04")}, returns="\u957f\u5ea6")
    public static <K, V> int mapSize(Map<K, V> map) {
        return map != null ? map.size() : 0;
    }

    @LogicFunctionExport(title="\u6620\u5c04\u83b7\u53d6\u5143\u7d20", description="\u6839\u636e\u952e\u503c\u83b7\u53d6 Map \u5bb9\u5668\u4e2d\u5143\u7d20\u503c", params={@LogicFunctionExport.Param(value="map", title="\u6620\u5c04"), @LogicFunctionExport.Param(value="key", title="\u952e\u503c")}, returns="\u5143\u7d20")
    public static <K, V> V mapGet(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    @LogicFunctionExport(title="\u6620\u5c04\u8bbe\u7f6e\u5143\u7d20", description="\u6839\u636e\u952e\u503c\u8bbe\u7f6e Map \u5bb9\u5668\u4e2d\u5143\u7d20\u503c\uff0c\u8fd4\u56de\u65e7\u5143\u7d20\u503c\uff0c\u65e7\u5143\u7d20\u4e0d\u5b58\u5728\u5219\u8fd4\u56de null", params={@LogicFunctionExport.Param(value="map", title="\u6620\u5c04"), @LogicFunctionExport.Param(value="key", title="\u952e\u503c"), @LogicFunctionExport.Param(value="value", title="\u5143\u7d20")}, returns="\u65e7\u5143\u7d20\u503c")
    public static <K, V> V mapSet(Map<K, V> map, K key, V value) {
        if (map == null) {
            return null;
        }
        return map.put(key, value);
    }

    @LogicFunctionExport(title="\u6620\u5c04\u5220\u9664\u5143\u7d20", description="\u6839\u636e\u952e\u503c\u5220\u9664 Map \u5bb9\u5668\u4e2d\u5143\u7d20\u503c\uff0c\u8fd4\u56de\u65e7\u5143\u7d20\u503c\uff0c\u65e7\u5143\u7d20\u4e0d\u5b58\u5728\u5219\u8fd4\u56de null", params={@LogicFunctionExport.Param(value="map", title="\u6620\u5c04"), @LogicFunctionExport.Param(value="key", title="\u952e\u503c")}, returns="\u65e7\u5143\u7d20\u503c")
    public static <K, V> V mapRemove(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.remove(key);
    }

    @LogicFunctionExport(title="\u6620\u5c04\u83b7\u53d6\u5168\u90e8\u952e\u503c", description="\u83b7\u53d6 Map \u5bb9\u5668\u7684\u5168\u90e8\u952e\u503c\u5217\u8868", params={@LogicFunctionExport.Param(value="map", title="\u6620\u5c04")}, returns="\u952e\u503c\u5217\u8868")
    public static <K, V> List<K> mapKeys(Map<K, V> map) {
        if (map == null) {
            return new ArrayList();
        }
        return new ArrayList<K>(map.keySet());
    }

    @LogicFunctionExport(title="\u6620\u5c04\u83b7\u53d6\u5168\u90e8\u5143\u7d20\u503c", description="\u83b7\u53d6 Map \u5bb9\u5668\u7684\u5168\u90e8\u5143\u7d20\u503c\u5217\u8868", params={@LogicFunctionExport.Param(value="map", title="\u6620\u5c04")}, returns="\u5143\u7d20\u503c\u5217\u8868")
    public static <K, V> List<V> mapValues(Map<K, V> map) {
        if (map == null) {
            return new ArrayList();
        }
        return new ArrayList<V>(map.values());
    }

    @LogicFunctionExport(title="\u6620\u5c04\u5408\u5e76", description="\u5c06\u4e24\u4e2a Map \u5bb9\u5668\u7684\u5168\u90e8\u952e\u503c\u5143\u7d20\u5408\u5e76\uff0c\u8fd4\u56de\u65b0\u7684 Map \u5bb9\u5668", params={@LogicFunctionExport.Param(value="first", title="\u7b2c\u4e00\u4e2a\u6620\u5c04"), @LogicFunctionExport.Param(value="second", title="\u7b2c\u4e8c\u4e2a\u6620\u5c04")}, returns="\u65b0\u7684\u6620\u5c04")
    public static <K, V> Map<K, V> mapMerge(Map<K, V> first, Map<K, V> second) {
        LinkedHashMap<K, V> merge = new LinkedHashMap<K, V>(LogicFunctionUtils.mapSize(first) + LogicFunctionUtils.mapSize(second));
        if (first != null) {
            merge.putAll(first);
        }
        if (second != null) {
            merge.putAll(second);
        }
        return merge;
    }

    @LogicFunctionExport(title="\u5f53\u524d\u65e5\u671f\u65f6\u95f4", description="\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u65e5\u671f\u65f6\u95f4", params={}, returns="\u5f53\u524d\u7cfb\u7edf\u65e5\u671f")
    public static LocalDateTime dateNow() {
        return LocalDateTime.now();
    }

    @LogicFunctionExport(title="\u521b\u5efa\u65e5\u671f", description="\u901a\u8fc7\u5e74\u6708\u65e5\u6570\u5b57\u521b\u5efa\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="year", title="\u5e74\u4efd"), @LogicFunctionExport.Param(value="month", title="\u6708\u4efd"), @LogicFunctionExport.Param(value="day", title="\u65e5\u671f")}, returns="\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61")
    public static LocalDateTime dateOfYmd(int year, int month, int day) {
        return LocalDate.of(year, month, day).atStartOfDay();
    }

    @LogicFunctionExport(title="\u521b\u5efa\u65e5\u671f\u65f6\u95f4", description="\u901a\u8fc7\u5e74\u6708\u65e5\u65f6\u5206\u79d2\u6570\u5b57\u521b\u5efa\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="year", title="\u5e74\u4efd"), @LogicFunctionExport.Param(value="month", title="\u6708\u4efd"), @LogicFunctionExport.Param(value="day", title="\u65e5\u671f"), @LogicFunctionExport.Param(value="hour", title="\u5c0f\u65f6"), @LogicFunctionExport.Param(value="minute", title="\u5206\u949f"), @LogicFunctionExport.Param(value="second", title="\u79d2\u6570")}, returns="\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61")
    public static LocalDateTime dateOfYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u5316", description="\u901a\u8fc7\u6307\u5b9a\u683c\u5f0f\u5c06\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="format", title="\u683c\u5f0f")}, returns="\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32")
    public static String dateFormat(LocalDateTime date, String format) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern(format != null ? format : DEFAULT_DATE_FORMAT).format(date);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u89e3\u6790", description="\u901a\u8fc7\u6307\u5b9a\u683c\u5f0f\u5c06\u5b57\u7b26\u4e32\u89e3\u6790\u4e3a\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u5b57\u7b26\u4e32"), @LogicFunctionExport.Param(value="format", title="\u683c\u5f0f")}, returns="\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61")
    public static LocalDateTime dateParse(String date, String format) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.parse(date, DateTimeFormatter.ofPattern(format != null ? format : DEFAULT_DATE_FORMAT));
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u8f6c\u65f6\u95f4\u6233", description="\u5c06\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61\u8f6c\u6362\u4e3a\u8ddd\u79bb 1970-01-01 \u5348\u591c\u7684\u6beb\u79d2\u6570", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u65f6\u95f4\u6233")
    public static long dateToTimestamp(LocalDateTime date) {
        if (date == null) {
            return 0L;
        }
        return ZonedDateTime.of(date, ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u5348\u591c\u65f6\u95f4", description="\u5c06\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61\u7684\u65f6\u95f4\u6e05\u7a7a\uff0c\u8c03\u6574\u81f3\u5348\u591c\u65f6\u95f4", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61")
    public static LocalDateTime dateClearTime(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalDate().atStartOfDay();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u5e74\u4efd\u6570", description="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u5e74\u4efd\u6570\u5b57", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u5e74\u4efd")
    public static int dateGetYear(LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException();
        }
        return date.getYear();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u5e74\u4efd\u6570", description="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u5e74\u4efd\u6570\u5b57\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="year", title="\u5e74\u4efd")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateSetYear(LocalDateTime date, int year) {
        if (date == null) {
            return null;
        }
        return date.withYear(year);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u504f\u79fb\u5e74\u4efd\u6570", description="\u5c06\u65e5\u671f\u65f6\u95f4\u5e74\u4efd\u6570\u5b57\u504f\u79fb\u6307\u5b9a\u7684\u6570\u91cf\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="years", title="\u5e74\u4efd\u504f\u79fb\u91cf")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateAddYear(LocalDateTime date, long years) {
        if (date == null) {
            return null;
        }
        return date.plusYears(years);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u6708\u4efd\u6570", description="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u6708\u4efd\u6570\u5b57", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u6708\u4efd")
    public static int dateGetMonth(LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException();
        }
        return date.getMonth().getValue();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u6708\u4efd\u6570", description="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u6708\u4efd\u6570\u5b57\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="month", title="\u6708\u4efd")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateSetMonth(LocalDateTime date, int month) {
        if (date == null) {
            return null;
        }
        return date.withMonth(month);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u504f\u79fb\u6708\u4efd\u6570", description="\u5c06\u65e5\u671f\u65f6\u95f4\u6708\u4efd\u6570\u5b57\u504f\u79fb\u6307\u5b9a\u7684\u6570\u91cf\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="months", title="\u6708\u4efd\u504f\u79fb\u91cf")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateAddMonth(LocalDateTime date, long months) {
        if (date == null) {
            return null;
        }
        return date.plusMonths(months);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u65e5\u671f\u6570", description="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u65e5\u671f\u6570\u5b57", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u65e5\u671f\u6570")
    public static int dateGetDay(LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException();
        }
        return date.getDayOfMonth();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u65e5\u671f\u6570", description="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u65e5\u671f\u6570\u5b57\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="day", title="\u65e5\u671f\u6570")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateSetDay(LocalDateTime date, int day) {
        if (date == null) {
            return null;
        }
        return date.withDayOfMonth(day);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u504f\u79fb\u65e5\u671f\u6570", description="\u5c06\u65e5\u671f\u65f6\u95f4\u65e5\u671f\u6570\u5b57\u504f\u79fb\u6307\u5b9a\u7684\u6570\u91cf\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="days", title="\u65e5\u671f\u504f\u79fb\u91cf")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateAddDay(LocalDateTime date, long days) {
        if (date == null) {
            return null;
        }
        return date.plusDays(days);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u5c0f\u65f6\u6570", description="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u5c0f\u65f6\u6570\u5b57", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u5c0f\u65f6")
    public static int dateGetHour(LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException();
        }
        return date.getHour();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u5c0f\u65f6\u6570", description="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u5c0f\u65f6\u6570\u5b57\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="hour", title="\u5c0f\u65f6")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateSetHour(LocalDateTime date, int hour) {
        if (date == null) {
            return null;
        }
        return date.withHour(hour);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u504f\u79fb\u5c0f\u65f6\u6570", description="\u5c06\u65e5\u671f\u65f6\u95f4\u5c0f\u65f6\u6570\u5b57\u504f\u79fb\u6307\u5b9a\u7684\u6570\u91cf\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="hours", title="\u5c0f\u65f6\u504f\u79fb\u91cf")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateAddHour(LocalDateTime date, long hours) {
        if (date == null) {
            return null;
        }
        return date.plusHours(hours);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u5206\u949f\u6570", description="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u5206\u949f\u6570\u5b57", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u5206\u949f")
    public static int dateGetMinute(LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException();
        }
        return date.getMinute();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u5206\u949f\u6570", description="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u5206\u949f\u6570\u5b57\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="minute", title="\u5206\u949f")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateSetMinute(LocalDateTime date, int minute) {
        if (date == null) {
            return null;
        }
        return date.withMinute(minute);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u504f\u79fb\u5206\u949f\u6570", description="\u5c06\u65e5\u671f\u65f6\u95f4\u5206\u949f\u6570\u5b57\u504f\u79fb\u6307\u5b9a\u7684\u6570\u91cf\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="minutes", title="\u5206\u949f\u504f\u79fb\u91cf")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateAddMinute(LocalDateTime date, long minutes) {
        if (date == null) {
            return null;
        }
        return date.plusMinutes(minutes);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u79d2\u6570", description="\u65e5\u671f\u65f6\u95f4\u83b7\u53d6\u79d2\u6570", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4")}, returns="\u79d2\u6570")
    public static int dateGetSecond(LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException();
        }
        return date.getSecond();
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u79d2\u6570", description="\u65e5\u671f\u65f6\u95f4\u8bbe\u7f6e\u79d2\u6570\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="second", title="\u79d2\u6570")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateSetSecond(LocalDateTime date, int second) {
        if (date == null) {
            return null;
        }
        return date.withSecond(second);
    }

    @LogicFunctionExport(title="\u65e5\u671f\u65f6\u95f4\u504f\u79fb\u79d2\u6570", description="\u5c06\u65e5\u671f\u65f6\u95f4\u79d2\u6570\u504f\u79fb\u6307\u5b9a\u7684\u6570\u91cf\uff0c\u8fd4\u56de\u4fee\u6539\u540e\u65b0\u521b\u5efa\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61", params={@LogicFunctionExport.Param(value="date", title="\u65e5\u671f\u65f6\u95f4"), @LogicFunctionExport.Param(value="seconds", title="\u79d2\u6570\u504f\u79fb\u91cf")}, returns="\u4fee\u6539\u540e\u7684\u65e5\u671f\u65f6\u95f4")
    public static LocalDateTime dateAddSecond(LocalDateTime date, long seconds) {
        if (date == null) {
            return null;
        }
        return date.plusSeconds(seconds);
    }
}

