/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationEntityException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationEntityUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.logic.exception.HussarLogicScriptException;
import com.jxdinfo.hussar.logic.exception.HussarLogicSupportException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogicSupportUtils {
    private static final Logger logger = LoggerFactory.getLogger(LogicSupportUtils.class);
    private static final ThreadLocal<WeakThreadLocalBeansCache> BEANS_CACHE = ThreadLocal.withInitial(() -> new WeakThreadLocalBeansCache());
    private static final List<DateTimeFormatter> FALLBACK_DATE_TIME_FORMATS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_INSTANT);
    private static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};

    private LogicSupportUtils() {
    }

    public static LocalDateTime date(String literal) {
        if (StringUtils.isNotEmpty((CharSequence)(literal = Arrays.stream(StringUtils.split((String)literal)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" "))))) {
            return null;
        }
        for (DateTimeFormatter format : FALLBACK_DATE_TIME_FORMATS) {
            try {
                return LocalDateTime.parse(literal, format);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static <T> T create(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (clazz.isPrimitive() || clazz.isArray() || clazz.isEnum() || clazz.isAnnotation() || Number.class.isAssignableFrom(clazz) || clazz == Boolean.class || clazz == Character.class) {
            throw new HussarLogicSupportException("cannot create type: " + clazz);
        }
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            if (clazz == List.class) {
                return (T)new ArrayList();
            }
            if (clazz == Map.class) {
                return (T)new LinkedHashMap();
            }
            if (clazz == Set.class) {
                return (T)new LinkedHashSet();
            }
            if (clazz == Deque.class) {
                return (T)new ArrayDeque();
            }
            throw new HussarLogicSupportException("cannot create container: " + clazz);
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            throw new HussarLogicSupportException("cannot create type: " + clazz);
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new HussarLogicSupportException("failed to create bean: " + clazz, ex);
        }
    }

    public static <T> T create(TypeReference<T> typeReference) {
        Class clazz;
        if (typeReference == null) {
            throw new NullPointerException();
        }
        Type type = typeReference.getType();
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new HussarLogicSupportException("cannot to create bean of type: " + type);
        }
        return LogicSupportUtils.create(clazz);
    }

    public static <T> T convert(Object value, Class<T> clazz) {
        HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getConvertUtils();
        return (T)convertUtils.convert(value, clazz);
    }

    public static <T> T convert(Object value, TypeReference<T> typeReference) {
        HussarIntegrationConvertUtils.ConvertUtilsBean convertUtils = LogicSupportUtils.getConvertUtils();
        return (T)convertUtils.convert(value, typeReference);
    }

    public static <T> Stream<T> stream(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return Stream.empty();
        }
        return collection.stream();
    }

    public static String toJsonString(Object value) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return jsonUtils.toString(value);
    }

    public static <T> T parseJson(String text, Class<T> clazz) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.parse(text, clazz);
    }

    public static <T> T parseJson(String text, TypeReference<T> typeReference) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.parse(text, typeReference);
    }

    public static <T> T jsonConvert(Object value, Class<T> clazz) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.convert(value, clazz);
    }

    public static <T> T jsonConvert(Object value, TypeReference<T> typeReference) {
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
        return (T)jsonUtils.convert(value, typeReference);
    }

    public static Object getProperty(Object subject, String ... properties) {
        HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = LogicSupportUtils.getEntityUtils();
        Object current = subject;
        for (String property : properties) {
            if (current == null) {
                throw new NullPointerException("cannot get property '" + property + "' of null");
            }
            if (current instanceof Map) {
                current = ((Map)current).get(property);
                continue;
            }
            try {
                current = entityUtils.getProperty(current, property, false);
            }
            catch (HussarIntegrationEntityException ex) {
                throw new HussarLogicSupportException(ex);
            }
        }
        return current;
    }

    public static <T> T getProperty(Class<T> clazz, Object subject, String ... properties) {
        Object property = LogicSupportUtils.getProperty(subject, properties);
        return LogicSupportUtils.convert(property, clazz);
    }

    public static <T> T getProperty(TypeReference<T> typeReference, Object subject, String ... properties) {
        Object property = LogicSupportUtils.getProperty(subject, properties);
        return LogicSupportUtils.convert(property, typeReference);
    }

    public static void setProperty(Object subject, String property, Object value) {
        HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = LogicSupportUtils.getEntityUtils();
        if (subject == null) {
            throw new NullPointerException();
        }
        if (subject instanceof Map) {
            ((Map)subject).put(property, value);
        } else {
            try {
                entityUtils.setProperty(subject, property, value, false);
            }
            catch (HussarIntegrationEntityException ex) {
                throw new HussarLogicSupportException(ex);
            }
        }
    }

    public static <T> T trace(Logger logger, String explanation, T value) {
        if (logger == null || explanation == null) {
            return value;
        }
        logger.trace("{}\u7ed3\u679c = {}", (Object)explanation, value);
        return value;
    }

    public static <T> T unwrapApiResponse(ApiResponse<T> response) {
        if (response == null) {
            return null;
        }
        if (response.isSuccess()) {
            return (T)response.getData();
        }
        logger.error("failed to unwrap ApiResponse<T>: code={}, message={}, data={}", new Object[]{response.getCode(), response.getMsg(), response.getData()});
        throw new HussarException(Integer.valueOf(response.getCode()), response.getMsg());
    }

    public static ChoreoRunner choreoInvocation(String businessId) {
        return ChoreoRunner.begin(businessId);
    }

    public static ScriptRunner scriptEngine(String engineName) {
        return ScriptRunner.forEngine(engineName);
    }

    public static TypeReference<Map<String, Object>> getMapType() {
        return MAP_TYPE;
    }

    public static void checkpoint() {
        if (Thread.currentThread().isInterrupted()) {
            throw new HussarLogicSupportException("thread interrupted", new InterruptedException());
        }
    }

    private static HussarIntegrationJsonUtils.JsonUtilsBean getJsonUtils() {
        return BEANS_CACHE.get().getJsonUtils();
    }

    private static HussarIntegrationConvertUtils.ConvertUtilsBean getConvertUtils() {
        return BEANS_CACHE.get().getConvertUtils();
    }

    private static HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtils() {
        return BEANS_CACHE.get().getEntityUtils();
    }

    static /* synthetic */ HussarIntegrationEntityUtils.EntityUtilsBean access$000() {
        return LogicSupportUtils.getEntityUtils();
    }

    private static final class WeakThreadLocalBeansCache {
        private WeakReference<HussarIntegrationJsonUtils.JsonUtilsBean> jsonUtils;
        private WeakReference<HussarIntegrationConvertUtils.ConvertUtilsBean> convertUtils;
        private WeakReference<HussarIntegrationEntityUtils.EntityUtilsBean> entityUtils;

        private WeakThreadLocalBeansCache() {
        }

        public HussarIntegrationJsonUtils.JsonUtilsBean getJsonUtils() {
            if (this.jsonUtils == null || this.jsonUtils.get() == null) {
                this.jsonUtils = new WeakReference<HussarIntegrationJsonUtils.JsonUtilsBean>(HussarIntegrationJsonUtils.createUtilsBean());
            }
            return (HussarIntegrationJsonUtils.JsonUtilsBean)this.jsonUtils.get();
        }

        public HussarIntegrationConvertUtils.ConvertUtilsBean getConvertUtils() {
            if (this.convertUtils == null || this.convertUtils.get() == null) {
                this.convertUtils = new WeakReference<HussarIntegrationConvertUtils.ConvertUtilsBean>(HussarIntegrationConvertUtils.createUtilsBean((boolean)true));
            }
            return (HussarIntegrationConvertUtils.ConvertUtilsBean)this.convertUtils.get();
        }

        public HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtils() {
            if (this.entityUtils == null || this.entityUtils.get() == null) {
                this.entityUtils = new WeakReference<HussarIntegrationEntityUtils.EntityUtilsBean>(HussarIntegrationEntityUtils.createUtilsBean((boolean)true));
            }
            return (HussarIntegrationEntityUtils.EntityUtilsBean)this.entityUtils.get();
        }
    }

    public static final class ChoreoRunner {
        private static final String TRACE_LOG_MODEL_INVOKE = "{} \u6210\u529f, \u8fd4\u56de = {}";
        private static final String DEFAULT_TRACE_MESSAGE = "\u8c03\u7528\u89e3\u6790\u5f15\u64ce\u65b9\u6cd5 %s";
        private final String businessId;
        private final Map<String, Object> params = new LinkedHashMap<String, Object>();
        private final EngineBussnessdataInvokeService invokeService;
        private final HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils;
        private boolean unwrapApiResponse = true;
        private Logger traceLogger;
        private String traceMessage;

        private ChoreoRunner(String businessId, EngineBussnessdataInvokeService invokeService, HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils) {
            this.businessId = businessId;
            this.invokeService = invokeService;
            this.jsonUtils = jsonUtils;
        }

        public static ChoreoRunner begin(String businessId) {
            if (businessId == null) {
                throw new NullPointerException();
            }
            EngineBussnessdataInvokeService invokeService = (EngineBussnessdataInvokeService)SpringContextHolder.getBean(EngineBussnessdataInvokeService.class);
            HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = LogicSupportUtils.getJsonUtils();
            return new ChoreoRunner(businessId, invokeService, jsonUtils);
        }

        public ChoreoRunner param(String name, Object value) {
            this.params.put(name, value);
            return this;
        }

        public ChoreoRunner params(Object params) {
            Map normalized = params != null ? (Map)this.jsonUtils.parse(this.jsonUtils.toString(params), (TypeReference)new TypeReference<Map<String, Object>>(){}) : new LinkedHashMap();
            this.params.putAll(normalized);
            return this;
        }

        public ChoreoRunner clearParams() {
            this.params.clear();
            return this;
        }

        public ChoreoRunner unwrapApiResponse(boolean unwrapApiResponse) {
            this.unwrapApiResponse = unwrapApiResponse;
            return this;
        }

        public ChoreoRunner trace(Logger logger) {
            this.traceLogger = logger;
            return this;
        }

        public ChoreoRunner trace(Logger logger, String message) {
            this.traceLogger = logger;
            this.traceMessage = message;
            return this;
        }

        public Object invoke() {
            Object result = this.doInvoke();
            this.doTrace(result);
            return result;
        }

        public <T> T invoke(Class<T> clazz) {
            Object result = this.jsonUtils.convert(this.doInvoke(), clazz);
            this.doTrace(result);
            return (T)result;
        }

        public <T> T invoke(TypeReference<T> typeReference) {
            Object result = this.jsonUtils.convert(this.doInvoke(), typeReference);
            this.doTrace(result);
            return (T)result;
        }

        private Object doInvoke() {
            ApiResponse result = this.invokeService.invoke(this.businessId, this.params);
            if (!this.unwrapApiResponse) {
                return result;
            }
            return LogicSupportUtils.unwrapApiResponse(result);
        }

        private void doTrace(Object result) {
            if (this.traceLogger == null) {
                return;
            }
            String message = this.traceMessage;
            if (StringUtils.isEmpty((CharSequence)message)) {
                message = String.format(DEFAULT_TRACE_MESSAGE, this.businessId);
            }
            this.traceLogger.trace(TRACE_LOG_MODEL_INVOKE, (Object)message, result);
        }
    }

    public static final class ScriptRunner {
        private final ScriptEngine engine;
        private final Bindings global;

        private ScriptRunner(String engineName) {
            ScriptEngineManager manager = new ScriptEngineManager();
            this.engine = manager.getEngineByName(engineName);
            this.global = this.engine.getBindings(100);
        }

        public static ScriptRunner forEngine(String engineName) {
            return new ScriptRunner(engineName);
        }

        public ScriptRunner bind(Map<String, Object> scope) {
            this.global.putAll((Map<? extends String, ? extends Object>)scope);
            return this;
        }

        public ScriptRunner bind(String name, Object value) {
            this.global.put(name, value);
            return this;
        }

        public Object eval(String script) {
            try {
                return this.engine.eval(script);
            }
            catch (ScriptException ex) {
                throw new HussarLogicScriptException((Throwable)ex);
            }
        }

        public <T> T eval(String script, Class<T> clazz) {
            return LogicSupportUtils.convert(this.eval(script), clazz);
        }

        public <T> T eval(String script, TypeReference<T> type) {
            return LogicSupportUtils.convert(this.eval(script), type);
        }
    }

    public static final class EntityBuilder<T> {
        private final HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = LogicSupportUtils.access$000();
        private final T entity;

        public EntityBuilder(Class<T> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            try {
                this.entity = this.entityUtils.createEntity(clazz);
            }
            catch (Exception ex) {
                throw new HussarLogicSupportException("failed to initiate " + clazz.getName(), ex);
            }
        }

        public EntityBuilder(TypeReference<T> typeReference) {
            Class clazz;
            if (typeReference == null) {
                throw new NullPointerException();
            }
            Type type = typeReference.getType();
            if (type instanceof Class) {
                clazz = (Class)type;
            } else if (type instanceof ParameterizedType) {
                clazz = (Class)((ParameterizedType)type).getRawType();
            } else {
                throw new HussarLogicSupportException("cannot initiate " + type);
            }
            try {
                this.entity = this.entityUtils.createEntity(clazz);
            }
            catch (Exception ex) {
                throw new HussarLogicSupportException("failed to initiate " + clazz.getName(), ex);
            }
        }

        public EntityBuilder(T entity) {
            if (entity == null) {
                throw new NullPointerException();
            }
            this.entity = entity;
        }

        public <U> EntityBuilder<T> set(BiConsumer<T, U> setter, U value) {
            setter.accept(this.entity, value);
            return this;
        }

        public EntityBuilder<T> set(String property, Object value) {
            try {
                this.entityUtils.setProperty(this.entity, property, value, true);
                return this;
            }
            catch (Exception ex) {
                throw new HussarLogicSupportException("failed to set property '" + property + "' for " + this.entity.getClass().getName(), ex);
            }
        }

        public EntityBuilder<T> set(T other) {
            if (other != null) {
                try {
                    this.entityUtils.copyProperties(this.entity, other);
                }
                catch (Exception ex) {
                    throw new HussarLogicSupportException("failed to copy properties from " + other.getClass().getName() + "' to " + this.entity.getClass().getName(), ex);
                }
            }
            return this;
        }

        public T build() {
            return this.entity;
        }
    }

    public static final class MapBuilder<K, V> {
        private final Map<K, V> map;

        public MapBuilder() {
            this.map = new LinkedHashMap();
        }

        public MapBuilder(int capacity) {
            this.map = new LinkedHashMap(capacity);
        }

        public MapBuilder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public MapBuilder<K, V> put(Map<? extends K, ? extends V> other) {
            if (other != null) {
                this.map.putAll(other);
            }
            return this;
        }

        public Map<K, V> build() {
            return this.map;
        }
    }

    public static final class ListBuilder<T> {
        private final List<T> list = new ArrayList<T>();

        public ListBuilder() {
        }

        public ListBuilder(int capacity) {
        }

        public ListBuilder<T> add(T item) {
            this.list.add(item);
            return this;
        }

        public ListBuilder<T> add(Collection<? extends T> other) {
            if (other != null) {
                this.list.addAll(other);
            }
            return this;
        }

        public List<T> build() {
            return this.list;
        }
    }
}

