/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.utils;

import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.logic.annotation.LogicManifest;
import com.jxdinfo.hussar.logic.exception.HussarLogicRuntimeMetadataException;
import com.jxdinfo.hussar.logic.exception.HussarLogicSourceMapException;
import com.jxdinfo.hussar.logic.structure.runtime.LogicRuntimeMetadata;
import com.jxdinfo.hussar.logic.structure.sourcemap.LogicSourceMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class LogicManifestUtils {
    private static final Pattern LOSSY_BASE64_PATTERN = Pattern.compile("^[A-Za-z0-9+/=]*$");
    private static final int STRING_LITERAL_CHARACTER_LIMIT = 8192;

    private LogicManifestUtils() {
    }

    public static LogicRuntimeMetadata reflectMetadata(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        LogicManifest annotation = clazz.getAnnotation(LogicManifest.class);
        if (annotation == null) {
            return null;
        }
        int level = annotation.level();
        LogicRuntimeMetadata metadata = LogicManifestUtils.decodeMetadata(LogicManifestUtils.fromLiteralSegments(annotation.metadata()), level);
        LogicSourceMap sourcemap = LogicManifestUtils.decodeSourceMap(LogicManifestUtils.fromLiteralSegments(annotation.sourcemap()), level);
        if (sourcemap != null) {
            if (metadata == null) {
                metadata = new LogicRuntimeMetadata();
            }
            metadata.setSourcemap(sourcemap);
        }
        return metadata;
    }

    public static String encodeMetadata(LogicRuntimeMetadata metadata) {
        return LogicManifestUtils.encodeMetadata(metadata, 1);
    }

    public static String encodeMetadata(LogicRuntimeMetadata metadata, int level) {
        switch (level) {
            case 1: {
                return LogicManifestUtils.encodeMetadata_Level_1_0(metadata);
            }
        }
        throw new HussarLogicRuntimeMetadataException("unsupported manifest level: " + level);
    }

    private static String encodeMetadata_Level_1_0(LogicRuntimeMetadata metadata) {
        byte[] json;
        if (metadata == null) {
            return null;
        }
        try {
            json = HussarIntegrationJsonUtils.toByteArray((Object)metadata);
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to serialize metadata", (Throwable)ex);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(output);){
            IOUtils.write((byte[])json, (OutputStream)gzip);
            gzip.finish();
        }
        catch (IOException ex) {
            throw new HussarLogicRuntimeMetadataException("failed to compress metadata", (Throwable)ex);
        }
        try {
            return Base64.getEncoder().encodeToString(output.toByteArray());
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to encode metadata", (Throwable)ex);
        }
    }

    public static LogicRuntimeMetadata decodeMetadata(String metadata) {
        return LogicManifestUtils.decodeMetadata(metadata, 1);
    }

    public static LogicRuntimeMetadata decodeMetadata(String metadata, int level) {
        switch (level) {
            case 1: {
                return LogicManifestUtils.decodeMetadata_Level_1_0(metadata);
            }
        }
        throw new HussarLogicRuntimeMetadataException("unsupported manifest level: " + level);
    }

    private static LogicRuntimeMetadata decodeMetadata_Level_1_0(String metadata) {
        byte[] json;
        byte[] compressed;
        if (StringUtils.isEmpty((CharSequence)metadata) || !LOSSY_BASE64_PATTERN.matcher(metadata).matches()) {
            return null;
        }
        try {
            compressed = Base64.getDecoder().decode(metadata);
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to decode metadata", (Throwable)ex);
        }
        try (GZIPInputStream gunzip = new GZIPInputStream(new ByteArrayInputStream(compressed));){
            json = IOUtils.toByteArray((InputStream)gunzip);
        }
        catch (IOException ex) {
            throw new HussarLogicRuntimeMetadataException("failed to decompress metadata", (Throwable)ex);
        }
        try {
            return (LogicRuntimeMetadata)HussarIntegrationJsonUtils.parse((byte[])json, LogicRuntimeMetadata.class);
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to deserialize metadata", (Throwable)ex);
        }
    }

    public static String encodeSourceMap(LogicSourceMap sourcemap) {
        return LogicManifestUtils.encodeSourceMap(sourcemap, 1);
    }

    public static String encodeSourceMap(LogicSourceMap sourcemap, int level) {
        switch (level) {
            case 1: {
                return LogicManifestUtils.encodeSourceMap_Level_1_0(sourcemap);
            }
        }
        throw new HussarLogicSourceMapException("unsupported manifest level: " + level);
    }

    private static String encodeSourceMap_Level_1_0(LogicSourceMap sourcemap) {
        byte[] bytes;
        if (sourcemap == null) {
            return null;
        }
        try {
            bytes = sourcemap.encode();
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to serialize sourcemap", (Throwable)ex);
        }
        try {
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to encode sourcemap", (Throwable)ex);
        }
    }

    public static LogicSourceMap decodeSourceMap(String sourcemap) {
        return LogicManifestUtils.decodeSourceMap(sourcemap, 1);
    }

    public static LogicSourceMap decodeSourceMap(String sourcemap, int level) {
        switch (level) {
            case 1: {
                return LogicManifestUtils.decodeSourceMap_Level_1_0(sourcemap);
            }
        }
        throw new HussarLogicSourceMapException("unsupported manifest level: " + level);
    }

    private static LogicSourceMap decodeSourceMap_Level_1_0(String sourcemap) {
        byte[] bytes;
        if (StringUtils.isEmpty((CharSequence)sourcemap) || !LOSSY_BASE64_PATTERN.matcher(sourcemap).matches()) {
            return null;
        }
        try {
            bytes = Base64.getDecoder().decode(sourcemap);
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to decode sourcemap", (Throwable)ex);
        }
        try {
            return LogicSourceMap.decode((byte[])bytes);
        }
        catch (Exception ex) {
            throw new HussarLogicRuntimeMetadataException("failed to deserialize sourcemap", (Throwable)ex);
        }
    }

    public static String[] toLiteralSegments(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return new String[0];
        }
        ArrayList<String> segments = new ArrayList<String>();
        int start = 0;
        while (start < value.length()) {
            int end = Math.min(start + 8192, value.length());
            if (end > 0 && end < value.length() && Character.isHighSurrogate(value.charAt(end - 1)) && Character.isLowSurrogate(value.charAt(end))) {
                --end;
            }
            segments.add(value.substring(start, end));
            start = end;
        }
        return segments.toArray(new String[0]);
    }

    public static String fromLiteralSegments(String[] segments) {
        segments = segments != null ? segments : new String[]{};
        int total = Arrays.stream(segments).filter(StringUtils::isNotEmpty).mapToInt(String::length).sum();
        StringBuilder builder = new StringBuilder(total);
        for (String segment : segments) {
            if (!StringUtils.isNotEmpty((CharSequence)segment)) continue;
            builder.append(segment);
        }
        return builder.toString();
    }
}

