/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.provider;

import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.logic.exception.HussarLogicSourceMapException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateProviderService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicEaiGenerateContext;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.context.LogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.provider.LogicGenerateProvider;
import com.jxdinfo.hussar.logic.generator.render.LogicRenderTemplate;
import com.jxdinfo.hussar.logic.generator.resolver.DefaultLogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.utils.BackendClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendCodeFormatUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendEaiClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendManifestGenerateUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicCanvasConvertUtils;
import com.jxdinfo.hussar.logic.properties.HussarLogicProperties;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendImportDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendMethodDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFileType;
import com.jxdinfo.hussar.logic.structure.internal.LogicInitialFieldRecord;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.structure.sourcemap.LogicSourceMap;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@LogicGenerateProviderService(value="com.jxdinfo.hussar.logic.generator.annotation.logicGenerateProviderService", name="backend-eai", taints={"language:java", "runtime:engine", "platform:eai"})
public class BackendLogicEaiGenerateProvider
implements LogicGenerateProvider {
    public static final String PROVIDER_NAME = "backend-eai";
    private final HussarLogicProperties properties;
    private static final String SERVICE_TEMPLATE_PATH = "/template/logic/eai/service.ftl";
    private static final String SERVICE_SPRING_CONTEXT_HOLDER_IMPORT = "com.jxdinfo.hussar.core.util.SpringContextHolder";
    private static final List<String> SERVICE_INITIAL_IMPORTS = Arrays.asList("java.lang.Override", "org.slf4j.Logger", "org.slf4j.LoggerFactory", "com.jxdinfo.hussar.logic.engine.api.LogicRuntime", "com.jxdinfo.hussar.logic.engine.context.LogicExecutionContext", "com.jxdinfo.hussar.logic.utils.LogicSupportUtils", "com.jxdinfo.hussar.logic.utils.LogicManifestUtils", "com.jxdinfo.hussar.logic.mixin.LogicRuntimeAware", "com.jxdinfo.hussar.logic.mixin.LogicExecutionContextAware", "com.jxdinfo.hussar.logic.mixin.LogicMetadataSupplier", "com.jxdinfo.hussar.logic.eai.utils.LogicEaiSupportUtils", "com.jxdinfo.hussar.logic.eai.service.LogicEaiSupportService", "com.jxdinfo.hussar.logic.structure.runtime.LogicRuntimeMetadata");
    private static final List<LogicInitialFieldRecord> SERVICE_INITIAL_FIELDS = Arrays.asList(LogicInitialFieldRecord.staticField((String)"logger", (String)"org.slf4j.Logger", (String)"logger.symbol"), LogicInitialFieldRecord.staticField((String)"metadata", (String)"com.jxdinfo.hussar.logic.structure.runtime.LogicRuntimeMetadata", (String)"runtime.metadata.symbol"), LogicInitialFieldRecord.instanceField((String)"runtime", (String)"com.jxdinfo.hussar.logic.engine.api.LogicRuntime", (String)"engine.runtime.symbol"), LogicInitialFieldRecord.instanceField((String)"execution", (String)"com.jxdinfo.hussar.logic.engine.context.LogicExecutionContext", (String)"engine.execution.symbol"), LogicInitialFieldRecord.instanceField((String)"support", (String)"com.jxdinfo.hussar.logic.eai.service.LogicEaiSupportService", (String)"eai.support.symbol"), LogicInitialFieldRecord.instanceField((String)"initialized", (String)"java.lang.Boolean"));
    private static final List<String> SERVICE_INITIAL_METHODS = Arrays.asList("invoke", "initialize", "getLogicRuntime", "setLogicRuntime", "getExecutionContext", "setExecutionContext", "getLogicMetadata");

    @Autowired
    public BackendLogicEaiGenerateProvider(HussarLogicProperties properties) {
        this.properties = properties;
    }

    public LogicGenerateResult generate(LogicGenerateSource source, LogicGenerateConfigure configure) {
        this.normalizeConfigure(configure);
        LogicMetadata metadata = LogicCanvasConvertUtils.convertMetadata((LogicGenerateSource)source);
        ArrayList<LogicGenerateFile> files = new ArrayList<LogicGenerateFile>();
        files.add(this.generateService(metadata, source, configure));
        LogicGenerateResult result = new LogicGenerateResult();
        result.setParameterNames(new ArrayList(metadata.getParameters().keySet()));
        result.setReturnsVoid(metadata.getResult() == null);
        result.setFiles(files);
        return result;
    }

    private void normalizeConfigure(LogicGenerateConfigure configure) {
        if (configure.getBackendExternalResolver() == null) {
            configure.setBackendExternalResolver((LogicBackendExternalResolver)new DefaultLogicBackendExternalResolver());
        }
        if (configure.getAllowCodeFormat() == null) {
            configure.setAllowCodeFormat(this.properties.getAllowCodeFormat());
        }
        configure.setAllowSourceMap(Boolean.valueOf(true));
        if (configure.getBackendAllowFieldShadowing() == null) {
            configure.setBackendAllowFieldShadowing(this.properties.getBackendAllowFieldShadowing());
        }
        if (configure.getAllowTraceLogging() == null) {
            configure.setAllowTraceLogging(Boolean.valueOf(true));
        }
        if (configure.getAllowCheckPermission() == null) {
            configure.setAllowCheckPermission(Boolean.valueOf(false));
        }
        if (configure.getAllowSwagger() == null) {
            configure.setAllowSwagger(Boolean.valueOf(false));
        }
    }

    private LogicGenerateFile generateService(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        LogicBackendImportDefinition serviceClass = BackendClassNameUtils.parseQualifiedClass((String)BackendEaiClassNameUtils.serviceQualifiedClassOf(metadata, configure));
        BackendLogicEaiGenerateContext context = new BackendLogicEaiGenerateContext(metadata, configure, source.getRoot(), serviceClass.getQualifiedClassName());
        for (String initialImport : SERVICE_INITIAL_IMPORTS) {
            context.addImport(initialImport);
        }
        for (LogicInitialFieldRecord initialField : SERVICE_INITIAL_FIELDS) {
            context.addInitialField(initialField);
        }
        for (String initialMethod : SERVICE_INITIAL_METHODS) {
            context.addPredefinedMethod(initialMethod);
        }
        List parameters = metadata.getParameters().values().stream().map(arg_0 -> ((BackendLogicEaiGenerateContext)context).addVariable(arg_0)).collect(Collectors.toList());
        LogicBackendVariableDefinition result = metadata.getResult() != null ? context.addVariable(metadata.getResult()) : null;
        LogicGeneratedCode meta = BackendManifestGenerateUtils.generateAnnotation((BackendLogicGenerateContext)context, this.getMetaInfoAttributes(configure));
        LogicGeneratedCode body = context.generate(source.getRoot(), new Object[0]);
        String springContextHolderClassName = null;
        List services = context.getServices();
        if (services != null && services.size() > 0) {
            springContextHolderClassName = context.addImport(SERVICE_SPRING_CONTEXT_HOLDER_IMPORT);
        }
        List methods = context.getMethods();
        LinkedHashMap<String, LogicGeneratedCode> slots = new LinkedHashMap<String, LogicGeneratedCode>();
        slots.put("meta", meta);
        slots.put("body", body);
        for (LogicBackendMethodDefinition method : methods) {
            slots.put("method_" + method.getName(), method.getBody());
        }
        LogicGeneratedCode raw = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)SERVICE_TEMPLATE_PATH).parameter("className", (Object)serviceClass.getSimpleName()).parameter("packageName", (Object)serviceClass.getPackageName()).parameter("springContextHolderName", (Object)springContextHolderClassName).parameter("imports", (Object)context.getImports()).parameter("services", (Object)context.getServices()).parameter("parameters", parameters).parameter("result", (Object)result).parameter("methods", (Object)methods).slots(slots).render();
        LogicGeneratedCode code = this.formatBackendCode(raw, configure);
        code = BackendManifestGenerateUtils.injectSourceMap((BackendLogicGenerateContext)context, (LogicGeneratedCode)code);
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendEaiClassNameUtils.serviceQualifiedClassOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.SERVICE_STANDALONE);
        file.setPath(BackendEaiClassNameUtils.serviceFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap((byte[])Optional.ofNullable(code.getSourceMap()).map(LogicSourceMap::encode).orElse(null));
        return file;
    }

    private Map<String, Object> getMetaInfoAttributes(LogicGenerateConfigure configure) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        Map eaiInfo = (Map)HussarIntegrationJsonUtils.convert((Object)configure.getEaiInfo(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (eaiInfo != null) {
            for (Map.Entry eaiInfoEntry : eaiInfo.entrySet()) {
                if (eaiInfoEntry.getValue() == null) continue;
                attributes.put((String)eaiInfoEntry.getKey(), eaiInfoEntry.getValue());
            }
        }
        return attributes;
    }

    private LogicGeneratedCode formatBackendCode(LogicGeneratedCode raw, LogicGenerateConfigure configure) {
        LogicGeneratedCode code;
        boolean allowCodeFormat = Optional.ofNullable(configure.getAllowCodeFormat()).orElse(true);
        boolean allowSourceMap = Optional.ofNullable(configure.getAllowSourceMap()).orElse(true);
        if (allowCodeFormat) {
            code = BackendCodeFormatUtils.format((LogicGeneratedCode)raw, (boolean)allowSourceMap);
        } else {
            code = new LogicGeneratedCode();
            code.setCode(raw.getCode());
            if (allowSourceMap) {
                if (raw.getSourceMap() == null) {
                    throw new HussarLogicSourceMapException("missing source map");
                }
                code.setSourceMap(raw.getSourceMap().optimize());
            }
        }
        return code;
    }
}

