/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.modelinvoke;

import com.jxdinfo.hussar.logic.component.backend.modelinvoke.AbstractLogicBackendModelInvokeVisitor;
import com.jxdinfo.hussar.logic.component.backend.modelinvoke.dto.LogicBackendModelInvokePropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendTypeReferenceUtils;
import com.jxdinfo.hussar.logic.generator.visitor.arguments.LogicBackendGenerateArguments;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendInvokeConvention;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendServiceMethod;
import com.jxdinfo.hussar.logic.structure.type.LogicBackendType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

@LogicGenerateVisitorService(component="com.jxdinfo.logic.BackendDataModelInvoke", taints={"language:java", "platform:low_code", "runtime:engine"})
public class LogicBackendEngineModelInvokeVisitor
extends AbstractLogicBackendModelInvokeVisitor {
    private static final String TEMPLATE_PATH = "/template/logic/backend/modelinvoke/engine_model_invoke.ftl";

    @Override
    protected LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendModelInvokePropsDto> component, LogicBackendGenerateArguments arguments, LogicBackendServiceMethod actualMethod, List<String> bindings, String resultName, LogicType resultType) {
        boolean flatten;
        LogicBackendInvokeConvention convention = Optional.ofNullable(actualMethod).map(LogicBackendServiceMethod::getInvokeConvention).orElseThrow(() -> new HussarLogicGenerateVisitorException("model invoke engine missing invoke convention"));
        String modelBusinessId = Optional.of(actualMethod).map(LogicBackendServiceMethod::getEngineBusinessId).orElseThrow(() -> new HussarLogicGenerateVisitorException("model invoke engine business id is not resolved"));
        List modelParameters = Optional.of(actualMethod).map(LogicBackendServiceMethod::getEngineParameters).orElse(Collections.emptyList());
        switch (convention) {
            case ENGINE_ARGUMENTS_AS_PARAMS: {
                flatten = false;
                break;
            }
            case ENGINE_BODY_AS_PARAMS: {
                flatten = true;
                break;
            }
            default: {
                throw new HussarLogicGenerateVisitorException("unsupported invoke convention for model invoke engine: " + convention);
            }
        }
        LinkedHashMap<String, Object> modelMethodArguments = new LinkedHashMap<String, Object>();
        LinkedHashMap modelSlotBindings = new LinkedHashMap();
        for (int i = 0; i < modelParameters.size(); ++i) {
            modelSlotBindings.put(modelParameters.get(i), i < bindings.size() ? bindings.get(i) : (String)modelParameters.get(i));
        }
        for (String argumentName : modelParameters) {
            LogicCanvasComponent argumentComponent = component.getSingletonSlot((String)modelSlotBindings.get(argumentName));
            if (argumentComponent == null) {
                throw new HussarLogicGenerateVisitorException("model invoke missing argument '" + argumentName + "'");
            }
            modelMethodArguments.put(argumentName, argumentComponent);
        }
        ArrayList<Pair> argumentList = new ArrayList<Pair>();
        LinkedHashMap<String, LogicGeneratedCode> argumentSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        for (Map.Entry entry : modelMethodArguments.entrySet()) {
            String slotName = "argument_" + (String)entry.getKey();
            LogicCanvasComponent argumentComponent = (LogicCanvasComponent)entry.getValue();
            LogicGeneratedCode argumentSlot = context.generate(argumentComponent, new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
            argumentList.add(Pair.of(entry.getKey(), (Object)slotName));
            argumentSlots.put(slotName, argumentSlot);
        }
        String logicSupportUtilsClassName = context.addImport(LogicSupportUtils.class.getName());
        LogicBackendVariableDefinition logicBackendVariableDefinition = resultType != null ? context.addVariable(LogicVariableDefinition.of((String)resultName, (LogicType)resultType)) : null;
        LogicGeneratedCode resultTypeReference = logicBackendVariableDefinition != null ? BackendTypeReferenceUtils.renderTypeReference((BackendLogicGenerateContext)context, (LogicBackendType)logicBackendVariableDefinition.getType()) : null;
        return context.beginTemplate(TEMPLATE_PATH).parameter("result", (Object)logicBackendVariableDefinition).parameter("flatten", (Object)flatten).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).parameter("businessId", (Object)modelBusinessId).parameter("arguments", argumentList).slots(argumentSlots).slot("resultType", resultTypeReference).render();
    }
}

