/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.wfdtoprocess.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.flowmodel.CallActivityElement;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.flowmodel.FlowSequence;
import com.jxdinfo.hussar.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.wfdtoprocess.service.WfdToProcessService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WfdToProcessServiceImpl
implements WfdToProcessService {
    private static final String COMPLETE_STATE = "finish";
    @Autowired
    private SysActProcessFileService sysActProcessFileService;

    @Override
    public JSONObject getProcessInfoByFile(String processIdentityKey, String processId, String tenantId) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(processIdentityKey, processId, tenantId);
        if (ToolUtil.isNotEmpty((Object)workFlow)) {
            JSONObject object;
            String xml = workFlow.getData();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                String realName;
                object = new JSONObject();
                object.put("id", (Object)flowObject.getNodeId());
                object.put("name", (Object)flowObject.getProps().getFlowName());
                object.put("x", (Object)Double.parseDouble(flowObject.getLeft()));
                object.put("y", (Object)Double.parseDouble(flowObject.getTop()));
                object.put("width", (Object)Double.parseDouble(flowObject.getWidth()));
                object.put("height", (Object)Double.parseDouble(flowObject.getHeight()));
                String[] name = flowObject.getName().split("\\.");
                String subName = name[name.length - 1];
                if (ToolUtil.equals((Object)"Start", (Object)subName)) {
                    realName = "startEvent";
                } else if (ToolUtil.equals((Object)"Exclusive", (Object)subName)) {
                    realName = "exclusiveGateway";
                } else if (ToolUtil.equals((Object)"Parallel", (Object)subName)) {
                    realName = "parallelGateway";
                } else if (ToolUtil.equals((Object)"Inclusive", (Object)subName)) {
                    realName = "inclusiveGateway";
                } else if (ToolUtil.equals((Object)"End", (Object)subName)) {
                    realName = "endEvent";
                } else if (ToolUtil.equals((Object)"CallActivity", (Object)subName)) {
                    realName = "callActivity";
                    List<CallActivityElement> callActivityElements = flowObject.getProps().getFlowSelectorArr();
                    JSONArray json = new JSONArray();
                    if (ToolUtil.isNotEmpty(callActivityElements)) {
                        for (CallActivityElement callActivityElement : callActivityElements) {
                            JSONObject jo = new JSONObject();
                            jo.put("superProcessKey", (Object)callActivityElement.getProcessDefinitionKey());
                            jo.put("superProcessName", (Object)callActivityElement.getName());
                            json.add((Object)jo);
                        }
                    }
                    object.put("callActivityElement", (Object)json);
                } else {
                    realName = "userTask";
                }
                object.put("type", (Object)realName);
                object.put("state", (Object)COMPLETE_STATE);
                jsonArray.add((Object)object);
            }
            for (FlowObject flowObject : flowModel.getSlots().getPath()) {
                object = new JSONObject();
                object.put("id", (Object)flowObject.getNodeId());
                object.put("name", (Object)flowObject.getProps().getFlowName());
                object.put("rotate", (Object)((FlowSequence)flowObject).getLineConfig().getRotate());
                object.put("dx", (Object)((FlowSequence)flowObject).getLineConfig().getDx());
                List<FlowSequenceXy> xyList = flowObject.getPoints();
                Double[] xPoints = new Double[xyList.size()];
                Double[] yPoints = new Double[xyList.size()];
                for (int i = 0; i < xyList.size(); ++i) {
                    xPoints[i] = Double.parseDouble(xyList.get(i).getX());
                    yPoints[i] = Double.parseDouble(xyList.get(i).getY());
                }
                object.put("xPoints", (Object)xPoints);
                object.put("yPoints", (Object)yPoints);
                object.put("type", (Object)"sequenceFlow");
                object.put("state", (Object)COMPLETE_STATE);
                jsonArray.add((Object)object);
            }
            jsonObject.put("data", (Object)jsonArray);
            jsonObject.put("width", (Object)flowModel.getWidth());
            jsonObject.put("height", (Object)flowModel.getHeight());
            return jsonObject;
        }
        return jsonObject;
    }
}

