/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpmntoxml.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.flowmodel.ExeListener;
import com.jxdinfo.hussar.flowmodel.ExtendTaskListener;
import com.jxdinfo.hussar.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.flowmodel.FlowSequence;
import com.jxdinfo.hussar.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.flowmodel.FlowVariables;
import com.jxdinfo.hussar.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.flowmodel.TimeOutStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.UserTask;

public final class FormBpmnUtil {
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");

    private FormBpmnUtil() {
    }

    public static GraphicInfo createGraphicInfo(FlowObject currentValue) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(Double.parseDouble(currentValue.getLeft().replace("px", "")));
        graphicInfo.setY(Double.parseDouble(currentValue.getTop().replace("px", "")));
        graphicInfo.setWidth(Double.parseDouble(currentValue.getWidth().replace("px", "")));
        graphicInfo.setHeight(Double.parseDouble(currentValue.getHeight().replace("px", "")));
        return graphicInfo;
    }

    public static List<GraphicInfo> createFlowGraphicInfo(FlowSequence currentValue) {
        ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
        for (FlowSequenceXy xy : currentValue.getPoints()) {
            GraphicInfo graphicInfo = new GraphicInfo();
            graphicInfo.setX(Double.parseDouble(xy.getX()));
            graphicInfo.setY(Double.parseDouble(xy.getY()));
            graphicInfoList.add(graphicInfo);
        }
        return graphicInfoList;
    }

    public static SequenceFlow createSequenceFlow(FlowSequence formSequence, List<FlowObject> element) {
        SequenceFlow flow = new SequenceFlow();
        flow.setId(formSequence.getId());
        flow.setName(formSequence.getName());
        flow.setSourceRef(FormBpmnUtil.getNodeId(formSequence.getStart().getKey(), element));
        flow.setTargetRef(FormBpmnUtil.getNodeId(formSequence.getEnd().getKey(), element));
        if (!formSequence.isFlowDefault()) {
            flow.setConditionExpression(formSequence.getProps().getBackFlowCondition());
        }
        return flow;
    }

    private static String getNodeId(String key, List<FlowObject> element) {
        String nodeId = key;
        for (FlowObject flowObject : element) {
            if (!key.equals(flowObject.getInstanceKey())) continue;
            nodeId = flowObject.getNodeId();
            break;
        }
        return nodeId;
    }

    public static void extendHandle(FlowObject flowObject, UserTask userTask) {
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowObject.getProps().getTodoConfiguration().getModalValue()));
        JSONArray assignmentNodes = (JSONArray)flowObject.getProps().getFlowAssignment().getParticipantConfigs();
        String assignmentNodeValue = "";
        if (ToolUtil.isNotEmpty((Object)assignmentNodes) && ToolUtil.isNotEmpty((Object)assignmentNodes.getJSONObject(0).getString("markedNode"))) {
            assignmentNodeValue = assignmentNodes.getJSONObject(0).getString("markedNode");
        }
        if (ToolUtil.isNotEmpty((Object)(assignmentNodes = (JSONArray)flowObject.getProps().getFlowRecipients().getCarbonCopyConfigs())) && ToolUtil.isNotEmpty((Object)assignmentNodes.getJSONObject(0).getString("markedNode"))) {
            assignmentNodeValue = assignmentNodeValue.length() > 0 ? assignmentNodeValue + "," : "";
            assignmentNodeValue = assignmentNodeValue + assignmentNodes.getJSONObject(0).getString("markedNode");
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("assignmentnode", assignmentNodeValue));
        String skiprepetition = flowObject.getProps().getFlowSkipRepetition();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("skiprepetition", skiprepetition));
        TimeOutStrategy timeOutStrategy = flowObject.getProps().getTimeOutStrategy();
        if (ToolUtil.isNotEmpty((Object)timeOutStrategy) && !"unHandle".equals(timeOutStrategy.getTimeoutStrategyType()) && ToolUtil.isNotEmpty((Object)timeOutStrategy.getTimeoutStrategyType())) {
            if ("outInterface".equals(timeOutStrategy.getTimeoutStrategyType())) {
                String path = timeOutStrategy.getOutInterface();
                userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("TimeOutStrategy", path));
            } else if (!"".equals(timeOutStrategy.getTimeoutStrategyType())) {
                userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("TimeOutStrategy", timeOutStrategy.getTimeoutStrategyType()));
            }
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("currentdept", "false"));
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("flowStarter", "false"));
        String formDetailAddress = flowObject.getProps().getFormDetailAddress();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("flowFormDetailKey", formDetailAddress));
    }

    public static void assigneeInstall(FlowObject flowObject, UserTask userTask, Map<String, String> map) {
        FlowAssignment flowAssignment = flowObject.getProps().getFlowAssignment();
        String strTemp = flowAssignment.getDefaultBackCondtion();
        userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("defaultAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
        List<JudgeBackCondition> judgeBackConditions = flowAssignment.getJudgeBackCondition();
        JSONObject jsonObject = new JSONObject();
        if (ToolUtil.isNotEmpty(judgeBackConditions)) {
            for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                jsonObject.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
            }
            userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("conditionAssign", jsonObject.toJSONString()));
        }
    }

    private static String getRealAssignee(String assignee, Map<String, String> map) {
        if (assignee != null && assignee.contains("@{")) {
            String realAssignee = assignee;
            Matcher matcher = REGEX.matcher(assignee);
            while (matcher.find()) {
                String functionString = matcher.group();
                realAssignee = realAssignee.replace(functionString, map.get(functionString.substring(2, functionString.length() - 2)));
            }
            return realAssignee;
        }
        return assignee;
    }

    public static void ccInstall(FlowObject jsonObject, UserTask userTask, Map<String, String> map) {
        FlowRecipients flowRecipients = jsonObject.getProps().getFlowRecipients();
        if (flowRecipients == null) {
            return;
        }
        String strTemp = flowRecipients.getDefaultCcCondtion();
        userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("defaultCcAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
        List<JudgeBackCondition> judgeCcConditions = flowRecipients.getJudgeCcCondition();
        JSONObject jsonObjectCc = new JSONObject();
        if (ToolUtil.isNotEmpty(judgeCcConditions)) {
            for (JudgeBackCondition judgeBackCondition : judgeCcConditions) {
                if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                jsonObjectCc.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
            }
            userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("conditionCcAssign", jsonObjectCc.toJSONString()));
        }
    }

    public static void addTaskListener(UserTask userTask, FlowObject flowObject) {
        List<ExeListener> taskListeners;
        ExtendTaskListener extendTaskListener = flowObject.getProps().getTaskListener();
        if (ToolUtil.isNotEmpty((Object)extendTaskListener) && ToolUtil.isNotEmpty(taskListeners = extendTaskListener.getTaskListener())) {
            for (ExeListener exeListener : taskListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendTaskListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                userTask.addExtensionElement(extensionElement);
            }
        }
    }

    public static ExtensionElement addExtensionElement(String name, String value) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(name);
        extensionElement.setNamespacePrefix("extend");
        extensionElement.setNamespace("http://activiti.org/bpmn");
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setName(name);
        extensionAttribute.setValue(ToolUtil.isEmpty((Object)value) ? "" : value);
        extensionElement.addAttribute(extensionAttribute);
        return extensionElement;
    }

    public static ExtensionAttribute addExtensionAttribute(String name, String value) {
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setNamespacePrefix("extend");
        extensionAttribute.setNamespace("http://activiti.org/bpmn");
        extensionAttribute.setName(name);
        extensionAttribute.setValue(ToolUtil.isEmpty((Object)value) ? "" : value);
        return extensionAttribute;
    }

    public static void addExeListener(FlowElement userTask, List<FlowVariables> useVariables, List<String> pathIds, boolean flag) {
        ActivitiListener activitiListener;
        ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
        boolean addStart = flag;
        boolean addEnd = flag;
        for (FlowVariables flowVariables : useVariables) {
            if (addStart && addEnd) break;
            if (pathIds.contains(flowVariables.getAction())) {
                addEnd = true;
                continue;
            }
            addStart = true;
        }
        if (addStart) {
            activitiListener = new ActivitiListener();
            activitiListener.setEvent("start");
            activitiListener.setImplementationType("class");
            activitiListener.setImplementation("com.jxdinfo.hussar.bpm.listener.GodAxeDefaultListener");
            executionListeners.add(activitiListener);
        }
        if (addEnd) {
            activitiListener = new ActivitiListener();
            activitiListener.setEvent("end");
            activitiListener.setImplementationType("class");
            activitiListener.setImplementation("com.jxdinfo.hussar.bpm.listener.GodAxeDefaultListener");
            executionListeners.add(activitiListener);
        }
        userTask.setExecutionListeners(executionListeners);
    }
}

