/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpmn2xml.visitor;

import com.jxdinfo.hussar.bpmn2xml.visitor.FormObjectVisitor;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import java.util.List;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.Exclusive")
public class ExclusiveGatewayVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, Process process, FlowModel flowModel) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(flowObject.getId());
        exclusiveGateway.setName(flowObject.getProps().getFlowName());
        exclusiveGateway.setDocumentation(flowObject.getProps().getFlowDescription());
        List<String> outSeqList = flowObject.getGoOutPathes();
        for (String seq : outSeqList) {
            for (FlowObject element : flowModel.getSlots().getPathAndElement()) {
                boolean isFlowDefault;
                if (!seq.equals(element.getInstanceKey()) || !(isFlowDefault = element.getProps().isFlowDefault())) continue;
                exclusiveGateway.setDefaultFlow(ExclusiveGatewayVisitor.getNodeId(seq, flowModel.getSlots().getElement()));
            }
        }
        process.addFlowElement((FlowElement)exclusiveGateway);
    }

    private static String getNodeId(String key, List<FlowObject> element) {
        String nodeId = key;
        for (FlowObject flowObject : element) {
            if (!key.equals(flowObject.getInstanceKey())) continue;
            nodeId = flowObject.getNodeId();
            break;
        }
        return nodeId;
    }
}

