/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpmn2xml.visitor;

import com.jxdinfo.hussar.bpmn2xml.visitor.FormObjectVisitor;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.flowmodel.MultiUser;
import com.jxdinfo.hussar.flowmodel.SubProps;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.CallActivity")
public class CallActivityVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, Process process, FlowModel flowModel) {
        List<SubProps> output;
        CallActivity callActivity = new CallActivity();
        callActivity.setId(flowObject.getId());
        callActivity.setName(flowObject.getProps().getFlowName());
        callActivity.setDocumentation(flowObject.getProps().getFlowDescription());
        callActivity.setCalledElement(flowObject.getProps().getFlowSelectorStr());
        List<SubProps> input = flowObject.getProps().getInput();
        if (ToolUtil.isNotEmpty(input)) {
            ArrayList<IOParameter> inList = new ArrayList<IOParameter>();
            for (SubProps subProps : input) {
                IOParameter ioParameter = new IOParameter();
                ioParameter.setSource(subProps.getResource());
                ioParameter.setTarget(subProps.getTarget());
                ioParameter.setSourceExpression(subProps.getResourceExpression());
                inList.add(ioParameter);
            }
            callActivity.setInParameters(inList);
        }
        if (ToolUtil.isNotEmpty(output = flowObject.getProps().getOutput())) {
            ArrayList<IOParameter> outList = new ArrayList<IOParameter>();
            for (SubProps subProps : output) {
                IOParameter ioParameter = new IOParameter();
                ioParameter.setSource(subProps.getResource());
                ioParameter.setTarget(subProps.getTarget());
                ioParameter.setSourceExpression(subProps.getResourceExpression());
                outList.add(ioParameter);
            }
            callActivity.setOutParameters(outList);
        }
        if (ToolUtil.isNotEmpty((Object)flowObject.getProps().getFlowCountersign())) {
            this.counterSign(flowObject, callActivity);
        }
        callActivity.setInheritVariables(true);
        process.addFlowElement((FlowElement)callActivity);
    }

    private void counterSign(FlowObject flowObject, CallActivity callActivity) {
        MultiUser multiUser = flowObject.getProps().getFlowCountersign();
        if (multiUser.isCountersign()) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
            multiInstanceLoopCharacteristics.setSequential(false);
            multiInstanceLoopCharacteristics.setInputDataItem("multi");
            if ("radio".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances/nrOfInstances >= " + multiUser.getCountersignNumByRatio() / 100.0 + " }");
            }
            if ("count".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances == " + multiUser.getCountersignNumByCount() + " }");
            }
            callActivity.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        }
    }
}

