/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpmn2xml.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bpmn2xml.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.bpmn2xml.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.bpmn2xml.model.UpdateByteArrayModel;
import com.jxdinfo.hussar.bpmn2xml.service.Bpm2XMLService;
import com.jxdinfo.hussar.bpmn2xml.util.FormBpmnUtil;
import com.jxdinfo.hussar.bpmn2xml.util.FormObjectVisitorBeanUtil;
import com.jxdinfo.hussar.bpmn2xml.visitor.FormObjectVisitor;
import com.jxdinfo.hussar.common.exception.BpmException;
import com.jxdinfo.hussar.common.exception.BpmExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.flowmodel.FlowProps;
import com.jxdinfo.hussar.flowmodel.FlowSequence;
import com.jxdinfo.hussar.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.flowmodel.LineConfig;
import com.jxdinfo.hussar.flowmodel.enums.BpmNodeTypeEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.activiti.validation.ProcessValidator;
import org.activiti.validation.ProcessValidatorFactory;
import org.activiti.validation.ValidationError;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class Bpm2XMLServiceImpl
implements Bpm2XMLService {
    @Autowired
    Bpm2XMLMapper bpm2XMLMapper;
    @Autowired
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    private final RepositoryService repositoryService;
    private SysActProcessFileService sysActProcessFileService;
    private String tenantId;

    @Autowired
    public Bpm2XMLServiceImpl(RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService) {
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
    }

    @Override
    public String formDataToXml(String tenantId, String identityKey) throws BpmException, IOException, XMLStreamException {
        this.tenantId = tenantId;
        FlowModel flowModel = this.readModel(identityKey);
        return this.genXMLByFlowModel(flowModel, identityKey);
    }

    private BpmnModel getXmlByFlowModel(FlowModel flowModel, String identityKey, WorkFlow workFlow) throws BpmException, IOException, XMLStreamException {
        if (flowModel == null) {
            return null;
        }
        ProcessDefinition latestProcessDefinition = (ProcessDefinition)BpmConstant.repositoryService.createProcessDefinitionQuery().processDefinitionKey(identityKey).latestVersion().singleResult();
        int processDefinitionVersion = latestProcessDefinition != null ? latestProcessDefinition.getVersion() + 1 : 1;
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        String processKeyDefault = "key-" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String processKey = workFlow.getIdentity();
        String modelName = workFlow.getName();
        process.setDocumentation(workFlow.getDesc());
        process.setName(ToolUtil.isEmpty((Object)modelName) ? "" : modelName);
        process.setId(ToolUtil.isEmpty((Object)processKey) ? processKeyDefault : processKey);
        FlowTodoCondition flowTodoCondition = flowModel.getProps().getTodoConfiguration();
        if (flowTodoCondition != null) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowTodoCondition.getModalValue()));
        } else {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", ""));
        }
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("version", String.valueOf(processDefinitionVersion)));
        String width = flowModel.getWidth();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasWidth", width));
        String height = flowModel.getHeight();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasHeight", height));
        this.packageProcess(flowModel, process, processKey, model);
        return this.convertXMLandValidate(model);
    }

    private String genXMLByFlowModel(FlowModel flowModel, String identityKey) throws BpmException, IOException, XMLStreamException {
        if (flowModel == null) {
            return null;
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, this.tenantId, Integer.valueOf(0));
        BpmnModel bpmnModel = this.getXmlByFlowModel(flowModel, identityKey, workFlow);
        return this.completeAndDeployModel(bpmnModel, workFlow.getName(), flowModel.getModelId(), workFlow.getDesc(), identityKey, workFlow.getCategory());
    }

    @Override
    public BpmnModel getBpmnModel(WorkFlow workFlow, String identityKey, String tenantId) {
        this.tenantId = tenantId;
        try {
            return this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), identityKey, workFlow);
        }
        catch (BpmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void packageProcess(FlowModel flowModel, Process process, String processKeyPath, BpmnModel model) throws BpmException {
        for (FlowObject element : flowModel.getSlots().getPathAndElement()) {
            element.setProcessKeyPath(processKeyPath);
            if (element.getName().equals(BpmNodeTypeEnum.BPM_SEQUENCE.getType())) {
                this.createSequence(flowModel.getSlots().getPath(), flowModel.getSlots().getElement(), element.getNodeId(), process, model);
                continue;
            }
            FormObjectVisitor formObjectVisitor = FormObjectVisitorBeanUtil.getVisitorBean(element.getName());
            formObjectVisitor.visit(element, process, flowModel);
            GraphicInfo graphicInfo = FormBpmnUtil.createGraphicInfo(element);
            model.addGraphicInfo(element.getId(), graphicInfo);
        }
        model.addProcess(process);
    }

    private FlowModel readModel(String identityKey) throws BpmException, IOException {
        if (ToolUtil.isEmpty((Object)identityKey)) {
            throw new BpmException(BpmExceptionEnum.NOT_FOUND_FILE, "FILE ID: " + identityKey);
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, this.tenantId, Integer.valueOf(0));
        if (ToolUtil.isNotEmpty((Object)workFlow)) {
            String xml = workFlow.getData();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
            if (ToolUtil.isNotEmpty((Object)workFlow)) {
                flowModel.setModelId(workFlow.getModelId());
            }
            return flowModel;
        }
        return null;
    }

    @Override
    public boolean updateModel(String identityKey, String tenantId) {
        if (ToolUtil.isEmpty((Object)identityKey)) {
            return false;
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, tenantId, Integer.valueOf(0));
        byte[] bpmnBytes = null;
        try {
            BpmnModel bpmnModel = this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), identityKey, workFlow);
            bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        }
        catch (BpmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        if (ToolUtil.isNotEmpty((Object)workFlow) && this.bpm2XMLMapper.updateModel(new String(bpmnBytes, StandardCharsets.UTF_8), workFlow.getModelId()) + this.bpm2XMLMapper.updateVersionModel(workFlow.getData(), this.bpm2XMLMapper.getActDefIdByModelId(workFlow.getModelId())) > 1) {
            BpmConstant.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(this.bpm2XMLMapper.getActDefIdByModelId(workFlow.getModelId())));
            return true;
        }
        return false;
    }

    @Override
    public boolean updateModel(WorkFlow workFlow, BpmnModel bpmnModel, String procDefId) {
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        if (ToolUtil.isNotEmpty((Object)workFlow)) {
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(bpmnBytes);
            updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelByProcDefId(procDefId));
            this.updateByteArrayModelMapper.updateById((Object)updateByteArrayModel);
            SysActProcessFile sysActProcessFile = new SysActProcessFile();
            sysActProcessFile.setContent(workFlow.getData());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PROCESS_ID", (Object)procDefId);
            queryWrapper.eq((Object)"TYPE", (Object)"wfd");
            this.sysActProcessFileService.update((Object)sysActProcessFile, (Wrapper)queryWrapper);
            BpmConstant.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(procDefId));
            return true;
        }
        return false;
    }

    @Override
    public String getActDefIdByModelId(String modelId) {
        return this.bpm2XMLMapper.getActDefIdByModelId(modelId);
    }

    private BpmnModel convertXMLandValidate(BpmnModel model) throws XMLStreamException, BpmException {
        BpmnXMLConverter converter = new BpmnXMLConverter();
        byte[] bytes = converter.convertToXML(model, "utf-8");
        XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
        InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
        XMLStreamReader xtr = xif.createXMLStreamReader(in);
        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        ProcessValidatorFactory processValidatorFactory = new ProcessValidatorFactory();
        ProcessValidator defaultProcessValidator = processValidatorFactory.createDefaultProcessValidator();
        List validate = defaultProcessValidator.validate(bpmnModel);
        if (!CollectionUtils.isEmpty((Collection)validate)) {
            String errorMsg = "";
            for (int i = 0; i < validate.size(); ++i) {
                errorMsg = errorMsg + ((ValidationError)validate.get(i)).getDefaultDescription() + "," + ((ValidationError)validate.get(i)).getActivityId();
                if (i == validate.size() - 1) continue;
                errorMsg = errorMsg + ";";
            }
            throw new BpmException(BpmExceptionEnum.BPM_XML_VALIDATE_FAIL, errorMsg);
        }
        return bpmnModel;
    }

    private Model newModel(ObjectNode modelObjectNode, String modelName, String key, String category) {
        Model modelData = this.repositoryService.newModel();
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setKey(StringUtils.defaultString((String)key));
        modelData.setCategory(category);
        modelData.setName(modelName);
        modelData.setTenantId(this.tenantId);
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private Model updateModel(ObjectNode modelObjectNode, String modelName, String modelId, String category) {
        Model modelData = this.repositoryService.getModel(modelId);
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(modelName);
        modelData.setCategory(category);
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private String deployModel(BpmnModel bpmnModel, Model modelData, String modelId) {
        ExtendBpmnJsonConverter child = new ExtendBpmnJsonConverter();
        child.updateConvertersToBpmnMap();
        child.updateConvertersToJsonMap();
        ObjectNode editorNode = child.convertToJson(bpmnModel);
        this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes(StandardCharsets.UTF_8));
        return modelId;
    }

    private String completeAndDeployModel(BpmnModel bpmnModel, String modelName, String modelId, String flowDesc, String identityKey, String category) {
        Model modelData;
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", modelName);
        modelObjectNode.put("description", flowDesc);
        if (ToolUtil.isEmpty((Object)modelId) || ToolUtil.isEmpty((Object)this.repositoryService.getModel(modelId))) {
            modelData = this.newModel(modelObjectNode, modelName, identityKey, category);
            modelId = modelData.getId();
        } else {
            modelData = this.updateModel(modelObjectNode, modelName, modelId, category);
        }
        return this.deployModel(bpmnModel, modelData, modelId);
    }

    private void createSequence(List<FlowSequence> allMapSeq, List<FlowObject> element, String formKey, Process process, BpmnModel bpmnModel) {
        for (FlowSequence formSequence : allMapSeq) {
            if (!formKey.equals(formSequence.getNodeId())) continue;
            FlowProps flowProps = formSequence.getProps();
            boolean isFlowDefault = flowProps.isFlowDefault();
            formSequence.setFlowDefault(isFlowDefault);
            formSequence.setName(flowProps.getFlowName());
            List<GraphicInfo> line = FormBpmnUtil.createFlowGraphicInfo(formSequence);
            SequenceFlow sequenceFlow = FormBpmnUtil.createSequenceFlow(formSequence, element);
            sequenceFlow.setDocumentation(flowProps.getFlowDescription());
            LineConfig lineConfig = formSequence.getLineConfig();
            if (lineConfig != null) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendSequenceflow");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute xAttribute = new ExtensionAttribute();
                xAttribute.setName("dx");
                xAttribute.setValue(lineConfig.getDx());
                extensionElement.addAttribute(xAttribute);
                ExtensionAttribute yAttribute = new ExtensionAttribute();
                yAttribute.setName("rotate");
                yAttribute.setValue(lineConfig.getRotate());
                extensionElement.addAttribute(yAttribute);
                sequenceFlow.addExtensionElement(extensionElement);
            }
            process.addFlowElement((FlowElement)sequenceFlow);
            bpmnModel.addFlowGraphicInfoList(formKey, line);
        }
    }
}

